/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.extras.api.AxisMarksProvider;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.support.DefaultViewportModel;
import org.netbeans.modules.dlight.extras.api.support.TimeMarksProvider;
import org.netbeans.modules.dlight.extras.api.support.ValueMarksProvider;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPainter;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

public final class TimeSeriesPlot
extends JComponent
implements ViewportAware,
ChangeListener,
DataFilterListener {
    private static final long EXTENT = 20000000000L;
    private final GraphPainter graph;
    private final Axis timeAxis;
    private final Axis valueAxis;
    private ViewportModel viewportModel;
    private final AxisMarksProvider timeMarksProvider;
    private final AxisMarksProvider valueMarksProvider;
    private final Object timeFilterLock = new Object();
    private volatile TimeIntervalDataFilter timeFilter;
    private final Updater updater = new Updater();
    private int upperLimit;

    public TimeSeriesPlot(int upperLimit, ValueFormatter formatter, List<TimeSeriesDescriptor> series, TimeSeriesDataContainer data) {
        this.upperLimit = upperLimit;
        TimeSeriesDataContainer container = data;
        container.setTimeSeriesPlot(this);
        this.graph = new GraphPainter(series, container);
        this.timeAxis = new Axis(AxisOrientation.HORIZONTAL);
        this.valueAxis = new Axis(AxisOrientation.VERTICAL);
        this.timeMarksProvider = TimeMarksProvider.newInstance();
        this.valueMarksProvider = ValueMarksProvider.newInstance((ValueFormatter)formatter);
        DefaultViewportModel model = new DefaultViewportModel(new Range((Number)0L, (Number)0L), new Range((Number)0L, (Number)20000000000L));
        model.setMinViewportSize(1000000000L);
        this.setViewportModel((ViewportModel)model);
        this.setOpaque(true);
    }

    public JComponent getVerticalAxis() {
        return this.valueAxis;
    }

    public JComponent getHorizontalAxis() {
        return this.timeAxis;
    }

    public void setUpperLimit(int newLimit) {
        if (newLimit != this.upperLimit) {
            this.upperLimit = newLimit;
            this.repaint();
            this.valueAxis.repaint();
        }
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public int calculateUpperLimit(float ... data) {
        return this.graph.calculateUpperLimit(data);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int filterEnd;
        int filterStart;
        FontMetrics xfm = g.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        FontMetrics yfm = g.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
        Range viewport = this.viewportModel.getViewport();
        List timeMarks = this.timeMarksProvider.getAxisMarks(((Long)viewport.getStart()).longValue(), ((Long)viewport.getEnd()).longValue(), this.getWidth(), xfm);
        List valueMarks = this.valueMarksProvider.getAxisMarks(0L, (long)this.upperLimit, this.getHeight() - yfm.getAscent() / 2, yfm);
        TimeIntervalDataFilter tmpTimeFilter = this.timeFilter;
        if (tmpTimeFilter != null) {
            Range filterInterval = tmpTimeFilter.getInterval();
            filterStart = filterInterval.getStart() == null ? Integer.MIN_VALUE : (int)TimeUnit.NANOSECONDS.toSeconds((Long)filterInterval.getStart());
            filterEnd = filterInterval.getEnd() == null ? Integer.MAX_VALUE : (int)TimeUnit.NANOSECONDS.toSeconds((Long)filterInterval.getEnd());
        } else {
            filterStart = Integer.MIN_VALUE;
            filterEnd = Integer.MAX_VALUE;
        }
        this.graph.paint(g, this.upperLimit, valueMarks, (int)((Long)viewport.getStart() / 1000000000L), (int)((Long)viewport.getEnd() / 1000000000L), timeMarks, filterStart, filterEnd, 0, 0, this.getWidth(), this.getHeight(), this.isEnabled());
    }

    public ViewportModel getViewportModel() {
        return this.viewportModel;
    }

    public void setViewportModel(ViewportModel viewportModel) {
        if (this.viewportModel != null) {
            this.viewportModel.removeChangeListener((ChangeListener)this);
        }
        this.viewportModel = viewportModel;
        this.viewportModel.addChangeListener((ChangeListener)this);
        this.repaintAll();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.viewportModel) {
            this.repaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataFilterManager(DataFilterManager filterManager) {
        if (filterManager != null) {
            filterManager.addDataFilterListener((DataFilterListener)this);
        } else {
            Object object = this.timeFilterLock;
            synchronized (object) {
                this.timeFilter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        TimeIntervalDataFilter newTimeFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, newSet);
        Object object = this.timeFilterLock;
        synchronized (object) {
            if (newTimeFilter != this.timeFilter) {
                this.timeFilter = newTimeFilter;
                UIThread.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TimeSeriesPlot.this.repaintAll();
                    }
                });
            }
        }
    }

    public void repaintAll() {
        UIThread.invoke((Runnable)this.updater);
    }

    private class Axis
    extends JComponent {
        private final AxisOrientation orientation;

        public Axis(AxisOrientation orientation) {
            this.orientation = orientation;
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isEnabled()) {
                switch (this.orientation) {
                    case VERTICAL: {
                        FontMetrics yfm = g.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
                        List valueMarks = TimeSeriesPlot.this.valueMarksProvider.getAxisMarks(0L, (long)TimeSeriesPlot.this.upperLimit, this.getHeight() - yfm.getAscent() / 2, yfm);
                        TimeSeriesPlot.this.graph.paintVerticalAxis(g, 0, 0, this.getWidth(), this.getHeight(), valueMarks, this.getBackground());
                        break;
                    }
                    case HORIZONTAL: {
                        Range viewport = TimeSeriesPlot.this.viewportModel.getViewport();
                        FontMetrics xfm = g.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
                        List timeMarks = TimeSeriesPlot.this.timeMarksProvider.getAxisMarks(((Long)viewport.getStart()).longValue(), ((Long)viewport.getEnd()).longValue(), this.getWidth(), xfm);
                        TimeSeriesPlot.this.graph.paintHorizontalAxis(g, 0, 0, this.getWidth(), this.getHeight(), timeMarks, this.getBackground());
                    }
                }
            }
        }
    }

    private class Updater
    implements Runnable {
        private Updater() {
        }

        @Override
        public void run() {
            TimeSeriesPlot.this.repaint();
            TimeSeriesPlot.this.timeAxis.repaint();
            TimeSeriesPlot.this.valueAxis.repaint();
        }
    }

    private static enum AxisOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

