/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.php.DiffElement;
import org.netbeans.modules.refactoring.php.RetoucheCommit;
import org.netbeans.modules.refactoring.php.findusages.PhpWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringUI;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PhpRenameRefactoringPlugin
extends PhpWhereUsedQueryPlugin {
    public PhpRenameRefactoringPlugin(RenameRefactoring refactoring) {
        super((AbstractRefactoring)refactoring);
    }

    @Override
    public Problem checkParameters() {
        String newName = this.getRefactoring().getNewName();
        if (newName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(PhpRenameRefactoringPlugin.class, (String)"MSG_Error_ElementEmpty"));
        }
        WhereUsedSupport usages = this.getUsages();
        String oldName = PhpRenameRefactoringUI.getElementName(usages.getName(), usages.getElementKind());
        if (newName.equals(oldName)) {
            return new Problem(true, NbBundle.getMessage(PhpRenameRefactoringPlugin.class, (String)"MSG_Error_SameName"));
        }
        return null;
    }

    public RenameRefactoring getRefactoring() {
        return (RenameRefactoring)this.refactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    @Override
    protected void refactorResults(WhereUsedSupport.Results results, RefactoringElementsBag refactoringElements) {
        ModificationResult modificationResult = new ModificationResult();
        Collection<WhereUsedElement> resultElements = results.getResultElements();
        for (WhereUsedElement whereUsedElement : resultElements) {
            this.refactorElement(modificationResult, whereUsedElement);
        }
        refactoringElements.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add(this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
    }

    private void refactorElement(ModificationResult modificationResult, WhereUsedElement whereUsedElement) {
        ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, whereUsedElement.getPosition().getBegin(), whereUsedElement.getPosition().getEnd(), whereUsedElement.getName(), this.getRefactoring().getNewName(), whereUsedElement.getDisplayText()));
        if (!diffs.isEmpty()) {
            modificationResult.addDifferences(whereUsedElement.getFile(), diffs);
        }
    }
}

