/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.structure.formatting.TextBounds;

public class JoinedTokenSequence {
    private TokenSequence[] tokenSequences;
    private TextBounds[] tokenSequenceBounds;
    private int currentTokenSequence = -1;

    public JoinedTokenSequence(TokenSequence[] tokenSequences, TextBounds[] tokenSequenceBounds) {
        this.tokenSequences = tokenSequences;
        this.tokenSequenceBounds = tokenSequenceBounds;
    }

    public Token token() {
        return this.currentTokenSequence().token();
    }

    public TokenSequence currentTokenSequence() {
        return this.tokenSequences[this.currentTokenSequence];
    }

    public void moveStart() {
        this.currentTokenSequence = 0;
        this.currentTokenSequence().moveStart();
    }

    public boolean moveNext() {
        boolean moreTokens = this.currentTokenSequence().moveNext();
        if (!moreTokens) {
            if (this.currentTokenSequence + 1 < this.tokenSequences.length) {
                ++this.currentTokenSequence;
                this.currentTokenSequence().moveStart();
                this.moveNext();
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean movePrevious() {
        boolean moreTokens = this.currentTokenSequence().movePrevious();
        if (!moreTokens) {
            if (this.currentTokenSequence > 0) {
                --this.currentTokenSequence;
                this.currentTokenSequence().moveEnd();
                this.movePrevious();
            } else {
                return false;
            }
        }
        return true;
    }

    public int move(int offset) {
        for (int i = 0; i < this.tokenSequences.length; ++i) {
            if (this.tokenSequenceBounds[i].getAbsoluteStart() > offset || this.tokenSequenceBounds[i].getAbsoluteEnd() <= offset) continue;
            this.currentTokenSequence = i;
            return this.currentTokenSequence().move(offset);
        }
        return Integer.MIN_VALUE;
    }

    boolean isJustAfterGap() {
        boolean justAfterGap;
        boolean bl = justAfterGap = !this.currentTokenSequence().movePrevious();
        if (justAfterGap) {
            this.currentTokenSequence().moveStart();
        }
        this.currentTokenSequence().moveNext();
        return justAfterGap;
    }

    public int offset() {
        return this.currentTokenSequence().offset();
    }

    public TokenSequence embedded() {
        return this.currentTokenSequence().embedded();
    }
}

