/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.php.editor.indent.FmtOptions;

public final class CodeStyle {
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle get(Preferences prefs) {
        return new CodeStyle(prefs);
    }

    public static CodeStyle get(Document doc) {
        return new CodeStyle(CodeStylePreferences.get((Document)doc).getPreferences());
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
    }

    public int getIndentSize() {
        return this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public int getItemsInArrayDeclarationIndentSize() {
        return this.preferences.getInt("itemsInArrayDeclarationIndentSize", FmtOptions.getDefaultAsInt("itemsInArrayDeclarationIndentSize"));
    }

    public int getInitialIndent() {
        return this.preferences.getInt("init.indent", FmtOptions.getDefaultAsInt("init.indent"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }

    public BracePlacement getClassDeclBracePlacement() {
        String placement = this.preferences.get("classDeclBracePlacement", FmtOptions.getDefaultAsString("classDeclBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getMethodDeclBracePlacement() {
        String placement = this.preferences.get("methodDeclBracePlacement", FmtOptions.getDefaultAsString("methodDeclBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getIfBracePlacement() {
        String placement = this.preferences.get("ifBracePlacement", FmtOptions.getDefaultAsString("ifBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getForBracePlacement() {
        String placement = this.preferences.get("forBracePlacement", FmtOptions.getDefaultAsString("forBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getWhileBracePlacement() {
        String placement = this.preferences.get("whileBracePlacement", FmtOptions.getDefaultAsString("whileBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getSwitchBracePlacement() {
        String placement = this.preferences.get("switchBracePlacement", FmtOptions.getDefaultAsString("switchBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getCatchBracePlacement() {
        String placement = this.preferences.get("catchBracePlacement", FmtOptions.getDefaultAsString("catchBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public BracePlacement getOtherBracePlacement() {
        String placement = this.preferences.get("otherBracePlacement", FmtOptions.getDefaultAsString("otherBracePlacement"));
        return BracePlacement.valueOf(placement);
    }

    public int getBlankLinesBeforeNamespace() {
        return this.preferences.getInt("blankLinesBeforeNamespace", FmtOptions.getDefaultAsInt("blankLinesBeforeNamespace"));
    }

    public int getBlankLinesAfterNamespace() {
        return this.preferences.getInt("blankLinesAfterNamespace", FmtOptions.getDefaultAsInt("blankLinesAfterNamespace"));
    }

    public int getBlankLinesBeforeUse() {
        return this.preferences.getInt("blankLinesBeforeUse", FmtOptions.getDefaultAsInt("blankLinesBeforeUse"));
    }

    public int getBlankLinesAfterUse() {
        return this.preferences.getInt("blankLinesAfterUse", FmtOptions.getDefaultAsInt("blankLinesAfterUse"));
    }

    public int getBlankLinesBeforeClass() {
        return this.preferences.getInt("blankLinesBeforeClass", FmtOptions.getDefaultAsInt("blankLinesBeforeClass"));
    }

    public int getBlankLinesAfterClass() {
        return this.preferences.getInt("blankLinesAfterClass", FmtOptions.getDefaultAsInt("blankLinesAfterClass"));
    }

    public int getBlankLinesAfterClassHeader() {
        return this.preferences.getInt("blankLinesAfterClassHeader", FmtOptions.getDefaultAsInt("blankLinesAfterClassHeader"));
    }

    public int getBlankLinesBeforeClassEnd() {
        return this.preferences.getInt("blankLinesBeforeClassEnd", FmtOptions.getDefaultAsInt("blankLinesBeforeClassEnd"));
    }

    public int getBlankLinesBeforeField() {
        return this.preferences.getInt("blankLinesBeforeField", FmtOptions.getDefaultAsInt("blankLinesBeforeField"));
    }

    public int getBlankLinesAfterField() {
        return this.preferences.getInt("blankLinesAfterField", FmtOptions.getDefaultAsInt("blankLinesAfterField"));
    }

    public int getBlankLinesBeforeFunction() {
        return this.preferences.getInt("blankLinesBeforeFunction", FmtOptions.getDefaultAsInt("blankLinesBeforeFunction"));
    }

    public int getBlankLinesAfterFunction() {
        return this.preferences.getInt("blankLinesAfterFunction", FmtOptions.getDefaultAsInt("blankLinesAfterFunction"));
    }

    public int getBlankLinesBeforeFunctionEnd() {
        return this.preferences.getInt("blankLinesBeforeFunctionEnd", FmtOptions.getDefaultAsInt("blankLinesBeforeFunctionEnd"));
    }

    public int getBlankLinesAfterOpenPHPTag() {
        return this.preferences.getInt("blankLinesAfterOpenPHPTag", FmtOptions.getDefaultAsInt("blankLinesAfterOpenPHPTag"));
    }

    public int getBlankLinesAfterOpenPHPTagInHTML() {
        return this.preferences.getInt("blankLinesAfterOpenPHPTagInHTML", FmtOptions.getDefaultAsInt("blankLinesAfterOpenPHPTagInHTML"));
    }

    public int getBlankLinesBeforeClosePHPTag() {
        return this.preferences.getInt("blankLinesBeforeClosePHPTag", FmtOptions.getDefaultAsInt("blankLinesBeforeClosePHPTag"));
    }

    public boolean spaceBeforeWhile() {
        return this.preferences.getBoolean("spaceBeforeWhile", FmtOptions.getDefaultAsBoolean("spaceBeforeWhile"));
    }

    public boolean spaceBeforeElse() {
        return this.preferences.getBoolean("spaceBeforeElse", FmtOptions.getDefaultAsBoolean("spaceBeforeElse"));
    }

    public boolean spaceBeforeCatch() {
        return this.preferences.getBoolean("spaceBeforeCatch", FmtOptions.getDefaultAsBoolean("spaceBeforeCatch"));
    }

    public boolean spaceBeforeMethodDeclParen() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclParen", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodDeclParen"));
    }

    public boolean spaceBeforeMethodCallParen() {
        return this.preferences.getBoolean("spaceBeforeMethodCallParen", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodCallParen"));
    }

    public boolean spaceBeforeIfParen() {
        return this.preferences.getBoolean("spaceBeforeIfParen", FmtOptions.getDefaultAsBoolean("spaceBeforeIfParen"));
    }

    public boolean spaceBeforeForParen() {
        return this.preferences.getBoolean("spaceBeforeForParen", FmtOptions.getDefaultAsBoolean("spaceBeforeForParen"));
    }

    public boolean spaceBeforeWhileParen() {
        return this.preferences.getBoolean("spaceBeforeWhileParen", FmtOptions.getDefaultAsBoolean("spaceBeforeWhileParen"));
    }

    public boolean spaceBeforeCatchParen() {
        return this.preferences.getBoolean("spaceBeforeCatchParen", FmtOptions.getDefaultAsBoolean("spaceBeforeCatchParen"));
    }

    public boolean spaceBeforeSwitchParen() {
        return this.preferences.getBoolean("spaceBeforeSwitchParen", FmtOptions.getDefaultAsBoolean("spaceBeforeSwitchParen"));
    }

    public boolean spaceBeforeArrayDeclParen() {
        return this.preferences.getBoolean("spaceBeforeArrayDeclParen", FmtOptions.getDefaultAsBoolean("spaceBeforeArrayDeclParen"));
    }

    public boolean spaceAroundUnaryOps() {
        return this.preferences.getBoolean("spaceAroundUnaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundUnaryOps"));
    }

    public boolean spaceAroundBinaryOps() {
        return this.preferences.getBoolean("spaceAroundBinaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundBinaryOps"));
    }

    public boolean spaceAroundStringConcatOps() {
        return this.preferences.getBoolean("spaceAroundStringConcatOps", FmtOptions.getDefaultAsBoolean("spaceAroundStringConcatOps"));
    }

    public boolean spaceAroundTernaryOps() {
        return this.preferences.getBoolean("spaceAroundTernaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundTernaryOps"));
    }

    public boolean spaceAroundKeyValueOps() {
        return this.preferences.getBoolean("spaceAroundKeyValueOps", FmtOptions.getDefaultAsBoolean("spaceAroundKeyValueOps"));
    }

    public boolean spaceAroundAssignOps() {
        return this.preferences.getBoolean("spaceAroundAssignOps", FmtOptions.getDefaultAsBoolean("spaceAroundAssignOps"));
    }

    public boolean spaceAroundObjectOps() {
        return this.preferences.getBoolean("spaceAroundObjectOps", FmtOptions.getDefaultAsBoolean("spaceAroundObjectOps"));
    }

    public boolean spaceBeforeClassDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeClassDeclLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeClassDeclLeftBrace"));
    }

    public boolean spaceBeforeMethodDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodDeclLeftBrace"));
    }

    public boolean spaceBeforeIfLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeIfLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeIfLeftBrace"));
    }

    public boolean spaceBeforeElseLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeElseLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeElseLeftBrace"));
    }

    public boolean spaceBeforeWhileLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeWhileLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeWhileLeftBrace"));
    }

    public boolean spaceBeforeForLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeForLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeForLeftBrace"));
    }

    public boolean spaceBeforeDoLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeDoLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeDoLeftBrace"));
    }

    public boolean spaceBeforeSwitchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeSwitchLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeSwitchLeftBrace"));
    }

    public boolean spaceBeforeTryLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeTryLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeTryLeftBrace"));
    }

    public boolean spaceBeforeCatchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeCatchLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeCatchLeftBrace"));
    }

    public boolean spaceWithinMethodDeclParens() {
        return this.preferences.getBoolean("spaceWithinMethodDeclParens", FmtOptions.getDefaultAsBoolean("spaceWithinMethodDeclParens"));
    }

    public boolean spaceWithinMethodCallParens() {
        return this.preferences.getBoolean("spaceWithinMethodCallParens", FmtOptions.getDefaultAsBoolean("spaceWithinMethodCallParens"));
    }

    public boolean spaceWithinIfParens() {
        return this.preferences.getBoolean("spaceWithinIfParens", FmtOptions.getDefaultAsBoolean("spaceWithinIfParens"));
    }

    public boolean spaceWithinForParens() {
        return this.preferences.getBoolean("spaceWithinForParens", FmtOptions.getDefaultAsBoolean("spaceWithinForParens"));
    }

    public boolean spaceWithinWhileParens() {
        return this.preferences.getBoolean("spaceWithinWhileParens", FmtOptions.getDefaultAsBoolean("spaceWithinWhileParens"));
    }

    public boolean spaceWithinSwitchParens() {
        return this.preferences.getBoolean("spaceWithinSwitchParens", FmtOptions.getDefaultAsBoolean("spaceWithinSwitchParens"));
    }

    public boolean spaceWithinCatchParens() {
        return this.preferences.getBoolean("spaceWithinCatchParens", FmtOptions.getDefaultAsBoolean("spaceWithinCatchParens"));
    }

    public boolean spaceWithinTypeCastParens() {
        return this.preferences.getBoolean("spaceWithinTypeCastParens", FmtOptions.getDefaultAsBoolean("spaceWithinTypeCastParens"));
    }

    public boolean spaceWithinArrayDeclParens() {
        return this.preferences.getBoolean("spaceWithinArrayDeclParens", FmtOptions.getDefaultAsBoolean("spaceWithinArrayDeclParens"));
    }

    public boolean spaceWithinArrayBrackets() {
        return this.preferences.getBoolean("spaceWithinArrayBrackets", FmtOptions.getDefaultAsBoolean("spaceWithinArrayBrackets"));
    }

    public boolean spaceBeforeComma() {
        return this.preferences.getBoolean("spaceBeforeComma", FmtOptions.getDefaultAsBoolean("spaceBeforeComma"));
    }

    public boolean spaceAfterComma() {
        return this.preferences.getBoolean("spaceAfterComma", FmtOptions.getDefaultAsBoolean("spaceAfterComma"));
    }

    public boolean spaceBeforeSemi() {
        return this.preferences.getBoolean("spaceBeforeSemi", FmtOptions.getDefaultAsBoolean("spaceBeforeSemi"));
    }

    public boolean spaceAfterSemi() {
        return this.preferences.getBoolean("spaceAfterSemi", FmtOptions.getDefaultAsBoolean("spaceAfterSemi"));
    }

    public boolean spaceAfterTypeCast() {
        return this.preferences.getBoolean("spaceAfterTypeCast", FmtOptions.getDefaultAsBoolean("spaceAfterTypeCast"));
    }

    public boolean spaceCheckAfterKeywords() {
        return this.preferences.getBoolean("spaceCheckAfterKeywords", FmtOptions.getDefaultAsBoolean("spaceCheckAfterKeywords"));
    }

    public boolean spaceBeforeClosePHPTag() {
        return this.preferences.getBoolean("spaceBeforeClosePHPTag", FmtOptions.getDefaultAsBoolean("spaceBeforeClosePHPTag"));
    }

    public boolean alignMultilineMethodParams() {
        return this.preferences.getBoolean("alignMultilineMethodParams", FmtOptions.getDefaultAsBoolean("alignMultilineMethodParams"));
    }

    public boolean alignMultilineCallArgs() {
        return this.preferences.getBoolean("alignMultilineCallArgs", FmtOptions.getDefaultAsBoolean("alignMultilineCallArgs"));
    }

    public boolean alignMultilineImplements() {
        return this.preferences.getBoolean("alignMultilineImplements", FmtOptions.getDefaultAsBoolean("alignMultilineImplements"));
    }

    public boolean alignMultilineParenthesized() {
        return this.preferences.getBoolean("alignMultilineParenthesized", FmtOptions.getDefaultAsBoolean("alignMultilineParenthesized"));
    }

    public boolean alignMultilineBinaryOp() {
        return this.preferences.getBoolean("alignMultilineBinaryOp", FmtOptions.getDefaultAsBoolean("alignMultilineBinaryOp"));
    }

    public boolean alignMultilineTernaryOp() {
        return this.preferences.getBoolean("alignMultilineTernaryOp", FmtOptions.getDefaultAsBoolean("alignMultilineTernaryOp"));
    }

    public boolean alignMultilineAssignment() {
        return this.preferences.getBoolean("alignMultilineAssignment", FmtOptions.getDefaultAsBoolean("alignMultilineAssignment"));
    }

    public boolean alignMultilineFor() {
        return this.preferences.getBoolean("alignMultilineFor", FmtOptions.getDefaultAsBoolean("alignMultilineFor"));
    }

    public boolean alignMultilineArrayInit() {
        return this.preferences.getBoolean("alignMultilineArrayInit", FmtOptions.getDefaultAsBoolean("alignMultilineArrayInit"));
    }

    public boolean placeElseOnNewLine() {
        return this.preferences.getBoolean("placeElseOnNewLine", FmtOptions.getDefaultAsBoolean("placeElseOnNewLine"));
    }

    public boolean placeWhileOnNewLine() {
        return this.preferences.getBoolean("placeWhileOnNewLine", FmtOptions.getDefaultAsBoolean("placeWhileOnNewLine"));
    }

    public boolean placeCatchOnNewLine() {
        return this.preferences.getBoolean("placeCatchOnNewLine", FmtOptions.getDefaultAsBoolean("placeCatchOnNewLine"));
    }

    public boolean placeNewLineAfterModifiers() {
        return this.preferences.getBoolean("placeNewLineAfterModifiers", FmtOptions.getDefaultAsBoolean("placeNewLineAfterModifiers"));
    }

    public WrapStyle wrapExtendsImplementsKeyword() {
        String wrap = this.preferences.get("wrapExtendsImplementsKeyword", FmtOptions.getDefaultAsString("wrapExtendsImplementsKeyword"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapExtendsImplementsList() {
        String wrap = this.preferences.get("wrapExtendsImplementsList", FmtOptions.getDefaultAsString("wrapExtendsImplementsList"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapMethodParams() {
        String wrap = this.preferences.get("wrapMethodParams", FmtOptions.getDefaultAsString("wrapMethodParams"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapMethodCallArgs() {
        String wrap = this.preferences.get("wrapMethodCallArgs", FmtOptions.getDefaultAsString("wrapMethodCallArgs"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapChainedMethodCalls() {
        String wrap = this.preferences.get("wrapChainedMethodCalls", FmtOptions.getDefaultAsString("wrapChainedMethodCalls"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapArrayInit() {
        String wrap = this.preferences.get("wrapArrayInit", FmtOptions.getDefaultAsString("wrapArrayInit"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapFor() {
        String wrap = this.preferences.get("wrapFor", FmtOptions.getDefaultAsString("wrapFor"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapForStatement() {
        String wrap = this.preferences.get("wrapForStatement", FmtOptions.getDefaultAsString("wrapForStatement"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapIfStatement() {
        String wrap = this.preferences.get("wrapIfStatement", FmtOptions.getDefaultAsString("wrapIfStatement"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapWhileStatement() {
        String wrap = this.preferences.get("wrapWhileStatement", FmtOptions.getDefaultAsString("wrapWhileStatement"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapDoWhileStatement() {
        String wrap = this.preferences.get("wrapDoWhileStatement", FmtOptions.getDefaultAsString("wrapDoWhileStatement"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapBinaryOps() {
        String wrap = this.preferences.get("wrapBinaryOps", FmtOptions.getDefaultAsString("wrapBinaryOps"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapTernaryOps() {
        String wrap = this.preferences.get("wrapTernaryOps", FmtOptions.getDefaultAsString("wrapTernaryOps"));
        return WrapStyle.valueOf(wrap);
    }

    public WrapStyle wrapAssignOps() {
        String wrap = this.preferences.get("wrapAssignOps", FmtOptions.getDefaultAsString("wrapAssignOps"));
        return WrapStyle.valueOf(wrap);
    }

    public boolean wrapBlockBrace() {
        return this.preferences.getBoolean("wrapBlockBraces", FmtOptions.getDefaultAsBoolean("wrapBlockBraces"));
    }

    public boolean wrapStatementsOnTheSameLine() {
        return this.preferences.getBoolean("wrapStateMentsOnTheLine", FmtOptions.getDefaultAsBoolean("wrapStateMentsOnTheLine"));
    }

    static {
        FmtOptions.codeStyleProducer = new Producer();
    }

    public static enum WrapStyle {
        WRAP_ALWAYS,
        WRAP_IF_LONG,
        WRAP_NEVER;

    }

    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_INDENTED,
        PRESERVE_EXISTING;

    }

    private static class Producer
    implements FmtOptions.CodeStyleProducer {
        private Producer() {
        }

        @Override
        public CodeStyle create(Preferences preferences) {
            return new CodeStyle(preferences);
        }
    }
}

