/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

final class PHPSQLStatement {
    private final String generatedStatement;
    private int statementOffset;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();

    public static PHPSQLStatement computeSQLStatement(final Document document, final int caretOffset) {
        final PHPSQLStatement[] result = new PHPSQLStatement[]{null};
        document.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence<PHPTokenId> seq = LexUtilities.getPHPTokenSequence(document, caretOffset);
                if (seq == null) {
                    return;
                }
                PHPSQLStatement stmt = new PHPSQLStatement(seq, caretOffset);
                if (stmt.getStatement() != null) {
                    result[0] = stmt;
                }
            }
        });
        return result[0];
    }

    public static boolean couldBeSQL(TokenSequence seq) {
        String potentialStatement = ((Object)seq.token().text()).toString();
        if (potentialStatement.startsWith("\"") || potentialStatement.startsWith("'")) {
            potentialStatement = potentialStatement.substring(1);
        }
        return (potentialStatement = potentialStatement.toLowerCase().trim()).startsWith("select") || potentialStatement.startsWith("insert") || potentialStatement.startsWith("update") || potentialStatement.startsWith("delete") || potentialStatement.startsWith("drop");
    }

    private PHPSQLStatement(TokenSequence seq, int caretOffset) {
        this.generatedStatement = this.generateSQLStatement((TokenSequence<PHPTokenId>)seq, caretOffset);
    }

    public int getStatementOffset() {
        return this.statementOffset;
    }

    public String getStatement() {
        return this.generatedStatement;
    }

    public int generatedToSourcePos(int generatedOffset) {
        CodeBlockData codeBlock = this.getCodeBlockAtGeneratedOffset(generatedOffset);
        if (codeBlock == null) {
            return -1;
        }
        int offsetWithinBlock = generatedOffset - codeBlock.generatedStart;
        int sourceOffset = codeBlock.sourceStart + offsetWithinBlock;
        if (sourceOffset <= codeBlock.sourceEnd) {
            return sourceOffset;
        }
        return codeBlock.sourceEnd;
    }

    public int sourceToGeneratedPos(int sourceOffset) {
        CodeBlockData codeBlock = this.getCodeBlockAtSourceOffset(sourceOffset);
        if (codeBlock == null) {
            return -1;
        }
        int generatedPos = -1;
        int offsetWithinBlock = sourceOffset - codeBlock.sourceStart;
        int generatedOffset = codeBlock.generatedStart + offsetWithinBlock;
        generatedPos = generatedOffset <= codeBlock.generatedEnd ? generatedOffset : codeBlock.generatedEnd;
        return generatedPos;
    }

    private String generateSQLStatement(TokenSequence<PHPTokenId> seq, int caretOffset) {
        this.statementOffset = StringFinder.findStringBegin(seq, caretOffset);
        if (this.statementOffset < 0) {
            return null;
        }
        int stringEnd = StringFinder.findStringEnd(seq, caretOffset);
        if (stringEnd < 0) {
            return null;
        }
        if (stringEnd <= this.statementOffset || caretOffset < this.statementOffset || caretOffset > stringEnd) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean inVariable = false;
        boolean concatenating = false;
        seq.move(this.statementOffset);
        seq.moveNext();
        if (!PHPSQLStatement.couldBeSQL(seq)) {
            return null;
        }
        do {
            String text = ((Object)seq.token().text()).toString();
            block0 : switch ((PHPTokenId)seq.token().id()) {
                case PHP_ENCAPSED_AND_WHITESPACE: {
                    concatenating = false;
                    if (inVariable) {
                        this.addUnknownCodeBlock(seq, buf);
                        break;
                    }
                    this.addCodeBlock(seq, text, buf);
                    break;
                }
                case PHP_CONSTANT_ENCAPSED_STRING: {
                    if (this.lastBlockIsUnknown() && !concatenating) {
                        this.addUnknownCodeBlock(seq, buf);
                        break;
                    }
                    if (inVariable) {
                        this.addUnknownCodeBlock(seq, buf);
                        break;
                    }
                    concatenating = false;
                    if ("\"".equals(text) || "'".equals(text)) {
                        this.skip(seq);
                        break;
                    }
                    if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                        this.addCodeBlock(seq, " " + text.substring(1, text.length() - 1) + " ", buf);
                        break;
                    }
                    if (text.startsWith("\"") || text.startsWith("'")) {
                        this.addCodeBlock(seq, " " + text.substring(1), buf);
                        break;
                    }
                    this.addCodeBlock(seq, text, buf);
                    break;
                }
                case PHP_HEREDOC_TAG: 
                case PHP_NOWDOC_TAG: {
                    concatenating = false;
                }
                case PHP_CLOSETAG: 
                case WHITESPACE: {
                    this.skip(seq);
                    break;
                }
                case UNKNOWN_TOKEN: {
                    this.addCodeBlock(seq, text, buf);
                    break;
                }
                default: {
                    switch ((PHPTokenId)seq.token().id()) {
                        case PHP_TOKEN: {
                            if (text.equals("${") || text.equals("$")) {
                                inVariable = true;
                            } else if (text.equals(".")) {
                                concatenating = true;
                                this.skip(seq);
                                break block0;
                            }
                            concatenating = false;
                            break;
                        }
                        case PHP_CURLY_CLOSE: {
                            concatenating = false;
                            inVariable = false;
                        }
                    }
                    this.addUnknownCodeBlock(seq, buf);
                }
            }
        } while (seq.moveNext() && seq.offset() < stringEnd);
        return buf.toString();
    }

    private boolean lastBlockIsUnknown() {
        CodeBlockData previous = this.getLastCodeBlock();
        return previous != null && previous.isUnknown;
    }

    private void addCodeBlock(TokenSequence seq, String generatedString, StringBuffer buf) {
        int generatedStart = buf.length();
        int sourceStart = seq.offset();
        int sourceEnd = sourceStart + seq.token().length();
        int generatedEnd = generatedString.length() + generatedStart;
        CodeBlockData data = new CodeBlockData(sourceStart, sourceEnd, generatedStart, generatedEnd, generatedString.equals("__UNKNOWN__"));
        this.codeBlocks.add(data);
        buf.append(generatedString);
    }

    private void skip(TokenSequence seq) {
        CodeBlockData previous = this.getLastCodeBlock();
        if (previous != null) {
            previous.sourceEnd = seq.offset() + seq.token().length();
        } else {
            CodeBlockData data = new CodeBlockData(seq.offset(), seq.offset() + seq.token().length(), 0, 0, false);
            this.codeBlocks.add(data);
        }
    }

    private CodeBlockData getLastCodeBlock() {
        if (this.codeBlocks.size() > 0) {
            return this.codeBlocks.get(this.codeBlocks.size() - 1);
        }
        return null;
    }

    private void addUnknownCodeBlock(TokenSequence seq, StringBuffer buf) {
        CodeBlockData codeBlock = this.getLastCodeBlock();
        if (codeBlock != null && codeBlock.isUnknown) {
            this.skip(seq);
        } else {
            this.addCodeBlock(seq, "__UNKNOWN__", buf);
        }
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int generatedOffset) {
        for (CodeBlockData codeBlock : this.codeBlocks) {
            if (codeBlock.generatedStart > generatedOffset || codeBlock.generatedEnd < generatedOffset) continue;
            return codeBlock;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int sourceOffset) {
        for (CodeBlockData codeBlock : this.codeBlocks) {
            if (codeBlock.sourceStart > sourceOffset || codeBlock.sourceEnd < sourceOffset) continue;
            return codeBlock;
        }
        return null;
    }

    private static class StringFinder {
        private StringFinder() {
        }

        static int findStringBegin(TokenSequence<PHPTokenId> seq, int offset) {
            int startOffset = StringFinder.findStringTerminationOffset(seq, offset, StringDirection.BACKWARD);
            if (startOffset == -1) {
                return -1;
            }
            seq.move(startOffset);
            if (!seq.moveNext()) {
                return -1;
            }
            String text = ((Object)seq.token().text()).toString();
            if (text.equals("\"") || text.equals("'") || seq.token().id() == PHPTokenId.PHP_HEREDOC_TAG) {
                seq.moveNext();
            }
            return seq.offset();
        }

        static int findStringEnd(TokenSequence<PHPTokenId> seq, int offset) {
            int endOffset = StringFinder.findStringTerminationOffset(seq, offset, StringDirection.FORWARD);
            if (endOffset == -1) {
                return -1;
            }
            seq.move(endOffset);
            seq.movePrevious();
            String text = ((Object)seq.token().text()).toString();
            if (text.equals("\"") || text.equals("'") || seq.token().id() == PHPTokenId.PHP_HEREDOC_TAG) {
                seq.movePrevious();
            }
            return seq.offset() + seq.token().length();
        }

        /*
         * Exception decompiling
         */
        private static int findStringTerminationOffset(TokenSequence<PHPTokenId> seq, int offset, StringDirection direction) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 0[SWITCH]], but top level block is 32[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static int getOffset(TokenSequence seq, StringDirection direction) {
            if (direction == StringDirection.BACKWARD) {
                return seq.offset();
            }
            return seq.offset() + seq.token().length();
        }

        private static enum StringDirection {
            FORWARD,
            BACKWARD;

        }

        private static enum StringState {
            STARTING,
            VARSUB_STRING,
            CONCATENATING,
            MAYBE_SUBSTRING_TERM,
            SUBSTRING_TERM;

        }
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;
        private boolean isUnknown;

        public CodeBlockData(int sourceStart, int sourceEnd, int generatedStart, int generatedEnd, boolean isUnknown) {
            this.sourceStart = sourceStart;
            this.generatedStart = generatedStart;
            this.sourceEnd = sourceEnd;
            this.generatedEnd = generatedEnd;
            this.isUnknown = isUnknown;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CodeBlockData[");
            sb.append("\n  SOURCE(" + this.sourceStart + "," + this.sourceEnd + ")");
            sb.append(",\n  SQL(" + this.generatedStart + "," + this.generatedEnd + ")");
            sb.append("]");
            return sb.toString();
        }
    }
}

