/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.EMapFormat;
import org.netbeans.mobility.antext.StackTraceTranslator;

public class RunTask
extends Task {
    private static final String DEFAULT_PLATFORM_TYPE = "UEI-1.0";
    private File jadFile;
    private File jarFile;
    private String jadUrl;
    private String execMethod;
    private String device;
    private File platformHome;
    private String platformType;
    private Path classPath;
    private String securityDomain;
    private boolean debug;
    private String debuggerAddressProperty;
    private String debugAddress;
    private String debugTransport;
    private boolean debugServer = true;
    private boolean debugSuspend = true;
    private String commandLine = null;
    private String cmdOptions;
    private String listCommandLine = null;
    private String otaRunCommandLine = null;
    protected URL jadUrlURL = null;
    protected final HashMap<String, Object> args = new HashMap();
    private static final String CMD_RUN = "CMD_Run_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File tempFolder = null;
        try {
            block49: {
                if (this.platformHome == null) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "platformHome"));
                }
                if (this.jadFile == null && this.jadUrl == null) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingJad"));
                }
                if (!this.platformHome.isDirectory()) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingPlatformHome", this.platformHome.toString()));
                }
                if (this.platformType == null) {
                    this.log(Bundle.getMessage("WARN_DefaultPlatform", DEFAULT_PLATFORM_TYPE), 1);
                    this.platformType = DEFAULT_PLATFORM_TYPE;
                }
                if (Bundle.getMessage("NAME_STANDARD").equals(this.execMethod)) {
                    this.execMethod = null;
                }
                if (Bundle.getMessage("NAME_CUSTOM").equals(this.platformType)) {
                    if (this.commandLine == null) {
                        this.log(Bundle.getMessage("WARN_MissingCommandLine", DEFAULT_PLATFORM_TYPE), 1);
                        this.platformType = DEFAULT_PLATFORM_TYPE;
                    }
                } else {
                    this.commandLine = null;
                }
                if (this.jadUrl != null && !this.jadUrl.startsWith("${")) {
                    try {
                        this.jadUrlURL = new URL(this.jadUrl);
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (this.commandLine == null && this.execMethod != null) {
                    try {
                        this.commandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod);
                        if (!Bundle.getMessage("NAME_OTA").equals(this.execMethod)) break block49;
                        try {
                            this.listCommandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod + "_List");
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                        try {
                            this.otaRunCommandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod + "_Run");
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                        if (this.jadUrlURL == null) {
                            this.log(Bundle.getMessage("WARN_MissingJadUrlAttrSettingDefault"), 1);
                            this.execMethod = null;
                            this.listCommandLine = null;
                            this.otaRunCommandLine = null;
                        }
                    }
                    catch (MissingResourceException mre) {
                        this.log(Bundle.getMessage(this.debug ? "WARN_UnsupportedDebugMethod" : "WARN_UnsupportedExecMethod", this.platformType, this.execMethod), 1);
                        this.execMethod = null;
                        this.listCommandLine = null;
                        this.otaRunCommandLine = null;
                    }
                }
            }
            if (this.commandLine == null) {
                try {
                    this.commandLine = Bundle.getMessage(CMD_RUN + this.platformType);
                    if (this.jadFile == null) {
                        throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "jadFile"));
                    }
                }
                catch (MissingResourceException mre) {
                    throw new BuildException(Bundle.getMessage(this.debug ? "ERR_UnsupportedDebugging" : "ERR_UnsupportedExecution", this.platformType));
                }
            }
            this.args.put("platformhome", this.platformHome.getAbsolutePath());
            this.args.put("cmdoptions", this.cmdOptions == null ? "" : this.cmdOptions);
            if (this.classPath != null) {
                this.args.put("classpath", this.classPath.toString());
            }
            if (this.device != null && !"".equals(this.device)) {
                this.args.put("device", this.device);
            }
            if (this.jadFile != null) {
                if (this.jarFile != null && this.jarFile.isFile() && this.jadFile.isFile() && this.jarFile.getParentFile() != null && this.jarFile.getParentFile().equals(this.jadFile.getParentFile())) {
                    try {
                        tempFolder = File.createTempFile("nbrun", "", this.jarFile.getParentFile());
                        tempFolder.delete();
                        this.copy(this.jadFile, tempFolder);
                        this.copy(this.jarFile, tempFolder);
                        tempFolder.deleteOnExit();
                        this.jadFile = new File(tempFolder, this.jadFile.getName());
                        try {
                            this.jadFile = this.jadFile.getCanonicalFile();
                        }
                        catch (IOException ioe) {
                            this.jadFile = this.jadFile.getAbsoluteFile();
                        }
                        this.jadFile.deleteOnExit();
                        this.jarFile = new File(tempFolder, this.jarFile.getName());
                        try {
                            this.jarFile = this.jarFile.getCanonicalFile();
                        }
                        catch (IOException ioe) {
                            this.jarFile = this.jarFile.getAbsoluteFile();
                        }
                        this.jarFile.deleteOnExit();
                    }
                    catch (Exception e) {
                        this.log(e.getLocalizedMessage(), 1);
                    }
                }
                this.args.put("jadfile", this.jadFile.getAbsolutePath());
            }
            if (this.jadUrlURL != null) {
                this.args.put("jadurl", this.jadUrlURL);
                this.log(Bundle.getMessage("Inf_JadURL", this.jadUrlURL.toExternalForm()), 2);
            }
            if (this.securityDomain != null && !"".equals(this.securityDomain)) {
                this.args.put("securitydomain", this.securityDomain);
            }
            if (this.debug) {
                if (this.debugAddress == null) {
                    try {
                        this.debugAddress = Integer.toString(this.determineFreePort());
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                this.args.put("debug", "");
                this.args.put("debugaddress", this.debugAddress);
                this.args.put("debugtransport", this.debugTransport != null ? this.debugTransport : "dt_socket");
                this.args.put("debugserver", this.debugServer ? "y" : "n");
                this.args.put("debugsuspend", this.debugSuspend ? "y" : "n");
                if (this.debuggerAddressProperty != null) {
                    this.getProject().setNewProperty(this.debuggerAddressProperty, this.debugAddress);
                }
            }
            this.args.put("/", File.separator);
            if (this.debug) {
                this.log(Bundle.getMessage("MSG_RunDebug", this.debugAddress), 2);
            } else {
                this.log(Bundle.getMessage("MSG_RunExec"), 2);
            }
            try {
                int i = this.doExecute();
                if (i != 0) {
                    throw new BuildException(Bundle.getMessage("ERR_RunFailed", String.valueOf(i)));
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
            if (tempFolder != null) {
                this.delete(tempFolder);
            }
        }
        catch (Throwable throwable) {
            if (tempFolder != null) {
                this.delete(tempFolder);
            }
            throw throwable;
        }
    }

    private void copy(File sourceFile, File targetFolder) throws BuildException {
        Copy c = new Copy();
        c.setProject(this.getProject());
        FileSet fileset = new FileSet();
        fileset.setFile(sourceFile);
        c.addFileset(fileset);
        c.setTodir(targetFolder);
        c.execute();
    }

    private void delete(File f) {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.delete(fs[i]);
            }
        }
        f.delete();
    }

    private int doExecute() throws IOException {
        this.commandLine = EMapFormat.format(this.commandLine, this.args);
        Execute exec = new Execute();
        exec.setAntRun(this.getProject());
        exec.setVMLauncher(true);
        exec.setCommandline(Commandline.translateCommandline((String)this.commandLine));
        if (this.classPath != null && this.isClassFileAvailable()) {
            exec.setStreamHandler((ExecuteStreamHandler)new StackTraceTranslatorHandler(this.getProject().getBaseDir(), this.classPath.list()));
        }
        this.log(Bundle.getMessage("MSG_ExecCmd", this.commandLine), 3);
        int i = 0;
        try {
            i = exec.execute();
        }
        catch (IllegalThreadStateException itse) {
            this.log(itse.getLocalizedMessage(), 3);
        }
        if (i == 0 && this.listCommandLine != null) {
            this.listCommandLine = EMapFormat.format(this.listCommandLine, this.args);
            exec = new Execute();
            exec.setAntRun(this.getProject());
            exec.setVMLauncher(true);
            exec.setCommandline(Commandline.translateCommandline((String)this.listCommandLine));
            exec.setStreamHandler((ExecuteStreamHandler)new ListStreamHandler());
            this.log(Bundle.getMessage("MSG_ExecCmd", this.listCommandLine), 3);
            try {
                i = exec.execute();
            }
            catch (IllegalThreadStateException itse) {
                this.log(itse.getLocalizedMessage(), 3);
            }
        }
        if (i == 0 && this.otaRunCommandLine != null) {
            this.otaRunCommandLine = EMapFormat.format(this.otaRunCommandLine, this.args);
            exec = new Execute();
            exec.setAntRun(this.getProject());
            exec.setVMLauncher(true);
            exec.setCommandline(Commandline.translateCommandline((String)this.otaRunCommandLine));
            if (this.classPath != null && this.isClassFileAvailable()) {
                exec.setStreamHandler((ExecuteStreamHandler)new StackTraceTranslatorHandler(this.getProject().getBaseDir(), this.classPath.list()));
            }
            this.log(Bundle.getMessage("MSG_ExecCmd", this.otaRunCommandLine), 3);
            try {
                i = exec.execute();
            }
            catch (IllegalThreadStateException itse) {
                this.log(itse.getLocalizedMessage(), 3);
            }
        }
        return i;
    }

    private boolean isClassFileAvailable() {
        try {
            Class.forName("org.netbeans.modules.classfile.ClassFile");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int determineFreePort() throws IOException {
        Socket sock = new Socket();
        sock.bind(null);
        int port = sock.getLocalPort();
        sock.close();
        return port;
    }

    public void setJadFile(File jadFile) {
        this.jadFile = jadFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setJadUrl(String jadUrl) {
        this.jadUrl = jadUrl;
    }

    public void setExecMethod(String execMethod) {
        this.execMethod = execMethod.toUpperCase();
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setPlatformHome(File platformHome) {
        this.platformHome = platformHome;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType.toUpperCase();
    }

    public void setClassPath(Path classPath) {
        this.createClassPath().append(classPath);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference classPathRef) {
        this.createClassPath().setRefid(classPathRef);
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebuggerAddressProperty(String debuggerAddressProperty) {
        this.debuggerAddressProperty = debuggerAddressProperty;
    }

    public void setDebugAddress(String debugAddress) {
        this.debugAddress = debugAddress;
    }

    public void setDebugTransport(String debugTransport) {
        this.debugTransport = debugTransport;
    }

    public void setDebugServer(boolean debugServer) {
        this.debugServer = debugServer;
    }

    public void setDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public void setCmdOptions(String cmdOptions) {
        this.cmdOptions = cmdOptions;
    }

    private class StackTraceTranslatorHandler
    extends PumpStreamHandler {
        protected final StackTraceTranslator stt;
        private boolean isBci;

        StackTraceTranslatorHandler(File root, String[] pathElements) {
            this.stt = new StackTraceTranslator(root, pathElements);
        }

        protected Thread createPump(final InputStream is, final OutputStream os, final boolean closeWhenExhausted) {
            Thread result = new Thread(new Runnable(){
                private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                private final StringBuffer sb = new StringBuffer();
                protected boolean sleep;
                private final Thread timer = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                sleep = true;
                                while (sleep) {
                                    sleep = false;
                                    Thread.sleep(400L);
                                }
                                this.flush(true);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                });

                protected synchronized void flush(boolean forced) {
                    Pattern STACK_TRACE_REGEXP_LINE = Pattern.compile("((?:\t| *|\\[catch\\] )at )((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*)\\.([a-zA-Z_$<][a-zA-Z0-9_$>]*)\\(\\+([0-9]+)\\)[\t ]*[\n\r]*");
                    Pattern STACK_TRACE_BCI_REGEXP_LINE = Pattern.compile("((?:\t| *)- )((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*)\\.([a-zA-Z_$<][a-zA-Z0-9_$>]*)\\(\\), bci=([0-9]+)[\t ]*[\n\r]*");
                    try {
                        if (this.buffer.size() > 0) {
                            String line = this.buffer.toString();
                            boolean bci = STACK_TRACE_BCI_REGEXP_LINE.matcher(line).matches();
                            if (bci) {
                                StackTraceTranslatorHandler.this.isBci = true;
                            }
                            if (STACK_TRACE_REGEXP_LINE.matcher(line).matches() || bci) {
                                this.sb.append(line);
                                this.buffer.reset();
                            }
                        }
                        if ((forced || this.buffer.size() > 0) && this.sb.length() > 0) {
                            try {
                                String translate = StackTraceTranslatorHandler.this.stt.translate(this.sb.toString(), StackTraceTranslatorHandler.this.isBci);
                                os.write(translate.getBytes());
                                this.sb.setLength(0);
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        if (this.buffer.size() > 0) {
                            os.write(this.buffer.toByteArray());
                            this.buffer.reset();
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        this.timer.setDaemon(true);
                        this.timer.start();
                        int i = is.read();
                        while (i >= 0) {
                            1 var2_5;
                            while (i >= 0 && i != 10 && i != 13) {
                                var2_5 = this;
                                synchronized (var2_5) {
                                    this.buffer.write(i);
                                }
                                this.sleep = true;
                                i = is.read();
                            }
                            while (i == 10 || i == 13) {
                                var2_5 = this;
                                synchronized (var2_5) {
                                    this.buffer.write(i);
                                }
                                this.sleep = true;
                                i = is.read();
                            }
                            this.flush(i < 0);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.timer.interrupt();
                        if (closeWhenExhausted) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            result.setDaemon(true);
            return result;
        }
    }

    private class ListStreamHandler
    implements ExecuteStreamHandler,
    Runnable {
        private BufferedReader in;

        private ListStreamHandler() {
        }

        public void setProcessErrorStream(InputStream is) throws IOException {
        }

        public void setProcessInputStream(OutputStream os) throws IOException {
        }

        public void setProcessOutputStream(InputStream is) throws IOException {
            this.in = new BufferedReader(new InputStreamReader(is));
        }

        public void start() throws IOException {
            new Thread(this).start();
        }

        public void stop() {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                String s;
                int i = 0;
                while ((s = this.in.readLine()) != null) {
                    if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
                        try {
                            i = Integer.parseInt(s.substring(1, s.length() - 1));
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    if (!s.startsWith("Installed From:")) continue;
                    try {
                        s = s.substring(15).trim();
                        if (!new URL(s).equals(RunTask.this.jadUrlURL) && !new URL(URLDecoder.decode(s, "UTF-8")).equals(RunTask.this.jadUrlURL)) continue;
                        RunTask.this.args.put("storagenum", String.valueOf(i));
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

