/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ValidPrimaryTableName
extends JPAClassRule {
    public ValidPrimaryTableName() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.ENTITY));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        String tableName = JPAHelper.getPrimaryTableName((Entity)ctx.getModelElement());
        String entityName = ((Entity)ctx.getModelElement()).getName();
        if (tableName.length() == 0) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem(subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_InvalidPersistenceQLIdentifier"))};
        }
        if (SQLKeywords.isSQL99ReservedKeyword((String)tableName)) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem((Element)subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithReservedSQLKeyword"), Severity.WARNING)};
        }
        if (JavaPersistenceQLKeywords.isKeyword((String)entityName)) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem((Element)subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithJavaPersistenceQLKeyword"), Severity.WARNING)};
        }
        return null;
    }
}

