/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

public class RestartTask
extends BasicTask<GlassfishModule.OperationState> {
    private static final int RESTART_DELAY = 5000;
    private final CommonServerSupport support;

    public RestartTask(CommonServerSupport support, OperationStateListener ... stateListener) {
        super(support.getInstanceProperties(), stateListener);
        this.support = support;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "RestartTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_RESTART_SERVER_IN_PROGRESS", this.instanceName);
        GlassfishModule.ServerState state = this.support.getServerState();
        if (state == GlassfishModule.ServerState.STARTING) {
            GlassfishModule.ServerState currentState = state;
            int steps = 480;
            int count = 0;
            while (currentState == GlassfishModule.ServerState.STARTING && count++ < steps) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                }
                currentState = this.support.getServerState();
            }
            if (currentState != GlassfishModule.ServerState.RUNNING) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
        } else {
            String o;
            boolean postStopDelay = true;
            if (state == GlassfishModule.ServerState.RUNNING) {
                Future<GlassfishModule.OperationState> stopTask = this.support.stopServer(null);
                GlassfishModule.OperationState stopResult = GlassfishModule.OperationState.FAILED;
                try {
                    stopResult = stopTask.get(10000L, TIMEUNIT);
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                }
                if (stopResult == GlassfishModule.OperationState.FAILED) {
                    return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else if (state == GlassfishModule.ServerState.STOPPING) {
                GlassfishModule.ServerState currentState = state;
                int steps = 40;
                int count = 0;
                while (currentState == GlassfishModule.ServerState.STOPPING && count++ < steps) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                    }
                    currentState = this.support.getServerState();
                }
                if (currentState != GlassfishModule.ServerState.STOPPED) {
                    return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else {
                postStopDelay = false;
            }
            if (postStopDelay) {
                this.support.setServerState(GlassfishModule.ServerState.STARTING);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if ("profileMode".equals(o = this.support.setEnvironmentProperty("jvmMode", "normalMode", false))) {
                this.support.setEnvironmentProperty("jvmMode", "normalMode", false);
            }
            Future<GlassfishModule.OperationState> startTask = this.support.startServer(null);
            GlassfishModule.OperationState startResult = GlassfishModule.OperationState.FAILED;
            try {
                startResult = startTask.get(120000L, TIMEUNIT);
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
            }
            if (startResult == GlassfishModule.OperationState.FAILED) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
            if (!this.support.isRemote() && this.support.getServerState() != GlassfishModule.ServerState.RUNNING) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_REASON_UNKNOWN", this.instanceName);
            }
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_RESTARTED", this.instanceName);
    }
}

