/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddDomainLocationPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddDomainLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String gfRoot;
    private AtomicBoolean isValidating = new AtomicBoolean();

    public AddDomainLocationPanel(ServerWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
        this.wizard = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                AddDomainLocationVisualPanel panel = (AddDomainLocationVisualPanel)this.getComponent();
                if (panel.registerLocalDomain()) {
                    boolean bl = this.validateForLocalDomain(panel);
                    return bl;
                }
                boolean bl = this.validateForRemoteDomain(panel);
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddDomainLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_domain");
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
        this.gfRoot = this.wizardIterator.getGlassfishRoot();
        ((AddDomainLocationVisualPanel)this.getComponent()).initModels(this.gfRoot);
    }

    public void storeSettings(Object settings) {
    }

    private boolean validateForLocalDomain(AddDomainLocationVisualPanel panel) throws MissingResourceException {
        String domainField = panel.getDomainField().trim();
        File domainDirCandidate = new File(this.gfRoot, "domains" + File.separator + domainField);
        if (domainField.length() < 1) {
            if (!Utils.canWrite(domainDirCandidate)) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_EnterDomainDirectory"));
            } else {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_MustHaveName"));
            }
            return false;
        }
        int dex = domainField.indexOf(File.separator);
        if (AddServerLocationPanel.isRegisterableDomain(domainDirCandidate)) {
            Util.readServerConfiguration(domainDirCandidate, this.wizardIterator);
            String uri = this.wizardIterator.formatUri("localhost", this.wizardIterator.getAdminPort());
            if (-1 == this.wizardIterator.getHttpPort()) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainField));
                return false;
            }
            if (-1 == this.wizardIterator.getAdminPort()) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainField));
                return false;
            }
            if (this.wizardIterator.hasServer(uri)) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_DomainAlreadyRegistered", (Object)domainField));
                return false;
            }
            this.wizardIterator.setDomainLocation(domainDirCandidate.getAbsolutePath());
            this.wizardIterator.setHostName("localhost");
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExistingEmbedded", (Object)domainField));
            return true;
        }
        File domainsDir = domainDirCandidate.getParentFile();
        if (Utils.canWrite(domainsDir) && dex < 0 && !ServerUtilities.isTP2(this.gfRoot) && !domainDirCandidate.exists()) {
            this.wizardIterator.setDomainLocation(domainDirCandidate.getAbsolutePath());
            this.wizardIterator.setHostName("localhost");
            this.wizardIterator.setUseDefaultPorts(panel.getUseDefaultPorts());
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateEmbedded", (Object)domainField));
            return true;
        }
        domainDirCandidate = new File(domainField);
        String domainLoc = domainDirCandidate.getAbsolutePath();
        if (AddServerLocationPanel.isRegisterableDomain(domainDirCandidate)) {
            this.wizardIterator.setDomainLocation(domainLoc);
            this.wizardIterator.setHostName("localhost");
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExisting", (Object)domainField));
            Util.readServerConfiguration(domainDirCandidate, this.wizardIterator);
            return true;
        }
        if (AddServerLocationPanel.canCreate(domainDirCandidate) && !ServerUtilities.isTP2(this.gfRoot)) {
            this.wizardIterator.setDomainLocation(domainLoc);
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateDomain", (Object)domainField));
            this.wizardIterator.setUseDefaultPorts(panel.getUseDefaultPorts());
            this.wizardIterator.setHostName("localhost");
            return true;
        }
        if (new File(domainsDir, domainField).exists()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_UnusableDomain", (Object)domainField));
        } else if (domainDirCandidate.exists()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_UnusableDomain", (Object)domainField));
        } else {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDomain", (Object)domainField));
        }
        return false;
    }

    private boolean validateForRemoteDomain(AddDomainLocationVisualPanel panel) {
        String hn = panel.getHostName();
        String port = panel.getPortValue();
        try {
            int portval = Integer.parseInt(port);
            this.wizardIterator.setAdminPort(portval);
            this.wizardIterator.setHostName(hn);
            this.wizardIterator.setDomainLocation(null);
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterRemote", (Object)hn, (Object)port));
            return true;
        }
        catch (NumberFormatException nfe) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidAdminPort", (Object)port));
            return false;
        }
    }
}

