/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.UserConfigurationTemplatesProvider;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel2;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerMIDP;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.SaveConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanelGUI;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class VisualConfigSupport {
    static final String PRIVATE_PREFIX = "private.";
    final JList configurationList;
    final JButton addConfigButton;
    final JButton addMoreButton;
    final JButton renameConfigButton;
    final JButton removeConfigButton;
    final JButton duplicateButton;
    final JButton saveButton;
    private final DefaultListModel configurationModel;
    J2MEProjectProperties properties;

    public VisualConfigSupport(JList configurationList, JButton addConfigButton, JButton addMoreButton, JButton renameConfigButton, JButton removeConfigButton, JButton duplicateButton, JButton saveButton) {
        this.configurationList = configurationList;
        this.configurationModel = new DefaultListModel();
        this.configurationList.setModel(this.configurationModel);
        this.configurationList.setCellRenderer(new ConfigurationCellRenderer());
        this.addConfigButton = addConfigButton;
        this.addMoreButton = addMoreButton;
        this.renameConfigButton = renameConfigButton;
        this.removeConfigButton = removeConfigButton;
        this.duplicateButton = duplicateButton;
        this.saveButton = saveButton;
        ConfigSupportListener csl = new ConfigSupportListener();
        addConfigButton.addActionListener(csl);
        addMoreButton.addActionListener(csl);
        renameConfigButton.addActionListener(csl);
        removeConfigButton.addActionListener(csl);
        duplicateButton.addActionListener(csl);
        saveButton.addActionListener(csl);
        configurationList.getSelectionModel().addListSelectionListener(csl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyMap(J2MEProjectProperties properties) {
        this.properties = properties;
        ProjectConfiguration[] configurations = properties.getConfigurations();
        DefaultListModel defaultListModel = this.configurationModel;
        synchronized (defaultListModel) {
            this.configurationModel.clear();
            for (int i = 0; i < configurations.length; ++i) {
                this.configurationModel.addElement(configurations[i]);
            }
        }
        this.configurationList.setSelectedValue(properties.getActiveConfiguration(), true);
        this.refreshButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConfiguration[] getConfigurationItems() {
        DefaultListModel defaultListModel = this.configurationModel;
        synchronized (defaultListModel) {
            ProjectConfiguration[] confs = new ProjectConfiguration[this.configurationModel.getSize()];
            for (int i = 0; i < confs.length; ++i) {
                confs[i] = (ProjectConfiguration)this.configurationModel.getElementAt(i);
            }
            return confs;
        }
    }

    protected void addNewConfig() {
        String newName;
        ProjectConfiguration[] cfgs = this.getConfigurationItems();
        HashSet<String> allNames = new HashSet<String>(cfgs.length);
        for (int i = 0; i < cfgs.length; ++i) {
            allNames.add(cfgs[i].getDisplayName());
        }
        NewConfigurationPanel ncp = new NewConfigurationPanel(allNames);
        DialogDescriptor dd = new DialogDescriptor((Object)ncp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        ncp.setDialogDescriptor(dd);
        String string = newName = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) ? ncp.getName() : null;
        if (newName != null) {
            ProjectConfiguration cfg = new ProjectConfiguration(){

                public String getDisplayName() {
                    return newName;
                }
            };
            this.configurationModel.addElement(cfg);
            this.configurationList.setSelectedValue(cfg, true);
            VisualConfigSupport.createFromTemplate(this.properties, newName, ncp.getTemplate());
            this.fireActionPerformed();
        }
    }

    protected void addMoreConfigs() {
        ProjectConfiguration[] cfgs = this.getConfigurationItems();
        HashSet<String> allNames = new HashSet<String>(cfgs.length);
        for (int i = 0; i < cfgs.length; ++i) {
            allNames.add(cfgs[i].getDisplayName());
        }
        final ConfigurationsSelectionPanelGUI ncp = new ConfigurationsSelectionPanelGUI(allNames);
        final ErrorPanel ep = new ErrorPanel();
        JPanel p = new JPanel(new BorderLayout());
        p.getAccessibleContext().setAccessibleName(ncp.getAccessibleContext().getAccessibleName());
        p.getAccessibleContext().setAccessibleDescription(ncp.getAccessibleContext().getAccessibleDescription());
        p.add((Component)ncp, "Center");
        p.add((Component)ep, "South");
        final DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        ncp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                boolean valid = ncp.valid();
                dd.setValid(valid);
                ep.setErrorMessage(valid ? null : NbBundle.getMessage(ConfigurationsSelectionPanel.class, (String)"ERR_CfgSelPanel_NameCollision"));
            }
        });
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            for (ProjectConfigurationFactory.ConfigurationTemplateDescriptor tmp : ncp.getSelectedTemplates()) {
                final String newName = tmp.getCfgName();
                ProjectConfiguration cfg = new ProjectConfiguration(){

                    public String getDisplayName() {
                        return newName;
                    }
                };
                this.configurationModel.addElement(cfg);
                this.configurationList.setSelectedValue(cfg, true);
                VisualConfigSupport.createFromTemplate(this.properties, newName, tmp);
            }
            this.fireActionPerformed();
        }
    }

    public static void createFromTemplate(J2MEProjectProperties properties, String cfg, ProjectConfigurationFactory.ConfigurationTemplateDescriptor desc) {
        if (desc == null) {
            return;
        }
        AntProjectHelper helper = properties.getHelper();
        EditableProperties priv = helper.getProperties("nbproject/private/private.properties");
        EditableProperties proj = helper.getProperties("nbproject/project.properties");
        String cfgName = desc.getCfgName();
        String prefix = "configs." + cfgName + '.';
        Map p = desc.getPrivateProperties();
        if (p != null) {
            for (Map.Entry en : p.entrySet()) {
                if (priv.containsKey(en.getKey())) continue;
                priv.put((String)en.getKey(), (String)en.getValue());
            }
        }
        if ((p = desc.getProjectGlobalProperties()) != null) {
            for (Map.Entry en : p.entrySet()) {
                if (proj.containsKey(en.getKey())) continue;
                proj.put((String)en.getKey(), (String)en.getValue());
            }
        }
        if ((p = desc.getProjectConfigurationProperties()) != null) {
            for (Map.Entry en : p.entrySet()) {
                properties.putPropertyRawValue("configs." + cfg + '.' + (String)en.getKey(), (String)en.getValue());
            }
        }
        helper.putProperties("nbproject/private/private.properties", priv);
        helper.putProperties("nbproject/project.properties", proj);
    }

    private static void fixPlatform(J2MEProjectProperties properties, String configuration, String platform) {
        JavaPlatform[] p = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        int best = 0;
        int rating = 0;
        for (int i = 0; rating < 5 && i < p.length; ++i) {
            int r;
            if (!(p[i] instanceof J2MEPlatform) || (r = VisualConfigSupport.ratePlatform((J2MEPlatform)p[i], platform)) <= rating) continue;
            rating = r;
            best = i;
        }
        if (rating > 0) {
            properties.putPropertyRawValue("configs." + configuration + '.' + "platform.active", ((J2MEPlatform)p[best]).getName());
            CustomizerMIDP cmp = new CustomizerMIDP();
            cmp.initValues(properties, configuration);
            cmp.initGroupValues(true);
        }
    }

    private static int ratePlatform(J2MEPlatform platform, String expName) {
        String name = platform.getName();
        if (name.equals(expName)) {
            return 5;
        }
        if (name.indexOf(expName) >= 0) {
            return 4;
        }
        if (name.startsWith("J2ME_Wireless_Toolkit_2")) {
            return 3;
        }
        if (name.startsWith("J2ME_Wireless_Toolkit")) {
            return 2;
        }
        return 1;
    }

    protected void duplicateElement() {
        Object[] cfgs = this.configurationList.getSelectedValues();
        assert (cfgs.length > 0) : "Duplicate button should be disabled";
        ProjectConfiguration[] allCfgs = this.getConfigurationItems();
        HashSet<String> allNames = new HashSet<String>(allCfgs.length);
        for (int i = 0; i < allCfgs.length; ++i) {
            allNames.add(allCfgs[i].getDisplayName());
        }
        if (cfgs.length == 1) {
            String newName;
            CloneConfigurationPanel ccp = new CloneConfigurationPanel(allNames);
            DialogDescriptor dd = new DialogDescriptor((Object)ccp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfiguration", (Object)((ProjectConfiguration)cfgs[0]).getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
            ccp.setDialogDescriptor(dd);
            String string = newName = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) ? ccp.getName() : null;
            if (newName != null) {
                this.copyProperties(((ProjectConfiguration)cfgs[0]).getDisplayName(), newName);
                this.configurationList.setSelectedValue(this.addCfg(newName), true);
                this.fireActionPerformed();
            }
        } else {
            HashSet<String> cloneNames = new HashSet<String>(cfgs.length);
            for (int i = 0; i < cfgs.length; ++i) {
                cloneNames.add(((ProjectConfiguration)cfgs[i]).getDisplayName());
            }
            CloneConfigurationPanel2 ccp = new CloneConfigurationPanel2(allNames, cloneNames);
            DialogDescriptor dd = new DialogDescriptor((Object)ccp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfigurations"), true, 2, NotifyDescriptor.OK_OPTION, null);
            ccp.setDialogDescriptor(dd);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
                String prefix = ccp.getPrefix();
                String suffix = ccp.getSuffix();
                for (int i = 0; i < cfgs.length; ++i) {
                    ProjectConfiguration cfg = (ProjectConfiguration)cfgs[i];
                    String newName = prefix + cfg.getDisplayName() + suffix;
                    this.copyProperties(cfg.getDisplayName(), newName);
                    this.configurationList.setSelectedValue(this.addCfg(newName), true);
                }
                this.fireActionPerformed();
            }
        }
    }

    private ProjectConfiguration addCfg(final String newName) {
        ProjectConfiguration newCfg = new ProjectConfiguration(){

            public String getDisplayName() {
                return newName;
            }
        };
        this.configurationModel.addElement(newCfg);
        return newCfg;
    }

    private void copyProperties(String srcCfg, String targetCfg) {
        String[] keys = this.properties.keySet().toArray(new String[this.properties.size()]);
        String prefix = "configs." + srcCfg;
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith(prefix)) continue;
            Object backValue = this.properties.get(keys[i]);
            if (backValue instanceof Cloneable) {
                try {
                    Method m = backValue.getClass().getMethod("clone", new Class[0]);
                    if (m != null) {
                        backValue = m.invoke(backValue, new Object[0]);
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.properties.put("configs." + targetCfg + keys[i].substring(prefix.length()), backValue);
        }
    }

    protected void removeElement() {
        int si = this.configurationList.getSelectedIndex();
        assert (si > 0) : "Remove button should be disabled";
        Object[] cfgs = this.configurationList.getSelectedValues();
        StringBuffer text = new StringBuffer(((ProjectConfiguration)cfgs[0]).getDisplayName());
        for (int i = 1; i < cfgs.length; ++i) {
            text.append("\", \"").append(((ProjectConfiguration)cfgs[i]).getDisplayName());
        }
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_ReallyRemove", (Object)text), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            for (int i = cfgs.length - 1; i >= 0; --i) {
                this.configurationModel.removeElement(cfgs[i]);
                this.removeProperties(((ProjectConfiguration)cfgs[i]).getDisplayName());
            }
            this.configurationList.setSelectedIndex(si < this.configurationModel.getSize() ? si : si - 1);
            this.fireActionPerformed();
        }
    }

    protected void renameElement() {
        Object[] cfgs = this.configurationList.getSelectedValues();
        assert (cfgs.length > 0) : "Rename button should be disabled";
        for (Object o : cfgs) {
            ProjectConfiguration cfg = (ProjectConfiguration)o;
            ProjectConfiguration[] allCfgs = this.getConfigurationItems();
            HashSet<String> allNames = new HashSet<String>(allCfgs.length);
            for (int i = 0; i < allCfgs.length; ++i) {
                allNames.add(allCfgs[i].getDisplayName());
            }
            CloneConfigurationPanel ccp = new CloneConfigurationPanel(allNames);
            DialogDescriptor dd = new DialogDescriptor((Object)ccp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_RenConfiguration", (Object)cfg.getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
            ccp.setDialogDescriptor(dd);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (NotifyDescriptor.OK_OPTION.equals(ret)) {
                String newName = ccp.getName();
                this.copyProperties(cfg.getDisplayName(), newName);
                this.removeProperties(cfg.getDisplayName());
                this.configurationModel.removeElement(cfg);
                this.configurationList.setSelectedValue(this.addCfg(newName), true);
                this.fireActionPerformed();
                continue;
            }
            if (!NotifyDescriptor.CANCEL_OPTION.equals(ret)) continue;
            return;
        }
    }

    private void removeProperties(String cfgName) {
        String[] keys = this.properties.keySet().toArray(new String[this.properties.size()]);
        String prefix = "configs." + cfgName;
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith(prefix)) continue;
            this.properties.remove(keys[i]);
        }
    }

    protected void saveElement() {
        Object[] cfgs = this.configurationList.getSelectedValues();
        assert (cfgs.length > 0) : "Save button should be disabled";
        FileObject[] tmps = VisualConfigSupport.getConfigurationTemplates();
        HashSet<String> allNames = new HashSet<String>();
        for (int i = 0; i < tmps.length; ++i) {
            allNames.add(tmps[i].getName());
        }
        JButton SAVE_OPTION = new JButton(NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_SaveBtn"));
        SAVE_OPTION.setMnemonic(NbBundle.getMessage(VisualConfigSupport.class, (String)"MNM_VCS_SaveBtn").charAt(0));
        SAVE_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualConfigSupport.class, (String)"ACSD_VCS_SaveBtn"));
        for (Object o : cfgs) {
            ProjectConfiguration cfg = (ProjectConfiguration)o;
            SaveConfigurationPanel scp = new SaveConfigurationPanel(cfg.getDisplayName() + UserConfigurationTemplatesProvider.CFG_TEMPLATE_SUFFIX, allNames, SAVE_OPTION);
            DialogDescriptor dd = new DialogDescriptor((Object)scp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_SaveConfiguration", (Object)cfg.getDisplayName()), true, new Object[]{SAVE_OPTION, NotifyDescriptor.CANCEL_OPTION}, (Object)SAVE_OPTION, 0, new HelpCtx(SaveConfigurationPanel.class), null);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (SAVE_OPTION.equals(ret)) {
                this.saveConfigurationTemplate(cfg.getDisplayName(), scp.getName());
                continue;
            }
            if (!DialogDescriptor.CANCEL_OPTION.equals(ret)) continue;
            return;
        }
    }

    public static FileObject[] getConfigurationTemplates() {
        TreeSet<FileObject> a = new TreeSet<FileObject>(new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        FileObject dir = FileUtil.getConfigFile((String)"Templates/J2MEProjectConfigurations");
        if (dir != null) {
            Enumeration en = dir.getData(false);
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                if (!"cfg".equals(fo.getExt()) || !Utilities.isJavaIdentifier((String)fo.getName())) continue;
                a.add(fo);
            }
        }
        return a.toArray(new FileObject[a.size()]);
    }

    private void saveConfigurationTemplate(final String cfgName, final String tmpName) {
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileLock lock = null;
                    OutputStream out = null;
                    try {
                        FileObject fo = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Templates/J2MEProjectConfigurations/" + tmpName + '.' + "cfg"));
                        lock = fo.lock();
                        out = fo.getOutputStream(lock);
                        VisualConfigSupport.this.extractConfigurationTemplate(cfgName, tmpName).store(out, null);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    protected Properties extractConfigurationTemplate(String cfgName, String tmpName) {
        Properties props = new Properties();
        String[] keys = this.properties.keySet().toArray(new String[this.properties.size()]);
        String prefix = "configs." + cfgName + '.';
        String newPrefix = "configs." + tmpName + '.';
        String libs = "configs." + cfgName + '.' + "libs.classpath";
        int prefixL = prefix.length();
        String references = null;
        for (int i = 0; i < keys.length; ++i) {
            String value;
            if (!keys[i].startsWith(prefix) || (value = this.properties.getPropertyRawValue(keys[i])) == null) continue;
            props.put(newPrefix + keys[i].substring(prefixL), value);
            if (!libs.equals(keys[i])) continue;
            references = value;
        }
        if (references != null) {
            this.processReferences(props, references, this.properties.getHelper().getProperties("nbproject/project.properties"), this.properties.getHelper().getProperties("nbproject/private/private.properties"));
        }
        return props;
    }

    private void processReferences(Properties props, String path, EditableProperties pub, EditableProperties priv) {
        int i;
        int j = 0;
        while ((i = path.indexOf("${", j)) >= 0) {
            j = path.indexOf(125, i);
            if (j < 0) {
                return;
            }
            String reference = path.substring(i + 2, j);
            if (props.contains(reference) || props.contains(PRIVATE_PREFIX + reference)) continue;
            String value = priv.getProperty(reference);
            if (value != null) {
                props.put(PRIVATE_PREFIX + reference, value);
                this.processReferences(props, value, pub, priv);
            }
            if ((value = pub.getProperty(reference)) == null) continue;
            if (value.indexOf(36) < 0) {
                props.put(PRIVATE_PREFIX + reference, this.properties.getHelper().resolvePath(value));
                continue;
            }
            props.put(reference, value);
            this.processReferences(props, value, pub, priv);
        }
    }

    protected void refreshButtons() {
        boolean sel = this.configurationList.getSelectedIndex() > 0;
        this.renameConfigButton.setEnabled(sel);
        this.removeConfigButton.setEnabled(sel);
        this.duplicateButton.setEnabled(sel);
        this.saveButton.setEnabled(sel);
    }

    private void fireActionPerformed() {
        this.refreshButtons();
        this.properties.setConfigurations(this.getConfigurationItems());
        this.properties.setActiveConfiguration((ProjectConfiguration)this.configurationList.getSelectedValue());
    }

    private static class ConfigurationCellRenderer
    extends DefaultListCellRenderer {
        private ConfigurationCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ProjectConfiguration) {
                this.setText(((ProjectConfiguration)value).getDisplayName());
            }
            return this;
        }
    }

    private class ConfigSupportListener
    implements ActionListener,
    ListSelectionListener {
        private ConfigSupportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == VisualConfigSupport.this.addConfigButton) {
                VisualConfigSupport.this.addNewConfig();
            } else if (source == VisualConfigSupport.this.addMoreButton) {
                VisualConfigSupport.this.addMoreConfigs();
            } else if (source == VisualConfigSupport.this.renameConfigButton) {
                VisualConfigSupport.this.renameElement();
            } else if (source == VisualConfigSupport.this.removeConfigButton) {
                VisualConfigSupport.this.removeElement();
            } else if (source == VisualConfigSupport.this.duplicateButton) {
                VisualConfigSupport.this.duplicateElement();
            } else if (source == VisualConfigSupport.this.saveButton) {
                VisualConfigSupport.this.saveElement();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VisualConfigSupport.this.refreshButtons();
            VisualConfigSupport.this.properties.setActiveConfiguration((ProjectConfiguration)VisualConfigSupport.this.configurationList.getSelectedValue());
        }
    }
}

