/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class StatusAction
extends ContextAction {
    private static final int enabledForStatus = -2;

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ShowChanges";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -2;
    }

    @Override
    public void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = SvnUtils.getCurrentContext(nodes);
        SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
        stc.setContentTitle(this.getContextDisplayName(nodes));
        stc.setContext(ctx);
        stc.open();
        stc.requestActive();
        stc.performRefreshAction();
    }

    public static void executeStatus(Context context, SvnProgressSupport support, boolean contactServer) {
        if (context == null || context.getRoots().isEmpty()) {
            return;
        }
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(context, support);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            Subversion.getInstance().getStatusCache().refreshCached(context);
            File[] roots = context.getRootFiles();
            for (int i = 0; i < roots.length; ++i) {
                StatusAction.executeStatus(roots[i], client, support, contactServer);
                if (!support.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException ex) {
            if (!support.isCanceled()) {
                support.annotate(ex);
            }
            Subversion.LOG.log(Level.INFO, "Action canceled", ex);
        }
    }

    public static void executeStatus(File root, SvnClient client, SvnProgressSupport support, boolean contactServer) throws SVNClientException {
        ISVNStatus[] statuses;
        if (support != null && support.isCanceled()) {
            return;
        }
        try {
            statuses = client.getStatus(root, true, false, contactServer);
        }
        catch (SVNClientException ex) {
            if (contactServer && SvnClientExceptionHandler.isNotUnderVersionControl(ex.getMessage())) {
                Subversion.LOG.log(Level.INFO, "StatusAction.executeStatus: file under {0} not under version control, trying offline", root.getAbsolutePath());
                statuses = client.getStatus(root, true, false, false);
            }
            throw ex;
        }
        if (support != null && support.isCanceled()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int s = 0; s < statuses.length; ++s) {
            if (support != null && support.isCanceled()) {
                return;
            }
            ISVNStatus status = statuses[s];
            File file = status.getFile();
            if (file.isDirectory() && status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                cache.refreshRecursively(file, false);
                continue;
            }
            cache.refresh(file, status);
        }
    }
}

