/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.DataObjectInterface;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DocumentInterface;
import org.netbeans.modules.vmd.io.CodeResolver;
import org.netbeans.modules.vmd.io.DataObjectContextImpl;
import org.netbeans.modules.vmd.io.DocumentLoad;
import org.netbeans.modules.vmd.io.editor.CodeEditorViewDescription;
import org.netbeans.modules.vmd.io.editor.EditorViewDescription;
import org.netbeans.modules.vmd.io.editor.EditorViewElement;
import org.netbeans.modules.vmd.io.editor.EditorViewFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

public final class IOSupport {
    private static final WeakHashMap<DataObject, DataObjectContext> contexts = new WeakHashMap();
    private static final WeakHashMap<DataObject, DocumentSerializer> serializers = new WeakHashMap();
    private static final WeakHashMap<DataObject, CodeResolver> resolvers = new WeakHashMap();
    private static final WeakHashMap<DataObject, Boolean> documentUpdating = new WeakHashMap();

    private IOSupport() {
    }

    public static synchronized DataObjectContext getDataObjectContext(DataObject dataObject) {
        DataObjectContext context = contexts.get(dataObject);
        if (context == null) {
            IOSupport.getDataObjectInteface(dataObject);
            context = new DataObjectContextImpl(dataObject);
            contexts.put(dataObject, context);
        }
        return context;
    }

    public static synchronized DocumentSerializer getDocumentSerializer(DataObject dataObject) {
        DocumentSerializer serializer = serializers.get(dataObject);
        if (serializer == null) {
            DataObjectContext context = IOSupport.getDataObjectContext(dataObject);
            serializer = new DocumentSerializer(context);
            serializers.put(dataObject, serializer);
            resolvers.put(dataObject, new CodeResolver(context, serializer));
        }
        return serializer;
    }

    public static void forceUpdateCode(DataObject dataObject) {
        CodeResolver resolver = resolvers.get(dataObject);
        if (resolver != null) {
            resolver.forceUpdateCode();
        }
    }

    public static synchronized void notifyDataObjectClosed(DataObject dataObject) {
        DocumentSerializer serializer;
        documentUpdating.remove(dataObject);
        CodeResolver resolver = resolvers.remove(dataObject);
        if (resolver != null) {
            resolver.notifyDataObjectClosed();
        }
        if ((serializer = serializers.remove(dataObject)) != null) {
            serializer.notifyDataObjectClosed();
        }
        contexts.remove(dataObject);
    }

    public static DataObjectInterface getDataObjectInteface(DataObject dataObject) {
        if (!(dataObject instanceof DataObjectInterface)) {
            throw Debug.illegalArgument((Object[])new Object[]{"DataObject does not implement DataObjectInterface", dataObject});
        }
        return (DataObjectInterface)dataObject;
    }

    public static CloneableEditorSupport getCloneableEditorSupport(DataObject dataObject) {
        CloneableEditorSupport editorSupport = (CloneableEditorSupport)dataObject.getLookup().lookup(CloneableEditorSupport.class);
        if (editorSupport == null) {
            throw Debug.illegalArgument((Object[])new Object[]{"Missing CloneableEditorSupport in DataObject lookup", dataObject});
        }
        return editorSupport;
    }

    public static FileObject getDesignFile(DataObjectContext context) {
        return IOSupport.getDataObjectInteface(context.getDataObject()).getDesignFile();
    }

    public static MultiViewDescription[] createEditorSupportPane(DataObjectContext context) {
        Collection<DataEditorView> views = EditorViewFactorySupport.createEditorViews(context);
        ArrayList<CodeEditorViewDescription> descriptions = new ArrayList<CodeEditorViewDescription>();
        for (DataEditorView view : views) {
            descriptions.add((CodeEditorViewDescription)(view.getKind() == DataEditorView.Kind.CODE ? new CodeEditorViewDescription(context, view) : new EditorViewDescription(context, view)));
        }
        return descriptions.toArray(new MultiViewDescription[descriptions.size()]);
    }

    public static DataEditorView getDataEditorView(MultiViewDescription description) {
        return description instanceof EditorViewDescription ? ((EditorViewDescription)description).getView() : null;
    }

    public static synchronized DataObjectContext getDataObjectContextForDocumentInterface(DesignDocument document) {
        assert (Debug.isFriend(ProjectUtils.class, (String)"getDataObjectContextForDocument"));
        DocumentInterface documentInterface = document.getDocumentInterface();
        for (DataObject dataObject : serializers.keySet()) {
            DocumentSerializer documentSerializer;
            if (dataObject == null || !(documentSerializer = IOSupport.getDocumentSerializer(dataObject)).hasDocumentInterface(documentInterface)) continue;
            return IOSupport.getDataObjectContext(dataObject);
        }
        return null;
    }

    public static void notifyDataEditorViewActivated(DataEditorView activatedView) {
        assert (Debug.isFriend(EditorViewElement.class, (String)"componentActivated"));
        if (activatedView == null) {
            return;
        }
        CodeResolver resolver = resolvers.get(activatedView.getContext().getDataObject());
        if (resolver != null) {
            resolver.viewActivated(activatedView);
        }
    }

    public static String resolveProjectType(DataObjectContext context) {
        return DocumentLoad.loadProjectType(context);
    }

    static void resetCodeResolver(DataObject dataObject, DesignDocument document) {
        if (dataObject == null) {
            return;
        }
        CodeResolver resolver = resolvers.get(dataObject);
        if (resolver == null) {
            Debug.warning((Object[])new Object[]{"No CodeResolver for DataObject: " + dataObject});
            return;
        }
        resolver.resetModelModifiedStatus(document);
    }

    public static boolean isDocumentUpdatingEnabled(DataObject dataObject) {
        Boolean enabled = documentUpdating.get(dataObject);
        return enabled != null && enabled != false;
    }

    public static void setDocumentUpdatingEnabled(DataObject dataObject, boolean enabled) {
        documentUpdating.put(dataObject, enabled);
    }
}

