/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.lang.model.element.Element;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.Pair;
import org.netbeans.modules.web.el.ResourceBundles;

final class ELOccurrencesFinder
extends OccurrencesFinder {
    private int caretPosition;
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> occurrences;

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map getOccurrences() {
        return this.occurrences;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.occurrences = Collections.emptyMap();
        if (this.checkAndResetCancel()) {
            return;
        }
        this.computeOccurrences((ELParserResult)result);
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void computeOccurrences(ELParserResult parserResult) {
        ELElement current = parserResult.getElementAt(this.caretPosition);
        if (current == null) {
            return;
        }
        final Node targetNode = current.findNodeAt(this.caretPosition);
        if (targetNode == null || targetNode.getImage() == null) {
            return;
        }
        Pair<ELElement, Node> target = Pair.of(current, targetNode);
        final ArrayList<Pair<ELElement, Node>> matching = new ArrayList<Pair<ELElement, Node>>();
        for (final ELElement eLElement : parserResult.getElements()) {
            if (this.checkAndResetCancel()) {
                return;
            }
            if (!eLElement.isValid()) continue;
            eLElement.getNode().accept(new NodeVisitor(){

                public void visit(Node node) throws ELException {
                    if (node.getClass().equals(targetNode.getClass()) && targetNode.getImage().equals(node.getImage())) {
                        matching.add(Pair.of(eLElement, node));
                    }
                }
            });
        }
        this.occurrences = this.findMatchingTypes(parserResult, target, matching);
        if (this.occurrences.isEmpty()) {
            this.occurrences = this.findMatchingResourceBundleKeys(target, parserResult);
        }
    }

    private Map<OffsetRange, ColoringAttributes> findMatchingResourceBundleKeys(Pair<ELElement, Node> target, ELParserResult parserResult) {
        ResourceBundles resourceBundles = ResourceBundles.get(parserResult.getFileObject());
        if (!resourceBundles.canHaveBundles()) {
            return Collections.emptyMap();
        }
        ArrayList<Pair<AstIdentifier, AstString>> keys = new ArrayList<Pair<AstIdentifier, AstString>>();
        keys.addAll(resourceBundles.collectKeys(((ELElement)target.first).getNode()));
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean found = false;
        for (Pair pair : keys) {
            if (!((AstString)pair.second).equals(target.second)) continue;
            found = true;
            break;
        }
        if (!found) {
            return Collections.emptyMap();
        }
        HashMap<OffsetRange, ColoringAttributes> result = new HashMap<OffsetRange, ColoringAttributes>();
        for (ELElement each : parserResult.getElements()) {
            if (!each.isValid()) continue;
            for (Pair<AstIdentifier, AstString> candidate : resourceBundles.collectKeys(each.getNode())) {
                if (!((AstString)candidate.second).equals(target.second)) continue;
                OffsetRange range = each.getOriginalOffset((Node)candidate.second);
                result.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        }
        return result;
    }

    private Map<OffsetRange, ColoringAttributes> findMatchingTypes(ELParserResult parserResult, Pair<ELElement, Node> target, List<Pair<ELElement, Node>> candidates) {
        ELTypeUtilities typeUtilities = ELTypeUtilities.create(parserResult.getFileObject());
        Element targetType = typeUtilities.resolveElement((ELElement)target.first, (Node)target.second);
        HashMap<OffsetRange, ColoringAttributes> result = new HashMap<OffsetRange, ColoringAttributes>();
        for (Pair<ELElement, Node> candidate : candidates) {
            if (this.checkAndResetCancel()) {
                return result;
            }
            Element type = typeUtilities.resolveElement((ELElement)candidate.first, (Node)candidate.second);
            if (type == null || !((Object)type).equals(targetType)) continue;
            OffsetRange range = ((ELElement)candidate.first).getOriginalOffset((Node)candidate.second);
            result.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        return result;
    }

    private boolean checkAndResetCancel() {
        if (this.cancelled) {
            this.cancelled = false;
            return true;
        }
        return false;
    }
}

