/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public interface ELPlugin {
    public String getName();

    public Collection<String> getMimeTypes();

    public Collection<ImplicitObject> getImplicitObjects(FileObject var1);

    public List<String> getResourceBundles(FileObject var1);

    public static class Query {
        public static Collection<? extends ELPlugin> getELPlugins() {
            Collection plugins = Lookup.getDefault().lookupAll(ELPlugin.class);
            return plugins;
        }

        public static Collection<ImplicitObject> getImplicitObjects(FileObject file) {
            HashSet<ImplicitObject> result = new HashSet<ImplicitObject>();
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                result.addAll(eLPlugin.getImplicitObjects(file));
            }
            return result;
        }

        public static List<String> getResourceBundles(FileObject file) {
            ArrayList<String> result = new ArrayList<String>();
            for (ELPlugin eLPlugin : Query.getELPlugins()) {
                result.addAll(eLPlugin.getResourceBundles(file));
            }
            return result;
        }
    }
}

