/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.ui.FailedAuthenticationSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class CommandBasedDeployer {
    private static final Logger LOGGER = Logger.getLogger(CommandBasedDeployer.class.getName());
    private static RequestProcessor DEPLOYMENT_RP = new RequestProcessor("Weblogic Deployment", 1);
    private static final RequestProcessor URL_WAIT_RP = new RequestProcessor("Weblogic URL Wait", 10);
    private static final int TIMEOUT = 300000;
    private static final boolean SHOW_CONSOLE = Boolean.getBoolean(CommandBasedDeployer.class.getName() + ".showConsole");
    private final WLDeploymentManager deploymentManager;

    public CommandBasedDeployer(WLDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public ProgressObject directoryDeploy(Target target, String name, File file, String host, String port, J2eeModule.Type type) {
        if (this.deploymentManager.isWebProfile()) {
            return this.deploy(CommandBasedDeployer.createModuleId(target, file, host, port, name, type), file, "-name", name, "-source");
        }
        return this.deploy(CommandBasedDeployer.createModuleId(target, file, host, port, name, type), file, "-nostage", "-name", name, "-source");
    }

    public ProgressObject directoryRedeploy(TargetModuleID moduleId) {
        return this.redeploy(new TargetModuleID[]{moduleId}, new String[0]);
    }

    public ProgressObject deploy(Target[] target, File file, File plan, String host, String port) {
        WLTargetModuleID moduleId = CommandBasedDeployer.createModuleId(target[0], file, host, port, file.getName(), null);
        return this.deploy(moduleId, file, new String[0]);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) {
        return this.redeploy(targetModuleID, "-source", file.getAbsolutePath());
    }

    public ProgressObject undeploy(final TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (TargetModuleID module : targetModuleID) {
                    String name = module.getModuleID();
                    ExecutionService service = CommandBasedDeployer.this.createService("-undeploy", lineProcessor, new String[]{"-name", name});
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeploying", (Object)name)));
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value == 0) continue;
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_Timeout")));
                        result.cancel(true);
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_With_Message")));
                    }
                    break;
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Completed")));
                }
            }
        });
        return progress;
    }

    public ProgressObject start(final TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (TargetModuleID module : targetModuleID) {
                    String name = module.getModuleID();
                    ExecutionService service = CommandBasedDeployer.this.createService("-start", lineProcessor, new String[]{"-name", name});
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Starting", (Object)name)));
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            failed = true;
                            progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed", (Object)lineProcessor.getLastLine())));
                            FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                            break;
                        }
                        CommandBasedDeployer.waitForUrlReady(module, progress);
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_Timeout")));
                        result.cancel(true);
                        break;
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_With_Message")));
                        break;
                    }
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Completed")));
                }
            }
        });
        return progress;
    }

    public ProgressObject stop(final TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (TargetModuleID module : targetModuleID) {
                    String name = module.getModuleID();
                    ExecutionService service = CommandBasedDeployer.this.createService("-stop", lineProcessor, new String[]{"-name", name});
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stopping", (Object)name)));
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value == 0) continue;
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_Timeout")));
                        result.cancel(true);
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_With_Message")));
                    }
                    break;
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Completed")));
                }
            }
        });
        return progress;
    }

    public ProgressObject deployDatasource(final Collection<WLDatasource> datasources) {
        final WLProgressObject progress = new WLProgressObject(new TargetModuleID[0]);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (WLDatasource datasource : datasources) {
                    if (datasource.getOrigin() == null) {
                        LOGGER.log(Level.INFO, "Could not deploy {0}", datasource.getName());
                        continue;
                    }
                    ExecutionService service = CommandBasedDeployer.this.createService("-deploy", lineProcessor, new String[]{"-name", datasource.getName(), "-upload", datasource.getOrigin().getAbsolutePath()});
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Deploying", (Object)datasource.getName())));
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value == 0) continue;
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                        break;
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Failed_Timeout")));
                        result.cancel(true);
                        break;
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Failed_With_Message")));
                        break;
                    }
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Datasource_Completed")));
                }
            }
        });
        return progress;
    }

    public ProgressObject deployLibraries(final Set<File> libraries) {
        final WLProgressObject progress = new WLProgressObject(new TargetModuleID[0]);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (File library : libraries) {
                    ExecutionService service = CommandBasedDeployer.this.createService("-deploy", lineProcessor, new String[]{"-library", library.getAbsolutePath()});
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value == 0) continue;
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                        break;
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_Timeout")));
                        result.cancel(true);
                        break;
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_With_Message")));
                        break;
                    }
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Completed")));
                }
            }
        });
        return progress;
    }

    private ProgressObject deploy(final TargetModuleID moduleId, final File file, final String ... parameters) {
        final WLProgressObject progress = new WLProgressObject(moduleId);
        progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deploying", (Object)file.getAbsolutePath())));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                String[] execParams = new String[parameters.length + 1];
                execParams[execParams.length - 1] = file.getAbsolutePath();
                if (parameters.length > 0) {
                    System.arraycopy(parameters, 0, execParams, 0, parameters.length);
                }
                LastLineProcessor lineProcessor = new LastLineProcessor();
                ExecutionService service = CommandBasedDeployer.this.createService("-deploy", lineProcessor, execParams);
                Future result = service.run();
                try {
                    Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                    if (value != 0) {
                        progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                    } else {
                        progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Completed")));
                    }
                }
                catch (InterruptedException ex) {
                    progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_Interrupted")));
                    result.cancel(true);
                    Thread.currentThread().interrupt();
                }
                catch (TimeoutException ex) {
                    progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_Timeout")));
                    result.cancel(true);
                }
                catch (ExecutionException ex) {
                    progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_With_Message")));
                }
            }
        });
        return progress;
    }

    private ProgressObject redeploy(final TargetModuleID[] targetModuleID, final String ... parameters) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (TargetModuleID module : targetModuleID) {
                    String name = module.getModuleID();
                    String[] execParams = new String[parameters.length + 2];
                    execParams[0] = "-name";
                    execParams[1] = name;
                    if (parameters.length > 0) {
                        System.arraycopy(parameters, 0, execParams, 2, parameters.length);
                    }
                    ExecutionService service = CommandBasedDeployer.this.createService("-redeploy", lineProcessor, execParams);
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeploying", (Object)name)));
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value == 0) continue;
                        failed = true;
                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed", (Object)lineProcessor.getLastLine())));
                        FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.deploymentManager, lineProcessor.getLastLine());
                    }
                    catch (InterruptedException ex) {
                        failed = true;
                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Interrupted")));
                        result.cancel(true);
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException ex) {
                        failed = true;
                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Timeout")));
                        result.cancel(true);
                    }
                    catch (ExecutionException ex) {
                        failed = true;
                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_With_Message")));
                    }
                    break;
                }
                if (!failed) {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Completed")));
                }
            }
        });
        return progress;
    }

    private ExecutionService createService(String command, final LineProcessor processor, String ... parameters) {
        InstanceProperties ip = this.deploymentManager.getInstanceProperties();
        String username = ip.getProperty("username");
        String password = ip.getProperty("password");
        String uri = ip.getProperty("url");
        String[] parts = uri.substring("deployer:WebLogic:http://".length()).split(":");
        String host = parts[0];
        String port = parts.length > 1 ? parts[1] : "";
        ExternalProcessBuilder builder = new ExternalProcessBuilder(this.getJavaBinary()).redirectErrorStream(true);
        if (this.deploymentManager.getDomainVersion() == null || !this.deploymentManager.getDomainVersion().isAboveOrEqual(WLDeploymentFactory.VERSION_10)) {
            builder = builder.addArgument("-Dsun.lang.ClassLoader.allowArraySyntax=true");
        }
        builder = builder.addArgument("-cp").addArgument(this.getClassPath()).addArgument("weblogic.Deployer").addArgument("-adminurl").addArgument("t3://" + host + ":" + port).addArgument("-username").addArgument(username).addArgument("-password").addArgument(password).addArgument(command);
        for (String param : parameters) {
            builder = builder.addArgument(param);
        }
        ExecutionDescriptor descriptor = new ExecutionDescriptor().inputVisible(true).outLineBased(true);
        if (processor != null) {
            descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)processor)});
                }
            });
        }
        if (!SHOW_CONSOLE) {
            descriptor = descriptor.inputOutput(InputOutput.NULL);
        }
        return ExecutionService.newService((Callable)builder, (ExecutionDescriptor)descriptor, (String)("weblogic.Deployer " + command));
    }

    private String getClassPath() {
        File weblogicJar = WLPluginProperties.getWeblogicJar(this.deploymentManager);
        if (weblogicJar != null && weblogicJar.isFile() && weblogicJar.exists()) {
            return weblogicJar.getAbsolutePath();
        }
        return "";
    }

    private String getJavaBinary() {
        FileObject folder;
        File file;
        String javaBinary;
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection folders = platform.getInstallFolders();
        String string = javaBinary = Utilities.isWindows() ? "java.exe" : "java";
        if (folders.size() > 0 && (file = FileUtil.toFile((FileObject)(folder = (FileObject)folders.iterator().next()))) != null) {
            javaBinary = file.getAbsolutePath() + File.separator + "bin" + File.separator + (Utilities.isWindows() ? "java.exe" : "java");
        }
        return javaBinary;
    }

    private static void waitForUrlReady(TargetModuleID moduleID, WLProgressObject progressObject) throws InterruptedException, TimeoutException {
        Thread.sleep(3000L);
        long start = System.currentTimeMillis();
        String webUrl = moduleID.getWebURL();
        if (webUrl == null) {
            TargetModuleID[] ch = moduleID.getChildTargetModuleID();
            if (ch != null) {
                for (int i = 0; i < ch.length; ++i) {
                    webUrl = ch[i].getWebURL();
                    if (webUrl == null) continue;
                    CommandBasedDeployer.waitForUrlReady(webUrl, progressObject, start);
                }
            }
        } else {
            CommandBasedDeployer.waitForUrlReady(webUrl, progressObject, start);
        }
    }

    private static void waitForUrlReady(String webUrl, WLProgressObject progressObject, long start) throws InterruptedException, TimeoutException {
        if (webUrl != null) {
            try {
                URL url = new URL(webUrl);
                String waitingMsg = NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                progressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
                while (System.currentTimeMillis() - start < 300000L && !URLWait.waitForUrlReady((ExecutorService)URL_WAIT_RP, url, 1000)) {
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, "Malformed URL {0}", webUrl);
            }
        }
    }

    private static WLTargetModuleID createModuleId(Target target, File file, String host, String port, String name, J2eeModule.Type type) {
        WLTargetModuleID moduleId = new WLTargetModuleID(target, name);
        try {
            String serverUrl = "http://" + host + ":" + port;
            if (J2eeModule.Type.WAR.equals(type) || type == null && file.getName().endsWith(".war")) {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                if (fo != null) {
                    CommandBasedDeployer.configureWarModuleId(moduleId, fo, serverUrl);
                }
            } else if (J2eeModule.Type.EAR.equals(type) || type == null && file.getName().endsWith(".ear")) {
                CommandBasedDeployer.configureEarModuleId(moduleId, file, serverUrl);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureEarModuleId(WLTargetModuleID moduleId, File file, String serverUrl) {
        block15: {
            try {
                FileObject root = null;
                if (file.isDirectory()) {
                    root = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                } else {
                    JarFileSystem jfs = new JarFileSystem();
                    jfs.setJarFile(file);
                    root = jfs.getRoot();
                }
                if (root == null) {
                    return;
                }
                FileObject appXml = root.getFileObject("META-INF/application.xml");
                if (appXml != null) {
                    BufferedInputStream is = new BufferedInputStream(appXml.getInputStream());
                    try {
                        Application ear = DDProvider.getDefault().getDDRoot(new InputSource(is));
                        Module[] modules = ear.getModule();
                        for (int i = 0; i < modules.length; ++i) {
                            WLTargetModuleID childModuleId = null;
                            Web web = modules[i].getWeb();
                            childModuleId = web != null ? new WLTargetModuleID(moduleId.getTarget(), web.getWebUri()) : new WLTargetModuleID(moduleId.getTarget());
                            if (modules[i].getWeb() != null) {
                                childModuleId.setContextURL(serverUrl + modules[i].getWeb().getContextRoot());
                            }
                            moduleId.addChild(childModuleId);
                        }
                        break block15;
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                for (FileObject child : root.getChildren()) {
                    if (!child.hasExt("war") && !child.hasExt("jar")) continue;
                    WLTargetModuleID childModuleId = new WLTargetModuleID(moduleId.getTarget(), child.getNameExt());
                    if (child.hasExt("war")) {
                        CommandBasedDeployer.configureWarModuleId(childModuleId, child, serverUrl);
                    }
                    moduleId.addChild(childModuleId);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (PropertyVetoException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureWarModuleId(WLTargetModuleID moduleId, FileObject file, String serverUrl) {
        if (file.isFolder()) {
            FileObject weblogicXml = file.getFileObject("WEB-INF/weblogic.xml");
            if (weblogicXml != null && weblogicXml.isData()) {
                try {
                    BufferedInputStream is = new BufferedInputStream(weblogicXml.getInputStream());
                    try {
                        String[] ctx = WeblogicWebApp.createGraph(is).getContextRoot();
                        if (ctx != null && ctx.length > 0) {
                            moduleId.setContextURL(serverUrl + ctx[0]);
                            return;
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            moduleId.setContextURL(serverUrl + "/" + file.getNameExt());
        } else {
            try {
                String contextRoot = "/" + file.getName();
                ZipInputStream zis = new ZipInputStream(file.getInputStream());
                try {
                    ZipEntry entry = null;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (!"WEB-INF/weblogic.xml".equals(entry.getName())) continue;
                        String[] ddContextRoots = WeblogicWebApp.createGraph(new ZipEntryInputStream(zis)).getContextRoot();
                        if (ddContextRoots != null && ddContextRoots.length > 0) {
                            contextRoot = ddContextRoots[0];
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Error reading context-root", ex);
                }
                finally {
                    zis.close();
                }
                moduleId.setContextURL(serverUrl + contextRoot);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zis) {
            this.zis = zis;
        }

        @Override
        public int available() throws IOException {
            return this.zis.available();
        }

        @Override
        public void close() throws IOException {
            this.zis.closeEntry();
        }

        @Override
        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.zis.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.zis.skip(n);
        }
    }

    private static class LastLineProcessor
    implements LineProcessor {
        private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("^\\s+at.*$");
        private String last = "";

        private LastLineProcessor() {
        }

        public synchronized void processLine(String line) {
            if (line.length() != 0 && !STACK_TRACE_PATTERN.matcher(line).matches()) {
                this.last = line;
            }
        }

        public synchronized String getLastLine() {
            return this.last;
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

