/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.modules.j2ee.sun.ddloaders.DDViewFactory;
import org.openide.ErrorManager;

public final class DDType {
    private static final String NAME_SUNAPPCLIENT = "sun-application-client.xml";
    private static final String NAME_SUNAPPLICATION = "sun-application.xml";
    private static final String NAME_SUNCMPMAPPING = "sun-cmp-mappings.xml";
    private static final String NAME_SUNEJBJAR = "sun-ejb-jar.xml";
    private static final String NAME_SUNWEBAPP = "sun-web.xml";
    private static final String NAME_SUNRESOURCE = "sun-resources.xml";
    private static final String NAME_GFAPPCLIENT = "glassfish-application-client.xml";
    private static final String NAME_GFAPPLICATION = "glassfish-application.xml";
    private static final String NAME_GFEJBJAR = "glassfish-ejb-jar.xml";
    private static final String NAME_GFWEBAPP = "glassfish-web.xml";
    private static final String NAME_GFRESOURCE = "glassfish-resources.xml";
    public static DDType DD_SUN_WEB_APP = new DDType("sun-web.xml", ModuleType.WAR, DDViewFactory.SunWebDDViewFactory.class);
    public static DDType DD_SUN_EJB_JAR = new DDType("sun-ejb-jar.xml", ModuleType.EJB, DDViewFactory.SunEjbJarDDViewFactory.class);
    public static DDType DD_SUN_APP_CLIENT = new DDType("sun-application-client.xml", ModuleType.CAR, DDViewFactory.SunAppClientDDViewFactory.class);
    public static DDType DD_SUN_APPLICATION = new DDType("sun-application.xml", ModuleType.EAR, DDViewFactory.SunApplicationDDViewFactory.class);
    public static DDType DD_SUN_CMP_MAPPINGS = new DDType("sun-cmp-mappings.xml", ModuleType.EJB, DDViewFactory.SunCmpMappingsDDViewFactory.class);
    public static DDType DD_SUN_RESOURCE = new DDType("sun-resources.xml", null, DDViewFactory.SunResourceDDViewFactory.class);
    public static DDType DD_GF_WEB_APP = new DDType("glassfish-web.xml", ModuleType.WAR, DDViewFactory.SunWebDDViewFactory.class);
    public static DDType DD_GF_EJB_JAR = new DDType("glassfish-ejb-jar.xml", ModuleType.EJB, DDViewFactory.SunEjbJarDDViewFactory.class);
    public static DDType DD_GF_APP_CLIENT = new DDType("glassfish-application-client.xml", ModuleType.CAR, DDViewFactory.SunAppClientDDViewFactory.class);
    public static DDType DD_GF_APPLICATION = new DDType("glassfish-application.xml", ModuleType.EAR, DDViewFactory.SunApplicationDDViewFactory.class);
    public static DDType DD_GF_RESOURCE = new DDType("glassfish-resources.xml", null, DDViewFactory.SunResourceDDViewFactory.class);
    private static Map<String, DDType> fileToTypeMap = new HashMap<String, DDType>(11);
    private final String descriptorName;
    private final ModuleType moduleType;
    private final Class viewFactoryClass;

    public static DDType getDDType(String fileName) {
        return fileToTypeMap.get(fileName);
    }

    private DDType(String ddName, ModuleType type, Class vfc) {
        this.descriptorName = ddName;
        this.moduleType = type;
        this.viewFactoryClass = vfc;
    }

    public String getDescriptorFileName() {
        return this.descriptorName;
    }

    public ModuleType getEditorModuleType() {
        return this.moduleType;
    }

    public DDViewFactory createViewFactory() {
        DDViewFactory factory = null;
        try {
            factory = (DDViewFactory)this.viewFactoryClass.newInstance();
        }
        catch (InstantiationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return factory;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DDType other = (DDType)obj;
        if (!this.viewFactoryClass.equals(other.viewFactoryClass)) {
            return false;
        }
        if (!this.moduleType.equals(other.moduleType)) {
            return false;
        }
        return this.descriptorName.equals(other.descriptorName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.descriptorName != null ? this.descriptorName.hashCode() : 0);
        hash = 37 * hash + (this.viewFactoryClass != null ? this.viewFactoryClass.hashCode() : 0);
        return hash;
    }

    static {
        fileToTypeMap.put(NAME_SUNWEBAPP, DD_SUN_WEB_APP);
        fileToTypeMap.put(NAME_SUNEJBJAR, DD_SUN_EJB_JAR);
        fileToTypeMap.put(NAME_SUNAPPLICATION, DD_SUN_APPLICATION);
        fileToTypeMap.put(NAME_SUNAPPCLIENT, DD_SUN_APP_CLIENT);
        fileToTypeMap.put(NAME_SUNCMPMAPPING, DD_SUN_CMP_MAPPINGS);
        fileToTypeMap.put(NAME_SUNRESOURCE, DD_SUN_RESOURCE);
        fileToTypeMap.put(NAME_GFWEBAPP, DD_GF_WEB_APP);
        fileToTypeMap.put(NAME_GFEJBJAR, DD_GF_EJB_JAR);
        fileToTypeMap.put(NAME_GFAPPLICATION, DD_GF_APPLICATION);
        fileToTypeMap.put(NAME_GFAPPCLIENT, DD_GF_APP_CLIENT);
        fileToTypeMap.put(NAME_GFRESOURCE, DD_GF_RESOURCE);
    }
}

