/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.WrapInfo;
import org.netbeans.modules.editor.lib2.view.WrapLine;

final class WrapInfoUpdater {
    private static final Logger LOG = Logger.getLogger(WrapInfoUpdater.class.getName());
    private static final long serialVersionUID = 0L;
    private final WrapInfo wrapInfo;
    private final ParagraphView paragraphView;
    private final DocumentView documentView;
    private List<WrapLine> wrapLines;
    private WrapLine wrapLine;
    private int childIndex;
    private float x;
    private EditorView childView;
    private double visualOffset;
    private double nextVisualOffset;
    private EditorView childViewPart;
    private float childViewPartWidth;
    private float visualOffsetPartShift;
    private float startPartWidth;
    private EditorView endPart;
    private float availableWidth;
    private float maxLineWidth;
    private boolean wrapLineNonEmpty;
    private boolean wrapTypeWords;
    private StringBuilder logMsgBuilder;

    WrapInfoUpdater(WrapInfo wrapInfo, ParagraphView paragraphView) {
        this.wrapInfo = wrapInfo;
        this.paragraphView = paragraphView;
        this.documentView = paragraphView.getDocumentView();
        assert (this.documentView != null) : "Null documentView";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float initWrapInfo() {
        this.wrapLines = new ArrayList<WrapLine>(2);
        this.wrapTypeWords = this.documentView.getLineWrapType() == DocumentView.LineWrapType.WORD_BOUND;
        float visibleWidth = this.documentView.getVisibleWidth();
        TextLayout lineContinuationTextLayout = this.documentView.getLineContinuationCharTextLayout();
        this.availableWidth = Math.max(visibleWidth - TextLayoutUtils.getWidth(lineContinuationTextLayout), this.documentView.getDefaultCharWidth() * 4.0f);
        StringBuilder stringBuilder = this.logMsgBuilder = LOG.isLoggable(Level.FINE) ? new StringBuilder(100) : null;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("availableWidth:").append(this.availableWidth);
            this.logMsgBuilder.append(", lineContCharWidth:").append(lineContinuationTextLayout.getAdvance());
            this.logMsgBuilder.append("\n");
        }
        try {
            this.initChildVars(0, 0.0);
            do {
                if (this.widthFits()) {
                    this.addAndFetchNext();
                    continue;
                }
                boolean regularBreak = false;
                if (this.wrapTypeWords) {
                    EditorView wrapLineStartView = this.wrapLineStartView();
                    int wrapLineStartOffset = wrapLineStartView.getStartOffset();
                    int childStartOffset = this.childView.getStartOffset();
                    int childEndOffset = this.childView.getEndOffset();
                    WordInfo wordInfo = this.getWordInfo(childStartOffset, wrapLineStartOffset);
                    if (wordInfo != null) {
                        EditorView startPart = this.breakView(false);
                        if (startPart != null) {
                            this.useStartPart(startPart);
                            this.addAndFetchNext();
                            this.finishWrapLine();
                        } else {
                            int wordEndOffset = wordInfo.wordEndOffset();
                            if (wrapLineStartOffset == wordInfo.wordStartOffset()) {
                                while (this.addAndFetchNext() && wordEndOffset > childEndOffset) {
                                    childEndOffset = this.childView.getEndOffset();
                                }
                            } else {
                                this.removeViewsToWordStart(wordInfo.wordStartOffset());
                            }
                            this.finishWrapLine();
                        }
                    } else {
                        regularBreak = true;
                    }
                } else {
                    regularBreak = true;
                }
                if (!regularBreak) continue;
                EditorView startPart = this.breakView(false);
                if (startPart != null) {
                    this.useStartPart(startPart);
                    this.addAndFetchNext();
                    this.finishWrapLine();
                    continue;
                }
                if (!this.wrapLineNonEmpty) {
                    this.addAndFetchNext();
                }
                this.finishWrapLine();
            } while (this.childIndex < this.paragraphView.getViewCount());
            this.finishWrapLine();
        }
        finally {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append('\n');
                LOG.fine(this.logMsgBuilder.toString());
            }
        }
        this.wrapInfo.addAll(this.wrapLines);
        this.wrapInfo.checkIntegrity(this.paragraphView);
        if (this.logMsgBuilder != null) {
            LOG.fine("Resulting wrapInfo:" + this.wrapInfo.toString(this.paragraphView) + "\n");
        }
        return this.maxLineWidth;
    }

    private void initChildVars(int childIndex, double visualOffset) {
        this.childIndex = childIndex;
        this.visualOffset = visualOffset;
        this.nextVisualOffset = this.paragraphView.getViewVisualOffset(childIndex + 1);
        this.childView = this.paragraphView.getEditorView(childIndex);
        this.childViewPart = null;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("child[").append(childIndex).append("]:").append(this.childView);
            this.logMsgBuilder.append(",W=").append(this.width());
            this.logMsgBuilder.append(": ");
        }
    }

    private boolean fetchNextChild() {
        this.childViewPart = null;
        ++this.childIndex;
        if (this.childIndex < this.paragraphView.getViewCount()) {
            this.visualOffset = this.nextVisualOffset;
            this.nextVisualOffset = this.paragraphView.getViewVisualOffset(this.childIndex + 1);
            this.childView = this.paragraphView.getEditorView(this.childIndex);
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("child[").append(this.childIndex).append("]:").append(this.childView);
                this.logMsgBuilder.append(",W=").append(this.width());
                this.logMsgBuilder.append(": ");
            }
            return false;
        }
        return true;
    }

    private WrapLine wrapLine() {
        if (this.wrapLine == null) {
            this.wrapLine = new WrapLine();
        }
        return this.wrapLine;
    }

    private void finishWrapLine() {
        if (this.wrapLine != null) {
            if (this.wrapLineNonEmpty) {
                if (this.x > this.maxLineWidth) {
                    this.maxLineWidth = this.x;
                }
                this.wrapLines.add(this.wrapLine);
            }
            this.wrapLine = null;
            this.wrapLineNonEmpty = false;
            this.x = 0.0f;
        }
    }

    private boolean addAndFetchNext() {
        if (this.childViewPart == null) {
            double childWidth = this.nextVisualOffset - this.visualOffset;
            WrapLine wl = this.wrapLine();
            if (!wl.hasFullViews()) {
                wl.startViewIndex = this.childIndex;
            }
            wl.endViewIndex = this.childIndex + 1;
            this.wrapLineNonEmpty = true;
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("added");
                this.logWrapLineAndX(this.x, (double)this.x + childWidth);
            }
            this.x = (float)((double)this.x + childWidth);
            return this.fetchNextChild();
        }
        if (this.wrapLineNonEmpty) {
            this.addEndPart(this.childViewPart);
        } else {
            this.addStartPart(this.childViewPart);
        }
        if (this.endPart != null) {
            this.useEndPart();
            return false;
        }
        return this.fetchNextChild();
    }

    private boolean widthFits() {
        return (double)this.x + this.width() <= (double)this.availableWidth;
    }

    private double width() {
        double width = this.childViewPart != null ? (double)this.childViewPartWidth : this.nextVisualOffset - this.visualOffset;
        return width;
    }

    private void removeChildren(int startIndex) {
        assert (this.wrapLine.hasFullViews()) : "No full views";
        assert (this.wrapLine.endViewPart == null);
        assert (this.wrapLine.startViewIndex <= startIndex && startIndex < this.wrapLine.endViewIndex) : "startIndex=" + startIndex + " not in WL " + this.wrapLine;
        double startVisualOffset = this.paragraphView.getViewVisualOffset(startIndex);
        this.x = (float)((double)this.x - (this.visualOffset - startVisualOffset));
        this.wrapLine.endViewIndex = startIndex;
        if (!this.wrapLine.hasFullViews() && this.wrapLine.startViewPart == null) {
            this.wrapLineNonEmpty = false;
        }
        this.initChildVars(startIndex, startVisualOffset);
    }

    private void addStartPart(EditorView startPart) {
        assert (!this.wrapLineNonEmpty);
        assert (this.wrapLine().startViewPart == null);
        assert (!this.wrapLine().hasFullViews());
        assert (this.x == 0.0f);
        this.wrapLine().startViewPart = startPart;
        this.wrapLine().startViewX = this.childViewPartWidth;
        this.x += this.childViewPartWidth;
        this.visualOffsetPartShift += this.childViewPartWidth;
        this.wrapLineNonEmpty = true;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  WrapLine's startViewPart ");
            this.logWrapLineAndX(0.0, this.x);
        }
    }

    private void removeStartPart() {
        assert (this.wrapLine.startViewPart != null);
        assert (!this.wrapLine.hasFullViews());
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  Removed startViewPart x=" + this.x + " => 0.");
            this.logWrapLineAndX(0.0, this.x);
        }
        this.childViewPart = this.wrapLine.startViewPart;
        this.childViewPartWidth = this.wrapLine.startViewX;
        this.visualOffsetPartShift -= this.wrapLine.startViewX;
        this.wrapLine.startViewPart = null;
        this.wrapLine.startViewX = 0.0f;
        this.x = 0.0f;
        this.wrapLineNonEmpty = false;
    }

    private void addEndPart(EditorView endPart) {
        assert (this.wrapLine().endViewPart == null);
        this.wrapLine().endViewPart = endPart;
        float oldX = this.x;
        this.x += this.childViewPartWidth;
        this.visualOffsetPartShift += this.childViewPartWidth;
        this.wrapLineNonEmpty = true;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("  WrapLine's endViewPart ");
            this.logWrapLineAndX(oldX, this.x);
        }
    }

    private void removeViewsToWordStart(int wordStartOffset) {
        assert (this.wrapLineNonEmpty) : "Empty wrap line";
        assert (this.wrapLine.endViewPart == null);
        boolean removeInStartPart = false;
        if (this.wrapLine.hasFullViews()) {
            for (int i = this.wrapLine.endViewIndex - 1; i >= this.wrapLine.startViewIndex; --i) {
                int viewStartOffset = ((View)this.paragraphView.getEditorView(i)).getStartOffset();
                boolean bl = removeInStartPart = wordStartOffset < viewStartOffset;
                if (removeInStartPart) continue;
                this.removeChildren(i);
                if (wordStartOffset > viewStartOffset) {
                    EditorView startPart = this.createFragment(wordStartOffset, true);
                    if (startPart != null) {
                        this.useStartPart(startPart);
                        this.addAndFetchNext();
                    } else {
                        this.addAndFetchNext();
                    }
                }
                break;
            }
        } else {
            removeInStartPart = true;
        }
        if (removeInStartPart) {
            this.removeStartPart();
            EditorView startPart = this.createFragment(wordStartOffset, true);
            if (startPart != null) {
                this.useStartPart(startPart);
                this.addAndFetchNext();
            } else {
                this.addAndFetchNext();
            }
        }
    }

    private EditorView wrapLineStartView() {
        EditorView startView = this.wrapLine != null ? (this.wrapLine.startViewPart != null ? this.wrapLine.startViewPart : this.paragraphView.getEditorView(this.wrapLine.startViewIndex)) : this.currentView();
        return startView;
    }

    private EditorView currentView() {
        EditorView view = this.childViewPart != null ? this.childViewPart : this.childView;
        return view;
    }

    private void useStartPart(EditorView startPart) {
        this.childViewPart = startPart;
        this.childViewPartWidth = this.startPartWidth;
    }

    private void useEndPart() {
        this.childViewPart = this.endPart;
        this.childViewPartWidth = this.childViewPart.getPreferredSpan(0);
        this.endPart = null;
    }

    private EditorView breakView(boolean allowWider) {
        assert (this.endPart == null) : "Non-null endPart";
        EditorView view = this.currentView();
        int viewStartOffset = view.getStartOffset();
        if (this.logMsgBuilder != null) {
            // empty if block
        }
        EditorView startPart = (EditorView)view.breakView(0, viewStartOffset, (float)(this.visualOffset + (double)this.visualOffsetPartShift), this.availableWidth - this.x);
        assert (startPart != null);
        if (startPart != view) {
            this.startPartWidth = startPart.getPreferredSpan(0);
            if (allowWider || this.startPartWidth <= this.availableWidth - this.x) {
                int partEndOffset = startPart.getEndOffset();
                this.endPart = (EditorView)view.createFragment(partEndOffset, view.getEndOffset());
                assert (this.endPart != null) : "endPart is null";
                if (this.endPart == view) {
                    startPart = null;
                    this.endPart = null;
                }
            } else {
                startPart = null;
            }
        } else {
            startPart = null;
        }
        return startPart;
    }

    private EditorView createFragment(int breakOffset, boolean allowWider) {
        EditorView view = this.currentView();
        int viewStartOffset = view.getStartOffset();
        int viewEndOffset = view.getEndOffset();
        assert (viewStartOffset < breakOffset) : "viewStartOffset=" + viewStartOffset + " >= breakOffset" + breakOffset;
        assert (breakOffset < viewEndOffset) : "breakOffset=" + breakOffset + " >= viewEndOffset" + viewEndOffset;
        assert (this.endPart == null) : "Non-null endPart";
        EditorView startPart = (EditorView)view.createFragment(viewStartOffset, breakOffset);
        assert (startPart != null);
        if (startPart != view) {
            this.startPartWidth = startPart.getPreferredSpan(0);
            if (allowWider || this.startPartWidth <= this.availableWidth - this.x) {
                this.endPart = (EditorView)view.createFragment(breakOffset, viewEndOffset);
                assert (this.endPart != null) : "EndPart == null";
                if (this.endPart == view) {
                    startPart = null;
                    this.endPart = null;
                }
            } else {
                startPart = null;
            }
        } else {
            startPart = null;
        }
        return startPart;
    }

    private WordInfo getWordInfo(int boundaryOffset, int startOffset) {
        boolean nextCharIsWordPart;
        boolean prevCharIsWordPart;
        CharSequence docText = DocumentUtilities.getText((Document)this.documentView.getDocument());
        boolean bl = prevCharIsWordPart = boundaryOffset > startOffset && Character.isLetterOrDigit(docText.charAt(boundaryOffset - 1));
        if (prevCharIsWordPart && (nextCharIsWordPart = Character.isLetterOrDigit(docText.charAt(boundaryOffset)))) {
            int wordEndOffset;
            int docTextLength = docText.length();
            for (wordEndOffset = boundaryOffset + 1; wordEndOffset < docTextLength && Character.isLetterOrDigit(docText.charAt(wordEndOffset)); ++wordEndOffset) {
            }
            return new WordInfo(docText, boundaryOffset, startOffset, wordEndOffset);
        }
        return null;
    }

    private void logWrapLineAndX(double oldX, double newX) {
        this.logMsgBuilder.append(" to WL[").append(this.wrapLines.size()).append("] at x=").append(oldX).append(";newX=").append(newX).append('\n');
    }

    private static final class WordInfo {
        private CharSequence docText;
        private int boundaryOffset;
        private int startOffset;
        private int wordEndOffset;
        private int wordStartOffset = -1;

        WordInfo(CharSequence docText, int boundaryOffset, int startOffset, int wordEndOffset) {
            this.docText = docText;
            this.boundaryOffset = boundaryOffset;
            this.startOffset = startOffset;
            this.wordEndOffset = wordEndOffset;
        }

        int wordEndOffset() {
            return this.wordEndOffset;
        }

        int wordStartOffset() {
            if (this.wordStartOffset == -1) {
                this.wordStartOffset = this.boundaryOffset - 2;
                while (this.wordStartOffset >= this.startOffset && Character.isLetterOrDigit(this.docText.charAt(this.wordStartOffset))) {
                    --this.wordStartOffset;
                }
                ++this.wordStartOffset;
            }
            return this.wordStartOffset;
        }
    }
}

