/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.visual.model.Utils;

public class CssRuleContent {
    private final List<PropertyChangeListener> LISTENERS = new ArrayList<PropertyChangeListener>();
    private final CssRule rule;

    public static CssRuleContent create(CssRule rule) {
        return new CssRuleContent(rule);
    }

    private CssRuleContent(CssRule rule) {
        this.rule = rule;
    }

    public CssRule rule() {
        return this.rule;
    }

    public List<CssRuleItem> ruleItems() {
        return this.rule.items();
    }

    public String getProperty(String property) {
        CssRuleItem item = this.findItem(property);
        if (item != null) {
            return item.value().name();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssRuleContent) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void modifyProperty(String property, String newValue) throws BadLocationException {
        CssRuleItem item = this.findItem(property);
        newValue = newValue.trim();
        if (item == null && newValue.length() == 0) {
            return;
        }
        if (item != null && newValue.length() == 0) {
            this.firePropertyChange(item, null);
        } else {
            String oldVal;
            String string = oldVal = item == null ? null : item.value().name();
            if (oldVal == null || !newValue.equals(oldVal)) {
                CssRuleItem newRuleItem = new CssRuleItem(property, newValue);
                this.firePropertyChange(item, newRuleItem);
            }
        }
    }

    public String getFormattedString() {
        StringWriter strWriter = new StringWriter();
        for (CssRuleItem item : this.ruleItems()) {
            String property = item.key().name();
            String propertyValue = item.value().name().trim();
            if (!propertyValue.equals(Utils.NOT_SET) && !propertyValue.equals("")) {
                strWriter.write("   " + property);
                strWriter.write(": ");
                strWriter.write(propertyValue);
                strWriter.write("; ");
            }
            strWriter.write("\n");
        }
        return strWriter.toString();
    }

    public String toString() {
        return this.getFormattedString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.LISTENERS.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.LISTENERS.remove(listener);
    }

    private synchronized void firePropertyChange(CssRuleItem oldVal, CssRuleItem newVal) {
        ArrayList<PropertyChangeListener> copy = new ArrayList<PropertyChangeListener>(this.LISTENERS);
        for (PropertyChangeListener l : copy) {
            l.propertyChange(new PropertyChangeEvent(this, "property", oldVal, newVal));
        }
    }

    private CssRuleItem findItem(String keyName) {
        for (CssRuleItem ri : this.ruleItems()) {
            if (!ri.key().name().equals(keyName)) continue;
            return ri;
        }
        return null;
    }
}

