/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryLs;
import org.netbeans.modules.remote.impl.fs.DirEntrySftp;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryStorage {
    private final Map<String, DirEntry> entries = new HashMap<String, DirEntry>();
    private final File file;
    private static final int VERSION = RemoteDirectory.getLsViaSftp() ? 3 : 2;
    private static final int ODD_VERSION = RemoteDirectory.getLsViaSftp() ? 3 : 2;

    public DirectoryStorage(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException, FormatException {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            BufferedReader br = null;
            try {
                int version;
                br = new BufferedReader(new FileReader(this.file));
                String line = br.readLine();
                String prefix = "VERSION=";
                if (line == null || !line.startsWith(prefix)) {
                    throw new FormatException("Wrong file format " + this.file.getAbsolutePath() + " line " + line, false);
                }
                try {
                    version = Integer.parseInt(line.substring(prefix.length()));
                }
                catch (NumberFormatException nfe) {
                    throw new FormatException("wrong version format " + this.file.getAbsolutePath(), nfe);
                }
                if (version > VERSION) {
                    throw new FormatException("directory cache file version " + version + " not supported: " + this.file.getAbsolutePath(), true);
                }
                if (version < ODD_VERSION) {
                    throw new FormatException("Discarding old directory cache file version " + version + ' ' + this.file.getAbsolutePath(), true);
                }
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) continue;
                    DirEntry entry = RemoteDirectory.getLsViaSftp() ? DirEntrySftp.fromExternalForm(line) : DirEntryLs.fromExternalForm(line);
                    this.entries.put(entry.getName(), entry);
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
    }

    public void touch() throws IOException {
        if (this.file.exists()) {
            this.file.setLastModified(System.currentTimeMillis());
        } else {
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        BufferedWriter wr = null;
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            try {
                wr = new BufferedWriter(new FileWriter(this.file));
                wr.write("VERSION=" + VERSION + "\n");
                for (DirEntry entry : this.entries.values()) {
                    wr.write(entry.toExternalForm());
                    wr.write(10);
                }
                wr.close();
                wr = null;
            }
            finally {
                if (wr != null) {
                    wr.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirEntry getEntry(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.get(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirEntry removeEntry(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.remove(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEntries(Collection<DirEntry> newEntries) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            this.entries.clear();
            for (DirEntry entry : newEntries) {
                this.entries.put(entry.getName(), entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> list() {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return new ArrayList<DirEntry>(this.entries.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAddEntry(DirEntry entry) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            this.entries.put(entry.getName(), entry);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DirectoryStorage");
        sb.append(" file=").append(this.file.getAbsolutePath());
        sb.append(" entries.size()=").append(this.entries.size()).append("\n");
        int cnt = 0;
        for (DirEntry entry : this.entries.values()) {
            if (cnt > 0) {
                sb.append('\n');
            }
            if (cnt++ <= 10) {
                sb.append(entry);
                continue;
            }
            sb.append("...");
            break;
        }
        return sb.toString();
    }
}

