/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkChild;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public abstract class RemoteLinkBase
extends RemoteFileObjectBase {
    protected RemoteLinkBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath) {
        super(fileSystem, execEnv, parent, remotePath, null);
    }

    public abstract RemoteFileObjectBase getDelegate();

    protected FileNotFoundException fileNotFoundException(String operation) {
        return new FileNotFoundException("can not " + operation + ' ' + this.getPath() + ": can not find link target");
    }

    public RemoteFileObjectBase[] getChildren() {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase[] children = delegate.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.wrapFileObject(children[i], null);
            }
            return children;
        }
        return new RemoteFileObjectBase[0];
    }

    private RemoteFileObjectBase wrapFileObject(RemoteFileObjectBase fo, String relativePath) {
        String childAbsPath = relativePath == null ? this.getPath() + '/' + fo.getNameExt() : RemoteFileSystemUtils.normalize(this.getPath() + '/' + relativePath);
        return new RemoteLinkChild(this.getFileSystem(), this.getExecutionEnvironment(), this, childAbsPath, fo);
    }

    public RemoteFileObjectBase getFileObject(String name, String ext) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase fo = delegate.getFileObject(name, ext);
            if (fo != null) {
                fo = this.wrapFileObject(fo, null);
            }
            return fo;
        }
        return null;
    }

    public RemoteFileObjectBase getFileObject(String relativePath) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase fo = delegate.getFileObject(relativePath);
            if (fo != null) {
                fo = this.wrapFileObject(fo, relativePath);
            }
            return fo;
        }
        return null;
    }

    public void refresh() {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.refresh();
        }
    }

    public void refresh(boolean expected) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.refresh(expected);
        }
    }

    public boolean isFolder() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.isFolder();
    }

    public boolean isData() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? true : delegate.isData();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate == null) {
            throw this.fileNotFoundException("read");
        }
        return delegate.getInputStream();
    }

    public FileObject createData(String name) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? null : delegate.createData(name);
    }

    public boolean canRead() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.canRead();
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.removeFileChangeListener(fcl);
        }
    }

    public FileLock lock() throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.lock();
        }
        throw this.fileNotFoundException("lock");
    }

    public boolean isValid() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate != null && delegate.isValid();
    }

    public boolean isReadOnly() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? true : delegate.isReadOnly();
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getOutputStream(lock);
        }
        throw this.fileNotFoundException("write");
    }

    protected void refreshImpl() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.refreshImpl();
        }
    }

    public FileObject createFolder(String name) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.createFolder(name);
        }
        throw this.fileNotFoundException("create a folder in");
    }

    public FileObject createData(String name, String ext) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.createData(name, ext);
        }
        throw this.fileNotFoundException("create a file in");
    }

    public boolean canWrite() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.canWrite();
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.addFileChangeListener(fcl);
        }
    }
}

