/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuListener;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DescriptablePathChooser;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;

public class JMenuOperator
extends JMenuItemOperator
implements Outputable,
Timeoutable {
    public static final String SUBMENU_PREFIX_DPROP = "Submenu";
    private static final long WAIT_POPUP_TIMEOUT = 60000L;
    private static final long WAIT_BEFORE_POPUP_TIMEOUT = 0L;
    private static final long PUSH_MENU_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private MenuDriver driver = DriverManager.getMenuDriver(this);

    public JMenuOperator(JMenu menu) {
        super(menu);
    }

    public JMenuOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JMenu)cont.waitSubComponent(new JMenuFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JMenuOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JMenuOperator(ContainerOperator cont, String text, int index) {
        this((JMenu)JMenuOperator.waitComponent(cont, (ComponentChooser)new JMenuByLabelFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JMenuOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JMenuOperator(ContainerOperator cont, int index) {
        this((JMenu)JMenuOperator.waitComponent(cont, (ComponentChooser)new JMenuFinder(), index));
        this.copyEnvironment(cont);
    }

    public JMenuOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JMenu findJMenu(Container cont, ComponentChooser chooser, int index) {
        return (JMenu)JMenuOperator.findComponent(cont, new JMenuFinder(chooser), index);
    }

    public static JMenu findJMenu(Container cont, ComponentChooser chooser) {
        return JMenuOperator.findJMenu(cont, chooser, 0);
    }

    public static JMenu findJMenu(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JMenuOperator.findJMenu(cont, new JMenuByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JMenu findJMenu(Container cont, String text, boolean ce, boolean ccs) {
        return JMenuOperator.findJMenu(cont, text, ce, ccs, 0);
    }

    public static JMenu waitJMenu(Container cont, ComponentChooser chooser, int index) {
        return (JMenu)JMenuOperator.waitComponent(cont, (ComponentChooser)new JMenuFinder(chooser), index);
    }

    public static JMenu waitJMenu(Container cont, ComponentChooser chooser) {
        return JMenuOperator.waitJMenu(cont, chooser, 0);
    }

    public static JMenu waitJMenu(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JMenuOperator.waitJMenu(cont, new JMenuByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JMenu waitJMenu(Container cont, String text, boolean ce, boolean ccs) {
        return JMenuOperator.waitJMenu(cont, text, ce, ccs, 0);
    }

    public static void performInit() {
        Timeouts.initDefault("JMenuOperator.WaitBeforePopupTimeout", 0L);
        Timeouts.initDefault("JMenuOperator.WaitPopupTimeout", 60000L);
        Timeouts.initDefault("JMenuOperator.PushMenuTimeout", 60000L);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = DriverManager.getMenuDriver(this);
    }

    public JMenuItem pushMenu(final ComponentChooser[] choosers) {
        return (JMenuItem)this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JMenuOperator.this.getQueueTool().waitEmpty();
                Object result = JMenuOperator.this.driver.pushMenu(JMenuOperator.this, JMenuOperator.converChoosers(choosers));
                JMenuOperator.this.getQueueTool().waitEmpty();
                return result;
            }

            public String getDescription() {
                return JMenuOperator.createDescription(choosers);
            }
        }, this.getTimeouts().getTimeout("JMenuOperator.PushMenuTimeout"));
    }

    public void pushMenuNoBlock(final ComponentChooser[] choosers) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Menu pushing"){

            public Object doAction(Object param) {
                JMenuOperator.this.getQueueTool().waitEmpty();
                Object result = JMenuOperator.this.driver.pushMenu(JMenuOperator.this, JMenuOperator.converChoosers(choosers));
                JMenuOperator.this.getQueueTool().waitEmpty();
                return result;
            }
        });
    }

    public JMenuItem pushMenu(String[] names, Operator.StringComparator comparator) {
        return this.pushMenu(JMenuItemOperator.createChoosers(names, comparator));
    }

    public JMenuItem pushMenu(String[] names, boolean ce, boolean ccs) {
        return this.pushMenu(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public void pushMenuNoBlock(String[] names, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(JMenuItemOperator.createChoosers(names, comparator));
    }

    public void pushMenuNoBlock(String[] names, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public JMenuItem pushMenu(String[] names) {
        return this.pushMenu(names, this.getComparator());
    }

    public void pushMenuNoBlock(String[] names) {
        this.pushMenuNoBlock(names, this.getComparator());
    }

    public JMenuItem pushMenu(String path, String delim, Operator.StringComparator comparator) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        return this.pushMenu(this.parseString(path, delim), comparator);
    }

    public JMenuItem pushMenu(String path, Operator.StringComparator comparator) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        return this.pushMenu(this.parseString(path), comparator);
    }

    public JMenuItem pushMenu(String path, String delim, boolean ce, boolean ccs) {
        return this.pushMenu(path, delim, new Operator.DefaultStringComparator(ce, ccs));
    }

    public void pushMenuNoBlock(String path, String delim, Operator.StringComparator comparator) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.pushMenuNoBlock(this.parseString(path, delim), comparator);
    }

    public void pushMenuNoBlock(String path, Operator.StringComparator comparator) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.pushMenuNoBlock(this.parseString(path), comparator);
    }

    public void pushMenuNoBlock(String path, String delim, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(this.parseString(path, delim), (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public JMenuItem pushMenu(String path, String delim) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        return this.pushMenu(this.parseString(path, delim));
    }

    public JMenuItem pushMenu(String path) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        return this.pushMenu(this.parseString(path));
    }

    public void pushMenuNoBlock(String path, String delim) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.pushMenuNoBlock(this.parseString(path, delim));
    }

    public void pushMenuNoBlock(String path) {
        this.output.printLine("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.output.printGolden("Pushing " + path + " menu in \n    " + this.toStringSource());
        this.pushMenuNoBlock(this.parseString(path));
    }

    public JMenuItemOperator[] showMenuItems(ComponentChooser[] choosers) {
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(choosers), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] path, Operator.StringComparator comparator) {
        return this.showMenuItems(JMenuItemOperator.createChoosers(path, comparator));
    }

    public JMenuItemOperator[] showMenuItems(String[] path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim) {
        return this.showMenuItems(path, delim, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(ComponentChooser[] choosers) {
        JMenu menu;
        ComponentChooser[] parentPath = this.getParentPath(choosers);
        if (parentPath.length > 0) {
            menu = (JMenu)this.pushMenu(parentPath);
        } else {
            this.push();
            menu = (JMenu)this.getSource();
        }
        JPopupMenuOperator popup = new JPopupMenuOperator(menu.getPopupMenu());
        popup.copyEnvironment(this);
        JMenuItemOperator result = new JMenuItemOperator((ContainerOperator)popup, choosers[choosers.length - 1]);
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path, Operator.StringComparator comparator) {
        JMenu menu;
        String[] parentPath = this.getParentPath(path);
        if (parentPath.length > 0) {
            menu = (JMenu)this.pushMenu(parentPath, comparator);
        } else {
            this.push();
            menu = (JMenu)this.getSource();
        }
        JPopupMenuOperator popup = new JPopupMenuOperator(menu.getPopupMenu());
        popup.copyEnvironment(this);
        JMenuItemOperator result = new JMenuItemOperator((ContainerOperator)popup, path[path.length - 1]);
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator showMenuItem(String path, String delim) {
        return this.showMenuItem(path, delim, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path), comparator);
    }

    public JMenuItemOperator showMenuItem(String path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        Object[] items = new String[((JMenu)this.getSource()).getItemCount()];
        for (int i = 0; i < ((JMenu)this.getSource()).getItemCount(); ++i) {
            items[i] = ((JMenu)this.getSource()).getItem(i) != null && ((JMenu)this.getSource()).getItem(i).getText() != null ? ((JMenu)this.getSource()).getItem(i).getText() : "null";
        }
        this.addToDump(result, SUBMENU_PREFIX_DPROP, items);
        return result;
    }

    public JMenuItem add(final String string) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).add(string);
            }
        });
    }

    public JMenuItem add(final javax.swing.Action action) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).add(action);
            }
        });
    }

    public JMenuItem add(final JMenuItem jMenuItem) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).add(jMenuItem);
            }
        });
    }

    public void addMenuListener(final MenuListener menuListener) {
        this.runMapping(new Operator.MapVoidAction("addMenuListener"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).addMenuListener(menuListener);
            }
        });
    }

    public void addSeparator() {
        this.runMapping(new Operator.MapVoidAction("addSeparator"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).addSeparator();
            }
        });
    }

    public int getDelay() {
        return this.runMapping(new Operator.MapIntegerAction("getDelay"){

            public int map() {
                return ((JMenu)JMenuOperator.this.getSource()).getDelay();
            }
        });
    }

    public JMenuItem getItem(final int i) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("getItem"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).getItem(i);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            public int map() {
                return ((JMenu)JMenuOperator.this.getSource()).getItemCount();
            }
        });
    }

    public Component getMenuComponent(final int i) {
        return (Component)this.runMapping(new Operator.MapAction("getMenuComponent"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).getMenuComponent(i);
            }
        });
    }

    public int getMenuComponentCount() {
        return this.runMapping(new Operator.MapIntegerAction("getMenuComponentCount"){

            public int map() {
                return ((JMenu)JMenuOperator.this.getSource()).getMenuComponentCount();
            }
        });
    }

    public Component[] getMenuComponents() {
        return (Component[])this.runMapping(new Operator.MapAction("getMenuComponents"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).getMenuComponents();
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return (JPopupMenu)this.runMapping(new Operator.MapAction("getPopupMenu"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).getPopupMenu();
            }
        });
    }

    public void insert(final String string, final int i) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).insert(string, i);
            }
        });
    }

    public JMenuItem insert(final javax.swing.Action action, final int i) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("insert"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).insert(action, i);
            }
        });
    }

    public JMenuItem insert(final JMenuItem jMenuItem, final int i) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("insert"){

            public Object map() {
                return ((JMenu)JMenuOperator.this.getSource()).insert(jMenuItem, i);
            }
        });
    }

    public void insertSeparator(final int i) {
        this.runMapping(new Operator.MapVoidAction("insertSeparator"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).insertSeparator(i);
            }
        });
    }

    public boolean isMenuComponent(final Component component) {
        return this.runMapping(new Operator.MapBooleanAction("isMenuComponent"){

            public boolean map() {
                return ((JMenu)JMenuOperator.this.getSource()).isMenuComponent(component);
            }
        });
    }

    public boolean isPopupMenuVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isPopupMenuVisible"){

            public boolean map() {
                return ((JMenu)JMenuOperator.this.getSource()).isPopupMenuVisible();
            }
        });
    }

    public boolean isTearOff() {
        return this.runMapping(new Operator.MapBooleanAction("isTearOff"){

            public boolean map() {
                return ((JMenu)JMenuOperator.this.getSource()).isTearOff();
            }
        });
    }

    public boolean isTopLevelMenu() {
        return this.runMapping(new Operator.MapBooleanAction("isTopLevelMenu"){

            public boolean map() {
                return ((JMenu)JMenuOperator.this.getSource()).isTopLevelMenu();
            }
        });
    }

    public void remove(final JMenuItem jMenuItem) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).remove(jMenuItem);
            }
        });
    }

    public void removeMenuListener(final MenuListener menuListener) {
        this.runMapping(new Operator.MapVoidAction("removeMenuListener"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).removeMenuListener(menuListener);
            }
        });
    }

    public void setDelay(final int i) {
        this.runMapping(new Operator.MapVoidAction("setDelay"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).setDelay(i);
            }
        });
    }

    public void setMenuLocation(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setMenuLocation"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).setMenuLocation(i, i1);
            }
        });
    }

    public void setPopupMenuVisible(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setPopupMenuVisible"){

            public void map() {
                ((JMenu)JMenuOperator.this.getSource()).setPopupMenuVisible(b);
            }
        });
    }

    static String createDescription(ComponentChooser[] choosers) {
        String description = "(";
        for (int i = 0; i < choosers.length; ++i) {
            if (i > 0) {
                description = description + ", ";
            }
            description = description + choosers[i].getDescription();
        }
        description = description + ")";
        return "Menu pushing: " + description;
    }

    static DescriptablePathChooser converChoosers(final ComponentChooser[] choosers) {
        return new DescriptablePathChooser(){

            public boolean checkPathComponent(int depth, Object component) {
                return choosers[depth].checkComponent((Component)component);
            }

            public int getDepth() {
                return choosers.length;
            }

            public String getDescription() {
                return JMenuOperator.createDescription(choosers);
            }
        };
    }

    static {
        JMenuOperator.performInit();
    }

    public static class JMenuFinder
    extends Operator.Finder {
        public JMenuFinder(ComponentChooser sf) {
            super(JMenu.class, sf);
        }

        public JMenuFinder() {
            super(JMenu.class);
        }
    }

    public static class JMenuByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JMenuByLabelFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public JMenuByLabelFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JMenu && ((JMenu)comp).getText() != null) {
                return this.comparator.equals(((JMenu)comp).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JMenu with text \"" + this.label + "\"";
        }
    }
}

