/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyOrFieldReference
extends SpelNodeImpl {
    private final boolean nullSafe;
    private final String name;
    private volatile PropertyAccessor cachedReadAccessor;
    private volatile PropertyAccessor cachedWriteAccessor;

    public PropertyOrFieldReference(boolean nullSafe, String propertyOrFieldName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.nullSafe = nullSafe;
        this.name = propertyOrFieldName;
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue result = this.readProperty(state, this.name);
        if (result.getValue() != null) return result;
        if (!state.getConfiguration().isAutoGrowNullReferences()) return result;
        if (!this.nextChildIs(Indexer.class, PropertyOrFieldReference.class)) return result;
        TypeDescriptor resultDescriptor = result.getTypeDescriptor();
        if (resultDescriptor.getType().equals(List.class) || resultDescriptor.getType().equals(Map.class)) {
            if (resultDescriptor.getType().equals(List.class)) {
                try {
                    if (!this.isWritable(state)) return result;
                    List newList = (List)ArrayList.class.newInstance();
                    this.writeProperty(state, this.name, newList);
                    return this.readProperty(state, this.name);
                }
                catch (InstantiationException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
            }
            try {
                if (!this.isWritable(state)) return result;
                Map newMap = (Map)HashMap.class.newInstance();
                this.writeProperty(state, this.name, newMap);
                return this.readProperty(state, this.name);
            }
            catch (InstantiationException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
        }
        try {
            if (!this.isWritable(state)) return result;
            Object newObject = result.getTypeDescriptor().getType().newInstance();
            this.writeProperty(state, this.name, newObject);
            return this.readProperty(state, this.name);
        }
        catch (InstantiationException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result.getTypeDescriptor().getType());
        }
        catch (IllegalAccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result.getTypeDescriptor().getType());
        }
    }

    @Override
    public void setValue(ExpressionState state, Object newValue) throws SpelEvaluationException {
        this.writeProperty(state, this.name, newValue);
    }

    @Override
    public boolean isWritable(ExpressionState state) throws SpelEvaluationException {
        return this.isWritableProperty(this.name, state);
    }

    @Override
    public String toStringAST() {
        return this.name;
    }

    private TypedValue readProperty(ExpressionState state, String name) throws EvaluationException {
        TypedValue contextObject = state.getActiveContextObject();
        Object targetObject = contextObject.getValue();
        if (targetObject == null && this.nullSafe) {
            return TypedValue.NULL;
        }
        PropertyAccessor accessorToUse = this.cachedReadAccessor;
        if (accessorToUse != null) {
            try {
                return accessorToUse.read(state.getEvaluationContext(), contextObject.getValue(), name);
            }
            catch (AccessException accessException) {
                this.cachedReadAccessor = null;
            }
        }
        Class<?> contextObjectClass = this.getObjectClass(contextObject.getValue());
        List<PropertyAccessor> accessorsToTry = this.getPropertyAccessorsToTry(contextObjectClass, state);
        EvaluationContext eContext = state.getEvaluationContext();
        if (accessorsToTry != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canRead(eContext, contextObject.getValue(), name)) continue;
                    if (accessor instanceof ReflectivePropertyAccessor) {
                        accessor = ((ReflectivePropertyAccessor)accessor).createOptimalAccessor(eContext, contextObject.getValue(), name);
                    }
                    this.cachedReadAccessor = accessor;
                    return accessor.read(eContext, contextObject.getValue(), name);
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(ae, SpelMessage.EXCEPTION_DURING_PROPERTY_READ, name, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE_ON_NULL, name);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE, name, FormatHelper.formatClassNameForMessage(contextObjectClass));
    }

    private void writeProperty(ExpressionState state, String name, Object newValue) throws SpelEvaluationException {
        Class<?> contextObjectClass;
        List<PropertyAccessor> accessorsToTry;
        TypedValue contextObject = state.getActiveContextObject();
        EvaluationContext eContext = state.getEvaluationContext();
        if (contextObject.getValue() == null && this.nullSafe) {
            return;
        }
        PropertyAccessor accessorToUse = this.cachedWriteAccessor;
        if (accessorToUse != null) {
            try {
                accessorToUse.write(state.getEvaluationContext(), contextObject.getValue(), name, newValue);
                return;
            }
            catch (AccessException accessException) {
                this.cachedWriteAccessor = null;
            }
        }
        if ((accessorsToTry = this.getPropertyAccessorsToTry(contextObjectClass = this.getObjectClass(contextObject.getValue()), state)) != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canWrite(eContext, contextObject.getValue(), name)) continue;
                    this.cachedWriteAccessor = accessor;
                    accessor.write(eContext, contextObject.getValue(), name, newValue);
                    return;
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, name, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE_ON_NULL, name);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE, name, FormatHelper.formatClassNameForMessage(contextObjectClass));
    }

    public boolean isWritableProperty(String name, ExpressionState state) throws SpelEvaluationException {
        Object contextObject = state.getActiveContextObject().getValue();
        EvaluationContext eContext = state.getEvaluationContext();
        List<PropertyAccessor> resolversToTry = this.getPropertyAccessorsToTry(this.getObjectClass(contextObject), state);
        if (resolversToTry != null) {
            for (PropertyAccessor pfResolver : resolversToTry) {
                try {
                    if (!pfResolver.canWrite(eContext, contextObject, name)) continue;
                    return true;
                }
                catch (AccessException accessException) {}
            }
        }
        return false;
    }

    private List<PropertyAccessor> getPropertyAccessorsToTry(Class<?> targetType, ExpressionState state) {
        ArrayList<PropertyAccessor> specificAccessors = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> generalAccessors = new ArrayList<PropertyAccessor>();
        for (PropertyAccessor resolver : state.getPropertyAccessors()) {
            Class[] targets = resolver.getSpecificTargetClasses();
            if (targets == null) {
                generalAccessors.add(resolver);
                continue;
            }
            if (targetType == null) continue;
            int pos = 0;
            Class[] classArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (clazz == targetType) {
                    specificAccessors.add(pos++, resolver);
                } else if (clazz.isAssignableFrom(targetType)) {
                    generalAccessors.add(resolver);
                }
                ++n2;
            }
        }
        ArrayList<PropertyAccessor> resolvers = new ArrayList<PropertyAccessor>();
        resolvers.addAll(specificAccessors);
        resolvers.addAll(generalAccessors);
        return resolvers;
    }
}

