/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene.support;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.parsing.lucene.DocumentIndexImpl;
import org.netbeans.modules.parsing.lucene.IndexDocumentImpl;
import org.netbeans.modules.parsing.lucene.IndexFactory;
import org.netbeans.modules.parsing.lucene.LuceneIndexFactory;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.openide.util.Parameters;

public final class IndexManager {
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    static IndexFactory factory = new LuceneIndexFactory();

    private IndexManager() {
    }

    public static <R> R writeAccess(final Action<R> action) throws IOException, InterruptedException {
        assert (action != null);
        lock.writeLock().lock();
        try {
            Object object = ProvidedExtensions.priorityIO((Callable)new Callable<R>(){

                @Override
                public R call() throws Exception {
                    return action.run();
                }
            });
            return (R)object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static <R> R readAccess(final Action<R> action) throws IOException, InterruptedException {
        assert (action != null);
        lock.readLock().lock();
        try {
            Object object = ProvidedExtensions.priorityIO((Callable)new Callable<R>(){

                @Override
                public R call() throws Exception {
                    return action.run();
                }
            });
            return (R)object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static boolean holdsWriteLock() {
        return lock.isWriteLockedByCurrentThread();
    }

    public static Index createIndex(@NonNull File cacheFolder, @NonNull Analyzer analyzer) throws IOException {
        Parameters.notNull((CharSequence)"cacheFolder", (Object)cacheFolder);
        Parameters.notNull((CharSequence)"analyzer", (Object)analyzer);
        return factory.createIndex(cacheFolder, analyzer);
    }

    public static DocumentIndex createDocumentIndex(@NonNull Index index) {
        Parameters.notNull((CharSequence)"index", (Object)index);
        return new DocumentIndexImpl(index);
    }

    public static DocumentIndex createDocumentIndex(@NonNull File cacheFolder) throws IOException {
        Parameters.notNull((CharSequence)"cacheFolder", (Object)cacheFolder);
        return IndexManager.createDocumentIndex(IndexManager.createIndex(cacheFolder, (Analyzer)new KeywordAnalyzer()));
    }

    public static IndexDocument createDocument(@NonNull String primaryKey) {
        Parameters.notNull((CharSequence)"primaryKey", (Object)primaryKey);
        return new IndexDocumentImpl(primaryKey);
    }

    public static interface Action<R> {
        public R run() throws IOException, InterruptedException;
    }
}

