/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.netbeans.modules.web.jsf.editor.el.JsfVariablesModel;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class JsfELVariableResolver
implements ELVariableResolver {
    public String getBeanClass(String string, FileObject fileObject) {
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(fileObject)) {
            if (!facesManagedBean.getManagedBeanName().equals(string)) continue;
            return facesManagedBean.getManagedBeanClass();
        }
        return null;
    }

    public String getBeanName(String string, FileObject fileObject) {
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(fileObject)) {
            if (!facesManagedBean.getManagedBeanClass().equals(string)) continue;
            return facesManagedBean.getManagedBeanName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject fileObject) {
        List<FacesManagedBean> list = this.getJsfManagedBeans(fileObject);
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>(list.size());
        for (FacesManagedBean facesManagedBean : list) {
            arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)facesManagedBean.getManagedBeanName(), (String)facesManagedBean.getManagedBeanClass()));
        }
        return arrayList;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int n) {
        List<JsfVariableContext> list = this.getAllJsfVariables(snapshot, n);
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>(list.size());
        for (JsfVariableContext jsfVariableContext : list) {
            String string = jsfVariableContext.getResolvedExpression();
            if (string == null) continue;
            arrayList.add(ELVariableResolver.VariableInfo.createUnresolvedVariable((String)jsfVariableContext.getVariableName(), (String)string));
        }
        return arrayList;
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String string, Snapshot snapshot) {
        if ("cc".equals(string)) {
            final JsfPageModelFactory jsfPageModelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
            assert (jsfPageModelFactory != null);
            final AtomicReference atomicReference = new AtomicReference();
            try {
                ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                        if (result instanceof HtmlParserResult) {
                            atomicReference.set((CompositeComponentModel)jsfPageModelFactory.getModel((HtmlParserResult)result));
                        }
                    }
                });
                CompositeComponentModel compositeComponentModel = (CompositeComponentModel)atomicReference.get();
                if (compositeComponentModel != null) {
                    Collection<Map<String, String>> collection = compositeComponentModel.getExistingInterfaceAttributes();
                    ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>();
                    for (Map<String, String> map : collection) {
                        String string2 = map.get("name");
                        if (string2 == null) continue;
                        arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)string2, (String)"java.lang.Object"));
                    }
                    return arrayList;
                }
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String string, Snapshot snapshot) {
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>();
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(snapshot.getSource().getFileObject())) {
            if (!string.equals(facesManagedBean.getManagedBeanScopeString())) continue;
            arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)facesManagedBean.getManagedBeanName(), (String)facesManagedBean.getManagedBeanClass()));
        }
        return arrayList;
    }

    private List<FacesManagedBean> getJsfManagedBeans(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        return webModule != null ? JSFBeanCache.getBeans((WebModule)webModule) : Collections.emptyList();
    }

    private List<JsfVariableContext> getAllJsfVariables(Snapshot snapshot, final int n) {
        final ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (result instanceof HtmlParserResult) {
                        JsfVariablesModel jsfVariablesModel = JsfVariablesModel.getModel((HtmlParserResult)result, resultIterator.getSnapshot());
                        List<JsfVariableContext> list = jsfVariablesModel.getAllAvailableVariables(n, false);
                        arrayList.addAll(list);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return arrayList;
    }
}

