/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.util.NbCollections;

public final class ClassPathUiSupport {
    private ClassPathUiSupport() {
    }

    public static DefaultListModel createListModel(Iterator it) {
        DefaultListModel model = new DefaultListModel();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    public static Iterator<ClassPathSupport.Item> getIterator(DefaultListModel model) {
        return ClassPathUiSupport.getList(model).iterator();
    }

    public static List<ClassPathSupport.Item> getList(DefaultListModel model) {
        return Collections.list(NbCollections.checkedEnumerationByFilter(model.elements(), ClassPathSupport.Item.class, (boolean)true));
    }

    public static boolean canEdit(ListSelectionModel selectionModel, DefaultListModel listModel) {
        boolean can;
        boolean bl = can = selectionModel.getMinSelectionIndex() == selectionModel.getMaxSelectionIndex() && selectionModel.getMinSelectionIndex() != -1;
        if (can) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.get(selectionModel.getMinSelectionIndex());
            can = item.canEdit();
        }
        return can;
    }

    public static void edit(DefaultListModel listModel, int[] selectedIndices, AntProjectHelper helper) {
        ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.getElementAt(selectedIndices[0]);
        if (item.getType() == 0) {
            EditJarSupport.Item eji = new EditJarSupport.Item();
            eji.setJarFile(item.getVariableBasedProperty() != null ? item.getVariableBasedProperty() : item.getFilePath());
            eji.setSourceFile(item.getSourceFilePath());
            eji.setJavadocFile(item.getJavadocFilePath());
            eji = EditJarSupport.showEditDialog((AntProjectHelper)helper, (EditJarSupport.Item)eji);
            if (eji != null) {
                item.setJavadocFilePath(eji.getJavadocFile());
                item.setSourceFilePath(eji.getSourceFile());
            }
        }
        if (item.getType() == 1 && item.getLibrary() != null) {
            LibrariesCustomizer.showSingleLibraryCustomizer((Library)item.getLibrary());
        }
    }

    public static int[] moveUp(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveUp button should be disabled";
        for (i = 0; i < indices.length; ++i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] - 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        return indices;
    }

    public static boolean canMoveUp(ListSelectionModel selectionModel) {
        return selectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveDown button should be disabled";
        for (i = indices.length - 1; i >= 0; --i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] + 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    public static boolean canMoveDown(ListSelectionModel selectionModel, int modelSize) {
        int iMax = selectionModel.getMaxSelectionIndex();
        return iMax != -1 && iMax < modelSize - 1;
    }

    public static int[] remove(DefaultListModel listModel, int[] indices) {
        if (indices == null || indices.length == 0) assert (false) : "Remove button should be disabled";
        for (int i = indices.length - 1; i >= 0; --i) {
            listModel.remove(indices[i]);
        }
        if (!listModel.isEmpty()) {
            int selectedIndex = indices[indices.length - 1] - indices.length + 1;
            if (selectedIndex > listModel.size() - 1) {
                selectedIndex = listModel.size() - 1;
            }
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public static int[] addLibraries(DefaultListModel listModel, int[] indices, Library[] libraries, Set<Library> alreadyIncludedLibs, Callback callback) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int j = 1;
        for (int i = 0; i < libraries.length; ++i) {
            if (alreadyIncludedLibs.contains(libraries[i])) continue;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(libraries[i], null);
            if (callback != null) {
                callback.initItem(item);
            }
            listModel.add(lastIndex + j++, item);
        }
        HashSet<Library> addedLibs = new HashSet<Library>(Arrays.asList(libraries));
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.get(i);
            if (item.getType() != 1 || item.isBroken() || !addedLibs.contains(item.getLibrary())) continue;
            indexes.add(i);
        }
        int[] indexesArray = new int[indexes.size()];
        int j2 = 0;
        for (Integer val : indexes) {
            indexesArray[j2++] = val;
        }
        return indexesArray;
    }

    public static int[] addJarFiles(DefaultListModel listModel, int[] indices, String[] filePaths, File base, String[] variables, Callback callback) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[filePaths.length];
        int i = 0;
        int delta = 0;
        while (i + delta < filePaths.length) {
            int current = lastIndex + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(filePaths[i], base, null, variables != null ? variables[i] : null);
            if (callback != null) {
                callback.initItem(item);
            }
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[delta + i] = current;
                ++i;
                continue;
            }
            indexes[i + delta] = listModel.indexOf(item);
            ++delta;
        }
        return indexes;
    }

    public static int[] addArtifacts(DefaultListModel listModel, int[] indices, AntArtifactItem[] artifactItems, Callback callback) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[artifactItems.length];
        for (int i = 0; i < artifactItems.length; ++i) {
            int current = lastIndex + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null);
            if (callback != null) {
                callback.initItem(item);
            }
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[i] = current;
                continue;
            }
            indexes[i] = listModel.indexOf(item);
        }
        return indexes;
    }

    public static interface Callback {
        public void initItem(ClassPathSupport.Item var1);
    }
}

