/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.util;

import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.openide.filesystems.FileObject;

public final class CommonProjectUtils {
    private CommonProjectUtils() {
    }

    public static JavaPlatform getActivePlatform(String activePlatformId) {
        JavaPlatform[] installedPlatforms;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            return pm.getDefaultPlatform();
        }
        for (JavaPlatform javaPlatform : installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null))) {
            String antName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return javaPlatform;
        }
        return null;
    }

    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public static Collection<ElementHandle<TypeElement>> getMainMethods(FileObject fo) {
        if (fo == null || MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return Collections.emptySet();
        }
        return SourceUtils.getMainClasses((FileObject)fo);
    }

    public static boolean hasMainMethod(FileObject fo) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fo == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fo).isEmpty();
    }

    public static boolean isMainClass(String className, ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)sourcePath);
        return SourceUtils.isMainClass((String)className, (ClasspathInfo)cpInfo);
    }
}

