/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter.libinstaller;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.pluginimporter.libinstaller.JUnitLibraryInstaller;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbPreferences;

public class InstallLibraryTask
implements Runnable {
    private static final String KEY = "tried.to.download.junit";
    private static final String JUNIT_APPROVED = "junit_accepted";
    private static final String JUNIT_DENIED = "junit_denied";
    private static final Logger LOG = Logger.getLogger(InstallLibraryTask.class.getName());

    @Override
    public void run() {
        Preferences p = NbPreferences.forModule(InstallLibraryTask.class);
        if (p.getBoolean(KEY, false)) {
            return;
        }
        p.putBoolean(KEY, true);
        File licenseAcceptedFile = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
        if (licenseAcceptedFile == null) {
            LOG.info("$userdir/var/license_accepted not found => skipping install JUnit.");
            return;
        }
        try {
            String content = FileUtil.toFileObject((File)licenseAcceptedFile).asText();
            LOG.fine("Content of $userdir/var/license_accepted: " + content);
            if (content != null && content.indexOf(JUNIT_APPROVED) != -1) {
                LOG.fine(" IDE license accepted, JUnit accpeted => let's install silently");
                JUnitLibraryInstaller.install(true);
            } else if (content != null && content.indexOf(JUNIT_DENIED) != -1) {
                LOG.fine("IDE license accepted but JUnit disapproved => do nothing");
            } else {
                LOG.fine("IDE license accepted, JUnit N/A => use prompt & wizard way");
                JUnitLibraryInstaller.install(false);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "while reading " + licenseAcceptedFile, ex);
        }
    }
}

