/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.NbBundle;

public class ValidatorsPanel
extends JPanel {
    private WSDLComponent comp;
    private Project p;
    private boolean inSync = false;
    private JButton certificateValidatorButton;
    private JLabel certificateValidatorLabel;
    private JTextField certificateValidatorTextField;
    private JToggleButton jToggleButton1;
    private JButton timestampValidatorButton;
    private JLabel timestampValidatorLabel;
    private JTextField timestampValidatorTextField;

    public ValidatorsPanel(WSDLComponent comp, Project p) {
        this.comp = comp;
        this.p = p;
        this.initComponents();
        this.timestampValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.timestampValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getValidator(String type) {
        if ("timestampValidator".equals(type)) {
            return this.timestampValidatorTextField.getText();
        }
        if ("certificateValidator".equals(type)) {
            return this.certificateValidatorTextField.getText();
        }
        return null;
    }

    private void setValidator(String type, String validator) {
        if ("timestampValidator".equals(type)) {
            this.timestampValidatorTextField.setText(validator);
        }
        if ("certificateValidator".equals(type)) {
            this.certificateValidatorTextField.setText(validator);
        }
    }

    private void sync() {
        String certificateValidator;
        this.inSync = true;
        String timestampValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "timestampValidator");
        if (timestampValidator != null) {
            this.setValidator("timestampValidator", timestampValidator);
        }
        if ((certificateValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "certificateValidator")) != null) {
            this.setValidator("certificateValidator", certificateValidator);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        boolean certRequired = true;
        boolean timeRequired = true;
        this.timestampValidatorButton.setEnabled(timeRequired);
        this.timestampValidatorLabel.setEnabled(timeRequired);
        this.timestampValidatorTextField.setEnabled(timeRequired);
        this.certificateValidatorButton.setEnabled(certRequired);
        this.certificateValidatorLabel.setEnabled(certRequired);
        this.certificateValidatorTextField.setEnabled(certRequired);
    }

    public void storeState() {
        String certV = this.getValidator("certificateValidator");
        if (certV == null || certV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", certV, true);
        }
        String timeV = this.getValidator("timestampValidator");
        if (timeV == null || timeV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", timeV, true);
        }
    }

    private void initComponents() {
        this.jToggleButton1 = new JToggleButton();
        this.timestampValidatorLabel = new JLabel();
        this.certificateValidatorLabel = new JLabel();
        this.timestampValidatorTextField = new JTextField();
        this.certificateValidatorTextField = new JTextField();
        this.timestampValidatorButton = new JButton();
        this.certificateValidatorButton = new JButton();
        this.jToggleButton1.setText("jToggleButton1");
        this.timestampValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_TimestampVLabel"));
        this.certificateValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_CertificateVLabel"));
        this.timestampValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.timestampValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.timestampValidatorButtonActionPerformed(evt);
            }
        });
        this.certificateValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.certificateValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.certificateValidatorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.timestampValidatorLabel).add((Component)this.certificateValidatorLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.certificateValidatorTextField, -2, 305, -2).add((Component)this.timestampValidatorTextField, -2, 308, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.certificateValidatorButton).add((Component)this.timestampValidatorButton)).add(3, 3, 3).add((Component)this.jToggleButton1, -2, 0, -2)));
        layout.linkSize(new Component[]{this.certificateValidatorTextField, this.timestampValidatorTextField}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(69, 69, 69).add((Component)this.jToggleButton1)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timestampValidatorLabel).add((Component)this.timestampValidatorButton).add((Component)this.timestampValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.certificateValidatorLabel).add((Component)this.certificateValidatorButton).add((Component)this.certificateValidatorTextField, -2, -1, -2)).addContainerGap()));
    }

    private void certificateValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.CertificateValidationCallback.CertificateValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("certificateValidator", selectedClass);
            }
        }
    }

    private void timestampValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.TimestampValidationCallback.TimestampValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("timestampValidator", selectedClass);
            }
        }
    }
}

