/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.EventObject;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;

abstract class LayoutEvent
extends EventObject {
    static final int COMPONENT_ADDED = 1;
    static final int COMPONENT_REMOVED = 2;
    static final int LAYOUT_ROOTS_ADDED = 14;
    static final int LAYOUT_ROOTS_REMOVED = 15;
    static final int LAYOUT_ROOTS_CHANGED = 16;
    static final int INTERVAL_ADDED = 3;
    static final int INTERVAL_REMOVED = 4;
    static final int INTERVAL_ALIGNMENT_CHANGED = 5;
    static final int GROUP_ALIGNMENT_CHANGED = 6;
    static final int INTERVAL_SIZE_CHANGED = 7;
    static final int INTERVAL_PADDING_TYPE_CHANGED = 13;
    static final int INTERVAL_ATTRIBUTES_CHANGED = 8;
    static final int INTERVAL_LINKSIZE_CHANGED = 9;
    static final int CONTAINER_ATTR_CHANGED = 10;
    static final int COMPONENT_REGISTERED = 11;
    static final int COMPONENT_UNREGISTERED = 12;
    private int changeType;

    LayoutEvent(LayoutModel source, int changeType) {
        super(source);
        this.changeType = changeType;
    }

    LayoutModel getModel() {
        return (LayoutModel)this.source;
    }

    int getType() {
        return this.changeType;
    }

    abstract void undo();

    abstract void redo();

    static class Component
    extends LayoutEvent {
        private LayoutComponent component;
        private LayoutComponent parentComp;
        private int index;
        private List<LayoutInterval[]> oldLayoutRoots;
        private List<LayoutInterval[]> newLayoutRoots;
        private LayoutInterval[] layoutRoots;
        private int oldLinkSizeId;
        private int newLinkSizeId;
        private int dimension;

        Component(LayoutModel source, int changeType) {
            super(source, changeType);
        }

        void setComponent(LayoutComponent comp) {
            this.component = comp;
        }

        void setComponent(LayoutComponent comp, LayoutComponent parent, int index) {
            this.component = comp;
            this.parentComp = parent;
            this.index = index;
        }

        void setContainer(LayoutComponent comp, List<LayoutInterval[]> rootsList) {
            this.component = comp;
            this.newLayoutRoots = rootsList;
        }

        void setLayoutRoots(LayoutComponent container, LayoutInterval[] roots, int index) {
            this.component = container;
            this.layoutRoots = roots;
            this.index = index;
        }

        void setLayoutRoots(LayoutComponent container, List<LayoutInterval[]> oldRoots, List<LayoutInterval[]> newRoots) {
            this.component = container;
            this.oldLayoutRoots = oldRoots;
            this.newLayoutRoots = newRoots;
        }

        void setLinkSizeGroup(LayoutComponent component, int oldLinkSizeId, int newLinkSizeId, int dimension) {
            this.component = component;
            this.oldLinkSizeId = oldLinkSizeId;
            this.newLinkSizeId = newLinkSizeId;
            this.dimension = dimension;
        }

        @Override
        void undo() {
            switch (this.getType()) {
                case 1: {
                    this.undoComponentAddition();
                    break;
                }
                case 2: {
                    this.undoComponentRemoval();
                    break;
                }
                case 14: {
                    this.undoRootsAddition();
                    break;
                }
                case 15: {
                    this.undoRootsRemoval();
                    break;
                }
                case 16: {
                    this.component.setLayoutRoots(this.oldLayoutRoots);
                    break;
                }
                case 9: {
                    this.undoLinkSize(this.oldLinkSizeId);
                    break;
                }
                case 10: {
                    this.changeContainerAttr();
                    break;
                }
                case 11: {
                    this.undoComponentRegistration();
                    break;
                }
                case 12: {
                    this.undoComponentUnregistration();
                }
            }
        }

        @Override
        void redo() {
            switch (this.getType()) {
                case 1: {
                    this.undoComponentRemoval();
                    break;
                }
                case 2: {
                    this.undoComponentAddition();
                    break;
                }
                case 14: {
                    this.undoRootsRemoval();
                    break;
                }
                case 15: {
                    this.undoRootsAddition();
                    break;
                }
                case 16: {
                    this.component.setLayoutRoots(this.newLayoutRoots);
                    break;
                }
                case 9: {
                    this.undoLinkSize(this.newLinkSizeId);
                    break;
                }
                case 10: {
                    this.changeContainerAttr();
                    break;
                }
                case 11: {
                    this.undoComponentUnregistration();
                    break;
                }
                case 12: {
                    this.undoComponentRegistration();
                }
            }
        }

        private void undoLinkSize(int id) {
            this.getModel().removeComponentFromLinkSizedGroup(this.component, this.dimension);
            if (id != -1) {
                this.getModel().addComponentToLinkSizedGroupImpl(id, this.component.getId(), this.dimension);
            }
        }

        private void undoComponentAddition() {
            this.getModel().removeComponentImpl(this.component);
        }

        private void undoComponentRemoval() {
            this.getModel().addComponentImpl(this.component, this.parentComp, this.index);
        }

        private void undoRootsAddition() {
            this.component.removeLayoutRoots(this.layoutRoots);
        }

        private void undoRootsRemoval() {
            this.component.addLayoutRoots(this.layoutRoots, this.index);
        }

        private void changeContainerAttr() {
            this.component.setLayoutContainer(!this.component.isLayoutContainer(), this.newLayoutRoots);
        }

        private void undoComponentRegistration() {
            this.getModel().unregisterComponentImpl(this.component);
        }

        private void undoComponentUnregistration() {
            this.getModel().registerComponentImpl(this.component);
        }
    }

    static class Interval
    extends LayoutEvent {
        private LayoutInterval interval;
        private LayoutInterval parentInt;
        private int index;
        private int oldAlignment;
        private int newAlignment;
        private int oldAttributes;
        private int newAttributes;
        private int[] oldSizes;
        private int[] newSizes;
        private LayoutConstants.PaddingType oldPaddingType;
        private LayoutConstants.PaddingType newPaddingType;

        Interval(LayoutModel source, int changeType) {
            super(source, changeType);
        }

        void setInterval(LayoutInterval interval, LayoutInterval parent, int index) {
            this.interval = interval;
            this.parentInt = parent;
            this.index = index;
        }

        void setAlignment(LayoutInterval interval, int oldAlign, int newAlign) {
            this.interval = interval;
            this.oldAlignment = oldAlign;
            this.newAlignment = newAlign;
        }

        void setAttributes(LayoutInterval interval, int oldAttributes, int newAttributes) {
            this.interval = interval;
            this.oldAttributes = oldAttributes;
            this.newAttributes = newAttributes;
        }

        void setSize(LayoutInterval interval, int oldMin, int oldPref, int oldMax, int newMin, int newPref, int newMax) {
            this.interval = interval;
            this.oldSizes = new int[]{oldMin, oldPref, oldMax};
            this.newSizes = new int[]{newMin, newPref, newMax};
        }

        void setPaddingType(LayoutInterval interval, LayoutConstants.PaddingType oldPadding, LayoutConstants.PaddingType newPadding) {
            this.interval = interval;
            this.oldPaddingType = oldPadding;
            this.newPaddingType = newPadding;
        }

        LayoutInterval getInterval() {
            return this.interval;
        }

        LayoutInterval getParentInterval() {
            return this.parentInt;
        }

        int getIndex() {
            return this.index;
        }

        @Override
        void undo() {
            switch (this.getType()) {
                case 3: {
                    this.undoIntervalAddition();
                    break;
                }
                case 4: {
                    this.undoIntervalRemoval();
                    break;
                }
                case 5: {
                    this.interval.setAlignment(this.oldAlignment);
                    break;
                }
                case 6: {
                    this.interval.setGroupAlignment(this.oldAlignment);
                    break;
                }
                case 7: {
                    this.interval.setSizes(this.oldSizes[0], this.oldSizes[1], this.oldSizes[2]);
                    break;
                }
                case 13: {
                    this.interval.setPaddingType(this.oldPaddingType);
                    break;
                }
                case 8: {
                    this.interval.setAttributes(this.oldAttributes);
                }
            }
        }

        @Override
        void redo() {
            switch (this.getType()) {
                case 3: {
                    this.undoIntervalRemoval();
                    break;
                }
                case 4: {
                    this.undoIntervalAddition();
                    break;
                }
                case 5: {
                    this.interval.setAlignment(this.newAlignment);
                    break;
                }
                case 6: {
                    this.interval.setGroupAlignment(this.newAlignment);
                    break;
                }
                case 7: {
                    this.interval.setSizes(this.newSizes[0], this.newSizes[1], this.newSizes[2]);
                    break;
                }
                case 13: {
                    this.interval.setPaddingType(this.newPaddingType);
                    break;
                }
                case 8: {
                    this.interval.setAttributes(this.newAttributes);
                }
            }
        }

        private void undoIntervalAddition() {
            this.getModel().removeInterval(this.parentInt, this.index);
        }

        private void undoIntervalRemoval() {
            this.getModel().addInterval(this.interval, this.parentInt, this.index);
        }
    }
}

