/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownPanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DrillDownWindow
extends TopComponent {
    private static final String DRILLDOWN_CAPTION = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"DrillDownWindow_DrillDownCaption");
    private static final String DRILLDOWN_ACCESS_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"DrillDownWindow_DrillDownAccessDescr");
    private static final String HELP_CTX_KEY = "DrillDownWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("DrillDownWindow.HelpCtx");
    private static final String PREFERRED_ID = "DrillDownWindow";
    private static final Image pieIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/pie.png");
    private static DrillDownWindow defaultInstance;
    private AbstractButton presenter;
    private DrillDownPanel ddPanel;

    public DrillDownWindow() {
        this.setName(DRILLDOWN_CAPTION);
        this.getAccessibleContext().setAccessibleDescription(DRILLDOWN_ACCESS_DESCR);
        this.setIcon(pieIcon);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.presenter = this.createPresenter();
        this.updatePresenter();
        this.setLayout(new BorderLayout());
    }

    public static synchronized DrillDownWindow getDefault() {
        if (defaultInstance == null) {
            IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

                @Override
                public void run() {
                    TopComponent tc = WindowManager.getDefault().findTopComponent(DrillDownWindow.PREFERRED_ID);
                    if (tc != null && tc instanceof DrillDownWindow) {
                        defaultInstance = (DrillDownWindow)tc;
                    } else {
                        defaultInstance = new DrillDownWindow();
                    }
                }
            });
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public AbstractButton getPresenter() {
        return this.presenter;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public void setDrillDown(DrillDown drillDown, List statModules) {
        if (this.ddPanel != null) {
            this.remove((Component)((Object)this.ddPanel));
        }
        if (!drillDown.isValid()) {
            this.revalidate();
            this.repaint();
            return;
        }
        this.ddPanel = new DrillDownPanel(drillDown);
        this.ddPanel.pause();
        this.add((Component)((Object)this.ddPanel), "Center");
        if (statModules != null) {
            for (StatisticalModule module : statModules) {
                this.ddPanel.addSnippet(module);
            }
        }
        this.ddPanel.resume();
        this.revalidate();
        this.repaint();
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode("commonpalette")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.updatePresenter();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.updatePresenter();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private AbstractButton createPresenter() {
        JToggleButton button = new JToggleButton();
        if (this.getIcon() == null) {
            button.setText(this.getName());
            button.setToolTipText(this.getName());
        } else {
            button.setIcon(new ImageIcon(this.getIcon()));
            button.setToolTipText(this.getName());
        }
        Insets buttonMargin = button.getMargin();
        button.setMargin(new Insets(buttonMargin.top, buttonMargin.top + 10, buttonMargin.bottom, buttonMargin.top + 10));
        return button;
    }

    private void updatePresenter() {
        this.presenter.setSelected(this.isOpened());
    }
}

