/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddRootMethodAction
extends NodeAction {
    public AddRootMethodAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(AddRootMethodAction.class, (String)"LBL_AddRootMethodAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return true;
    }

    protected void performAction(final Node[] nodes) {
        new NBSwingWorker(){

            protected void doInBackground() {
                try {
                    DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
                    if (dobj == null) {
                        return;
                    }
                    int currentOffsetInEditor = SourceUtils.getCurrentOffsetInEditor();
                    if (currentOffsetInEditor == -1) {
                        return;
                    }
                    SourceUtils.ResolvedMethod resolvedMethod = SourceUtils.resolveMethodAtPosition((FileObject)dobj.getPrimaryFile(), (int)currentOffsetInEditor);
                    if (resolvedMethod == null) {
                        NetBeansProfiler.getDefaultNB().displayWarning(NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_NoMethodFoundAtPosition"));
                        return;
                    }
                    ExecutableElement method = resolvedMethod.getMethod();
                    if (method == null) {
                        return;
                    }
                    if (!SourceUtils.isExecutableMethod((ExecutableElement)method)) {
                        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_CannotAddAbstractNativeProfilingRoot"), 1));
                        return;
                    }
                    Project project = FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
                    ProfilingSettings[] projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
                    ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!Utils.isCPUSettings(settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    ProfilingSettings settings = IDEUtils.selectSettings(project, 16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
                    if (settings == null) {
                        return;
                    }
                    settings.addRootMethod(resolvedMethod.getVMClassName(), resolvedMethod.getVMMethodName(), resolvedMethod.getVMMethodSignature());
                    if (cpuSettings.contains(settings)) {
                        ProfilingSettingsManager.getDefault().storeProfilingSettings(projectSettings, settings, project);
                    } else {
                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                        newProjectSettings[projectSettings.length] = settings;
                        ProfilingSettingsManager.getDefault().storeProfilingSettings(newProjectSettings, settings, project);
                    }
                }
                catch (Exception ex) {
                    ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_ProblemAddingRootMethod"), 2));
                }
            }
        }.execute();
    }
}

