/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilingSupport.class, (String)"CAPTION_Question");
    private static final String STOP_START_PROFILE_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartProfileSessionMessage");
    private static final String STOP_START_ATTACH_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartAttachSessionMessage");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_FailedLoadSettingsMsg");
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public static boolean checkProfilingInProgress() {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)STOP_START_PROFILE_SESSION_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return true;
                }
                Profiler.getDefault().stopApp();
            } else {
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)STOP_START_ATTACH_SESSION_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return true;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return false;
    }

    public AttachSTPData selectTaskForAttach(Project project, SessionSettings sessionSettings) {
        SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectAttachProfilerTask(project);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Project project, SessionSettings sessionSettings, FileObject profiledFile, boolean enableOverride) {
        SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectProfileProjectTask(project, profiledFile, enableOverride);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    void setProfilingActionInvoked(boolean pai) {
        this.profilingActionInvoked = pai;
    }

    boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    Project project = null;
                    GlobalProfilingSettings gps = Profiler.getDefault().getGlobalProfilingSettings();
                    SessionSettings ss = new SessionSettings();
                    ss.setPortNo(gps.getPortNo());
                    ProjectTypeProfiler ptp = null;
                    if (project != null) {
                        ptp = ProjectUtilities.getProjectTypeProfiler(project);
                    }
                    if (ptp != null) {
                        ptp.setupProjectSessionSettings(project, ss);
                    }
                    boolean settingsAccepted = false;
                    ProfilingSettings ps = null;
                    while (!settingsAccepted) {
                        AttachSTPData asd = ProfilingSupport.this.selectTaskForAttach(project, ss);
                        if (asd == null) {
                            return;
                        }
                        project = asd.getProject();
                        ps = asd.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + project));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + ps));
                        settingsAccepted = true;
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(project, null);
                    AttachSettings as = null;
                    try {
                        as = NetBeansProfiler.loadAttachSettings(project);
                    }
                    catch (IOException e) {
                        Profiler.getDefault().displayWarning(MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, e.getMessage()));
                        ProfilerLogger.log((Exception)e);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + as));
                    if (as == null) {
                        as = AttachWizard.getDefault().configure(as);
                        if (as == null) {
                            return;
                        }
                        NetBeansProfiler.saveAttachSettings(project, as);
                    }
                    if (!as.isRemote() && as.isDynamic16()) {
                        int pid = PIDSelectPanel.selectPID();
                        if (pid == -1) {
                            return;
                        }
                        as.setPid(pid);
                    }
                    Profiler.getDefault().attachToApp(ps, as);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TargetAppRunner.getDefault().getAppStatusHandler().pauseLiveUpdates();
                    boolean attach = Profiler.getDefault().getProfilingMode() == 0;
                    SelectProfilingTask.Configuration configuration = SelectProfilingTask.selectModifyProfilingTask(NetBeansProfiler.getDefaultNB().getProfiledProject(), NetBeansProfiler.getDefaultNB().getProfiledSingleFile(), Profiler.getDefault().getProfilingMode() == 0);
                    if (configuration == null) {
                        return;
                    }
                    Profiler.getDefault().modifyCurrentProfiling(configuration.getProfilingSettings());
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    TargetAppRunner.getDefault().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Project p;

        private AttachSTPData(ProfilingSettings ps, Project p) {
            this.ps = ps;
            this.p = p;
        }

        public Project getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

