/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;

public class ObjectFieldNode
extends ObjectNode
implements HeapWalkerFieldNode {
    private ObjectFieldValue fieldValue;

    public ObjectFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent) {
        this(fieldValue, parent, parent == null ? 1 : parent.getMode());
    }

    public ObjectFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent, int mode) {
        super(mode == 1 ? fieldValue.getInstance() : fieldValue.getDefiningInstance(), fieldValue.getField().getName(), parent, mode);
        this.fieldValue = fieldValue;
        if (!this.isLoop() && this.getMode() == 2 && this.isStatic()) {
            this.loopTo = this.computeClassLoopTo();
        }
    }

    public ObjectFieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_INSTANCE;
        if (this.isStatic()) {
            icon = BrowserUtils.createStaticIcon(icon);
        }
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            icon = BrowserUtils.createGCRootIcon(icon);
        }
        return this.processLoopIcon(icon);
    }

    @Override
    protected String computeType() {
        if (this.getMode() == 2 && this.isStatic()) {
            return this.fieldValue.getField().getDeclaringClass().getName();
        }
        return super.computeType();
    }

    @Override
    protected String computeValue() {
        if (this.getMode() == 2 && this.isStatic()) {
            return "class " + BrowserUtils.getSimpleType(this.fieldValue.getField().getDeclaringClass().getName());
        }
        return super.computeValue();
    }

    private HeapWalkerNode computeClassLoopTo() {
        JavaClass declaringClass = this.fieldValue.getField().getDeclaringClass();
        for (HeapWalkerNode parent = this.getParent(); parent != null && parent instanceof HeapWalkerInstanceNode; parent = parent.getParent()) {
            HeapWalkerFieldNode parentF;
            if (!(parent instanceof HeapWalkerFieldNode) || !(parentF = (HeapWalkerFieldNode)parent).isStatic() || !parentF.getFieldValue().getField().getDeclaringClass().equals(declaringClass)) continue;
            return parent;
        }
        return null;
    }
}

