/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class Utils {
    private static final String FULL_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_FullDateFormat");
    private static final String FULL_DATE_FORMAT_HIRES = NbBundle.getMessage(Utils.class, (String)"Utils_FullDateFormatHiRes");
    private static final String TODAY_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_TodayDateFormat");
    private static final String TODAY_DATE_FORMAT_HIRES = NbBundle.getMessage(Utils.class, (String)"Utils_TodayDateFormatHiRes");
    private static final String DAY_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_DayDateFormat");
    private static final String CANNOT_OPEN_SOURCE_MSG = NbBundle.getMessage(Utils.class, (String)"Utils_CannotOpenSourceMsg");
    private static final String INVALID_PP_LOCATION_MSG = NbBundle.getMessage(Utils.class, (String)"Utils_InvalidPPLocationMsg");
    private static final String PROJECT_DIRECTORY_MARK = "{$projectDirectory}";
    public static final ImageIcon EMPTY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/empty16.gif", (boolean)false);
    private static final ProjectPresenterRenderer projectRenderer = new ProjectPresenterRenderer();
    private static final ProjectPresenterListRenderer projectListRenderer = new ProjectPresenterListRenderer();
    private static final EnhancedTableCellRenderer scopeRenderer = new ProfilingPointScopeRenderer();
    private static final ProfilingPointPresenterRenderer presenterRenderer = new ProfilingPointPresenterRenderer();
    private static final ProfilingPointPresenterListRenderer presenterListRenderer = new ProfilingPointPresenterListRenderer();
    private static final SimpleDateFormat fullDateFormat = new SimpleDateFormat(FULL_DATE_FORMAT);
    private static final SimpleDateFormat fullDateFormatHiRes = new SimpleDateFormat(FULL_DATE_FORMAT_HIRES);
    private static final SimpleDateFormat todayDateFormat = new SimpleDateFormat(TODAY_DATE_FORMAT);
    private static final SimpleDateFormat todayDateFormatHiRes = new SimpleDateFormat(TODAY_DATE_FORMAT_HIRES);
    private static final SimpleDateFormat dayDateFormat = new SimpleDateFormat(DAY_DATE_FORMAT);

    public static String getAbsolutePath(Project project, String sourceFileRelativePath) {
        if (project == null) {
            File file = new File(sourceFileRelativePath);
            return file.exists() ? sourceFileRelativePath : null;
        }
        return new File(sourceFileRelativePath.replace(PROJECT_DIRECTORY_MARK, FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath())).getAbsolutePath();
    }

    public static String getClassName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            return null;
        }
        return SourceUtils.getEnclosingClassName((FileObject)fileObject, (int)documentOffset);
    }

    public static String getMethodName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            return null;
        }
        return SourceUtils.getEnclosingMethodName((FileObject)fileObject, (int)documentOffset);
    }

    public static CodeProfilingPoint.Location getCurrentLocation(int lineOffset) {
        JavaEditorContext mostActiveContext = Utils.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        File currentFile = FileUtil.toFile((FileObject)mostActiveJavaSource);
        if (currentFile == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = currentFile.getAbsolutePath();
        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)mostActiveContext.getDocument()), (int)mostActiveContext.getTextComponent().getCaret().getDot()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static Project getCurrentProject() {
        Project currentProject = Utils.getMostActiveJavaProject();
        if (currentProject == null) {
            currentProject = ProjectUtilities.getMainProject();
        }
        return currentProject;
    }

    public static CodeProfilingPoint.Location getCurrentSelectionEndLocation(int lineOffset) {
        JavaEditorContext mostActiveContext = Utils.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = FileUtil.toFile((FileObject)mostActiveJavaSource).getAbsolutePath();
        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)mostActiveContext.getDocument()), (int)mostActiveTextComponent.getSelectionEnd()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static CodeProfilingPoint.Location[] getCurrentSelectionLocations() {
        int endLineNumber;
        JavaEditorContext mostActiveContext = Utils.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return new CodeProfilingPoint.Location[0];
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return new CodeProfilingPoint.Location[0];
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return new CodeProfilingPoint.Location[0];
        }
        File file = FileUtil.toFile((FileObject)mostActiveJavaSource);
        if (file == null) {
            return new CodeProfilingPoint.Location[0];
        }
        String fileName = file.getAbsolutePath();
        int startLineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)mostActiveContext.getDocument()), (int)mostActiveTextComponent.getSelectionStart()) + 1;
        if (startLineNumber == -1) {
            startLineNumber = 1;
        }
        if ((endLineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)mostActiveContext.getDocument()), (int)mostActiveTextComponent.getSelectionEnd()) + 1) == -1) {
            endLineNumber = 1;
        }
        return new CodeProfilingPoint.Location[]{new CodeProfilingPoint.Location(fileName, startLineNumber, Integer.MIN_VALUE), new CodeProfilingPoint.Location(fileName, endLineNumber, Integer.MAX_VALUE)};
    }

    public static CodeProfilingPoint.Location getCurrentSelectionStartLocation(int lineOffset) {
        JavaEditorContext mostActiveContext = Utils.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = FileUtil.toFile((FileObject)mostActiveJavaSource).getAbsolutePath();
        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)mostActiveContext.getDocument()), (int)mostActiveTextComponent.getSelectionStart()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static int getDocumentOffset(CodeProfilingPoint.Location location) {
        int lineOffset;
        int linePosition;
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return -1;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (dataObject == null) {
            return -1;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return -1;
        }
        StyledDocument document = null;
        try {
            document = editorCookie.openDocument();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (document == null) {
            return -1;
        }
        try {
            linePosition = NbDocument.findLineOffset((StyledDocument)document, (int)(location.getLine() - 1));
            lineOffset = location.isLineStart() ? 0 : (location.isLineEnd() ? NbDocument.findLineOffset((StyledDocument)document, (int)location.getLine()) - linePosition - 1 : location.getOffset());
        }
        catch (Exception e) {
            return -1;
        }
        return linePosition + lineOffset;
    }

    public static double getDurationInMicroSec(long startTimestamp, long endTimestamp) {
        ProfilingSessionStatus session = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        double countsInMicroSec = (double)session.timerCountsInSecond[0] / 1000000.0;
        return (double)(endTimestamp - startTimestamp) / countsInMicroSec;
    }

    public static Line getEditorLine(CodeProfilingPoint.Location location) {
        String url = location.getFile();
        FileObject file = null;
        try {
            file = URLMapper.findFileObject((URL)new File(url).toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (file == null) {
            return null;
        }
        DataObject dao = null;
        try {
            dao = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dao.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        if (lineSet == null) {
            return null;
        }
        try {
            return lineSet.getCurrent(location.getLine() - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidLocation(CodeProfilingPoint.Location location) {
        CodeProfilingPoint.Location startLocation;
        String methodName = Utils.getMethodName(location);
        if (methodName == null) {
            return false;
        }
        if (location.isLineStart()) {
            return true;
        }
        if (location.isLineEnd() && methodName.equals(Utils.getMethodName(startLocation = new CodeProfilingPoint.Location(location.getFile(), location.getLine(), Integer.MIN_VALUE)))) {
            return true;
        }
        Line line = Utils.getEditorLine(location);
        if (line == null) {
            return false;
        }
        String lineText = line.getText().trim();
        return !lineText.endsWith("{") || lineText.indexOf("{") != lineText.lastIndexOf("{");
    }

    public static void checkLocation(CodeProfilingPoint.Single ppoint) {
        if (!Utils.isValidLocation(ppoint.getLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, ppoint.getName()));
        }
    }

    public static void checkLocation(CodeProfilingPoint.Paired ppoint) {
        if (!Utils.isValidLocation(ppoint.getStartLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, ppoint.getName()));
        } else if (ppoint.usesEndLocation() && !Utils.isValidLocation(ppoint.getEndLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, ppoint.getName()));
        }
    }

    public static Project getMostActiveJavaProject() {
        JavaEditorContext mostActiveContext = Utils.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return null;
        }
        FileObject mostActiveFileObject = mostActiveContext.getFileObject();
        if (mostActiveFileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)mostActiveFileObject);
    }

    public static ListCellRenderer getPresenterListRenderer() {
        return presenterListRenderer;
    }

    public static EnhancedTableCellRenderer getPresenterRenderer() {
        return presenterRenderer;
    }

    public static CodeProfilingPoint[] getProfilingPointsOnLine(CodeProfilingPoint.Location location) {
        if (location == null || location == CodeProfilingPoint.Location.EMPTY) {
            return new CodeProfilingPoint[0];
        }
        File file = new File(location.getFile());
        int lineNumber = location.getLine();
        ArrayList<CodeProfilingPoint> lineProfilingPoints = new ArrayList<CodeProfilingPoint>();
        List<CodeProfilingPoint> profilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(CodeProfilingPoint.class, null, false);
        block0: for (CodeProfilingPoint profilingPoint : profilingPoints) {
            for (CodeProfilingPoint.Annotation annotation : profilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location loc = profilingPoint.getLocation(annotation);
                if (loc.getLine() != lineNumber || !new File(loc.getFile()).equals(file)) continue;
                lineProfilingPoints.add(profilingPoint);
                continue block0;
            }
        }
        return lineProfilingPoints.toArray(new CodeProfilingPoint[lineProfilingPoints.size()]);
    }

    public static ListCellRenderer getProjectListRenderer() {
        return projectListRenderer;
    }

    public static EnhancedTableCellRenderer getProjectRenderer() {
        return projectRenderer;
    }

    public static String getRelativePath(Project project, String sourceFileAbsolutePath) {
        if (project == null) {
            return sourceFileAbsolutePath;
        }
        String projectDirectoryAbsolutePath = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
        if (!sourceFileAbsolutePath.startsWith(projectDirectoryAbsolutePath)) {
            return sourceFileAbsolutePath;
        }
        File file = FileUtil.normalizeFile((File)new File(sourceFileAbsolutePath));
        return "{$projectDirectory}/" + FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)FileUtil.toFileObject((File)file));
    }

    public static EnhancedTableCellRenderer getScopeRenderer() {
        return scopeRenderer;
    }

    public static String getThreadClassName(int threadID) {
        return null;
    }

    public static String getThreadName(int threadID) {
        return "&lt;unknown thread, id=" + threadID + "&gt;";
    }

    public static long getTimeInMillis(long hiResTimeStamp) {
        ProfilingSessionStatus session = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        long statupInCounts = session.startupTimeInCounts;
        long startupMillis = session.startupTimeMillis;
        long countsInMillis = session.timerCountsInSecond[0] / 1000L;
        return startupMillis + (hiResTimeStamp - statupInCounts) / countsInMillis;
    }

    public static String getUniqueName(String name, String nameSuffix, Project project) {
        List<ProfilingPoint> projectProfilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(project, false, true);
        LinkedList<String> projectProfilingPointsNames = new LinkedList<String>();
        for (ProfilingPoint projectProfilingPoint : projectProfilingPoints) {
            projectProfilingPointsNames.add(projectProfilingPoint.getName());
        }
        int index = 0;
        String indexStr = "";
        while (projectProfilingPointsNames.contains(name + indexStr + nameSuffix)) {
            indexStr = " " + Integer.toString(++index);
        }
        return name + indexStr + nameSuffix;
    }

    public static String formatLocalProfilingPointTime(long timestamp) {
        Date now = new Date();
        Date date = new Date(timestamp);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormat.format(date);
        }
        return fullDateFormat.format(date);
    }

    public static String formatProfilingPointTime(long timestamp) {
        long timestampInMillis = Utils.getTimeInMillis(timestamp);
        Date now = new Date();
        Date date = new Date(timestampInMillis);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormat.format(date);
        }
        return fullDateFormat.format(date);
    }

    public static String formatProfilingPointTimeHiRes(long timestamp) {
        long timestampInMillis = Utils.getTimeInMillis(timestamp);
        Date now = new Date();
        Date date = new Date(timestampInMillis);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormatHiRes.format(date);
        }
        return fullDateFormatHiRes.format(date);
    }

    public static void openLocation(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        final FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        final int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            NetBeansProfiler.getDefaultNB().displayError(CANNOT_OPEN_SOURCE_MSG);
            return;
        }
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                UiUtils.open((FileObject)fileObject, (int)documentOffset);
            }
        });
    }

    private static JavaEditorContext getMostActiveJavaEditorContext() {
        for (JTextComponent component : EditorRegistry.componentList()) {
            Document document = component.getDocument();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) continue;
            return new JavaEditorContext(component, document, fileObject);
        }
        return null;
    }

    private static class ProjectPresenterRenderer
    extends LabelTableCellRenderer {
        private Font font;

        public ProjectPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.font = this.label.getFont();
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProjectPresenterRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            if (value != null && (value instanceof Project || value instanceof ProfilingPoint)) {
                if (table != null) {
                    this.setFont(table.getFont());
                }
                if (value instanceof ProfilingPoint) {
                    this.label.setEnabled(((ProfilingPoint)value).isEnabled());
                    value = ((ProfilingPoint)value).getProject();
                } else {
                    this.label.setEnabled(true);
                }
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.label.setText(pi.getDisplayName());
                this.label.setIcon(table.isEnabled() ? pi.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)pi.getIcon()).getImage())));
                this.label.setFont(ProjectUtilities.getMainProject() == value ? this.font.deriveFont(1) : this.font);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProjectPresenterListRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel rendererOrig = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.renderer.setComponentOrientation(rendererOrig.getComponentOrientation());
            this.renderer.setFontEx(rendererOrig.getFont());
            this.renderer.setOpaque(rendererOrig.isOpaque());
            this.renderer.setForeground(rendererOrig.getForeground());
            this.renderer.setBackground(rendererOrig.getBackground());
            this.renderer.setEnabled(rendererOrig.isEnabled());
            this.renderer.setBorder(rendererOrig.getBorder());
            if (value != null && value instanceof Project) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.renderer.setText(pi.getDisplayName());
                this.renderer.setIcon(pi.getIcon());
                if (ProjectUtilities.getMainProject() == value) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(rendererOrig.getText());
                this.renderer.setIcon(EMPTY_ICON);
            }
            return this.renderer;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static class ProfilingPointScopeRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointScopeRenderer() {
            super(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProfilingPointScopeRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            this.label.setText("");
            if (value instanceof ProfilingPoint) {
                this.label.setIcon(((ProfilingPoint)value).getFactory().getScopeIcon());
                this.label.setEnabled(((ProfilingPoint)value).isEnabled());
            } else if (value instanceof ProfilingPointFactory) {
                this.label.setIcon(((ProfilingPointFactory)value).getScopeIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setIcon(EMPTY_ICON);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 5));
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProfilingPointPresenterRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            if (table != null) {
                this.setFont(table.getFont());
            }
            if (value instanceof ProfilingPoint) {
                this.label.setText(((ProfilingPoint)value).getName());
                this.label.setIcon(((ProfilingPoint)value).getFactory().getIcon());
                this.label.setEnabled(((ProfilingPoint)value).isEnabled());
            } else if (value instanceof ProfilingPointFactory) {
                this.label.setText(((ProfilingPointFactory)value).getType());
                this.label.setIcon(((ProfilingPointFactory)value).getIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterListRenderer
    extends DefaultListCellRenderer {
        private ProfilingPointPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setBorder(BorderFactory.createEmptyBorder(1, 7, 1, 5));
            if (value instanceof ProfilingPoint) {
                renderer.setText(((ProfilingPoint)value).getName());
                renderer.setIcon(((ProfilingPoint)value).getFactory().getIcon());
                renderer.setEnabled(((ProfilingPoint)value).isEnabled());
            } else if (value instanceof ProfilingPointFactory) {
                renderer.setText(((ProfilingPointFactory)value).getType());
                renderer.setIcon(((ProfilingPointFactory)value).getIcon());
                renderer.setEnabled(true);
            } else {
                renderer.setIcon(null);
                renderer.setEnabled(true);
            }
            return renderer;
        }
    }

    private static class JavaEditorContext {
        private Document document;
        private FileObject fileObject;
        private JTextComponent textComponent;

        public JavaEditorContext(JTextComponent textComponent, Document document, FileObject fileObject) {
            this.textComponent = textComponent;
            this.document = document;
            this.fileObject = fileObject;
        }

        public Document getDocument() {
            return this.document;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public JTextComponent getTextComponent() {
            return this.textComponent;
        }
    }
}

