/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.util.HashSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringActionsProvider;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.spi.CsmActionsImplementationProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.ChangeParametersUI;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldUI;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class CsmRefactoringActionsProvider
extends CsmActionsImplementationProvider {
    private static final String CHANGE_PARAMETERS_TRACKING = "CHANGE_PARAMETERS";
    private static final String ENCAPSULATE_FIELDS_TRACKING = "ENCAPSULATE_FIELDS";

    @Override
    public boolean canChangeParameters(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        CsmObject ref = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext editorContext = CsmContext.create(lookup);
            if (editorContext != null) {
                CsmFunction fun = editorContext.getEnclosingFunction();
                return fun != null && !CsmKindUtilities.isDestructor((CsmObject)fun);
            }
            return false;
        }
        return CsmKindUtilities.isFunction((CsmObject)ref);
    }

    @Override
    public void doChangeParameters(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.CHANGE_PARAMETERS_TRACKING, "FROM_EDITOR"});
                return ChangeParametersUI.create(selectedElement, editorContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.CHANGE_PARAMETERS_TRACKING});
                return ChangeParametersUI.create(selectedElement, null);
            }
        };
        task.run();
    }

    @Override
    public boolean canEncapsulateFields(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        CsmObject ref = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext editorContext = CsmContext.create(lookup);
            if (editorContext != null) {
                CsmClass cls = Utilities.extractEnclosingClass(editorContext);
                return cls != null;
            }
            return false;
        }
        return CsmKindUtilities.isField((CsmObject)ref) || CsmKindUtilities.isClass((CsmObject)ref);
    }

    @Override
    public void doEncapsulateFields(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.ENCAPSULATE_FIELDS_TRACKING, "FROM_EDITOR"});
                return EncapsulateFieldUI.create(selectedElement, editorContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.ENCAPSULATE_FIELDS_TRACKING});
                return EncapsulateFieldUI.create(selectedElement, null);
            }
        };
        task.run();
    }
}

