/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.refactoring.elements.DiffElement;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.support.RefactoringCommit;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class CsmRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected volatile boolean cancelRequest = false;

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return this.fastCheckParameters();
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public final void cancelRequest() {
        this.cancelRequest = true;
    }

    protected final boolean isCancelled() {
        return this.cancelRequest;
    }

    protected abstract ModificationResult processFiles(Collection<CsmFile> var1, AtomicReference<Problem> var2);

    private Collection<ModificationResult> processFiles(Iterable<? extends List<CsmFile>> fileGroups, AtomicReference<Problem> outProblem) {
        LinkedList<ModificationResult> results = new LinkedList<ModificationResult>();
        for (List<CsmFile> list : fileGroups) {
            if (this.isCancelled()) {
                return Collections.emptyList();
            }
            ModificationResult modification = this.processFiles((Collection<CsmFile>)list, outProblem);
            if (modification == null) continue;
            results.add(modification);
        }
        return results;
    }

    protected final Problem createAndAddElements(Collection<CsmFile> files, RefactoringElementsBag elements, AbstractRefactoring refactoring) {
        Iterable<? extends List<CsmFile>> fileGroups = this.groupByRoot(files);
        AtomicReference<Object> outProblem = new AtomicReference<Object>(null);
        Collection<ModificationResult> results = this.processFiles(fileGroups, outProblem);
        elements.registerTransaction((Transaction)new RefactoringCommit(results));
        for (ModificationResult result : results) {
            for (FileObject fileObject : result.getModifiedFileObjects()) {
                for (ModificationResult.Difference difference : result.getDifferences(fileObject)) {
                    elements.add(refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, result));
                }
            }
        }
        return outProblem.get();
    }

    protected static final Problem createProblem(Problem prevProblem, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (prevProblem == null) {
            return problem;
        }
        if (isFatal) {
            problem.setNext(prevProblem);
            return problem;
        }
        Problem p = prevProblem;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(problem);
        return prevProblem;
    }

    private Iterable<? extends List<CsmFile>> groupByRoot(Iterable<? extends CsmFile> files) {
        HashMap<CsmProject, LinkedList<CsmFile>> result = new HashMap<CsmProject, LinkedList<CsmFile>>();
        for (CsmFile csmFile : files) {
            CsmProject prj = csmFile.getProject();
            if (prj == null) continue;
            LinkedList<CsmFile> group = (LinkedList<CsmFile>)result.get(prj);
            if (group == null) {
                group = new LinkedList<CsmFile>();
                result.put(prj, group);
            }
            group.add(csmFile);
        }
        return result.values();
    }

    protected Collection<CsmFile> getRelevantFiles(CsmFile startFile, CsmObject referencedObject, AbstractRefactoring refactoring) {
        CsmObject enclScope = referencedObject == null ? null : CsmRefactoringUtils.getEnclosingElement(referencedObject);
        CsmFile scopeFile = null;
        if (enclScope == null && !CsmKindUtilities.isNamespace((Object)referencedObject)) {
            return Collections.emptyList();
        }
        if (CsmKindUtilities.isFunction((CsmObject)enclScope)) {
            scopeFile = ((CsmOffsetable)enclScope).getContainingFile();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)enclScope)) {
            CsmNamespace ns = ((CsmNamespaceDefinition)enclScope).getNamespace();
            if (ns != null && ns.getName().length() == 0 && this.isDeclarationInLeafFile(enclScope)) {
                scopeFile = ((CsmNamespaceDefinition)enclScope).getContainingFile();
            }
        } else if (CsmKindUtilities.isFunction((CsmObject)referencedObject) && CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)referencedObject)) && this.isDeclarationInLeafFile(referencedObject)) {
            scopeFile = ((CsmFunction)referencedObject).getContainingFile();
        }
        if (startFile.equals(scopeFile)) {
            return Collections.singleton(scopeFile);
        }
        CsmProject[] prjs = (CsmProject[])refactoring.getContext().lookup(CsmProject[].class);
        CsmFile declFile = CsmRefactoringUtils.getCsmFile(referencedObject);
        if (prjs == null || prjs.length == 0 || declFile == null) {
            CsmProject prj = startFile.getProject();
            return prj.getAllFiles();
        }
        CsmProject declPrj = declFile.getProject();
        HashSet<CsmProject> relevantPrjs = new HashSet<CsmProject>();
        for (CsmProject csmProject : prjs) {
            if (!csmProject.equals(declPrj) && !csmProject.getLibraries().contains(declPrj)) continue;
            relevantPrjs.add(csmProject);
        }
        HashSet<CsmFile> relevantFiles = new HashSet<CsmFile>();
        for (CsmProject csmProject : relevantPrjs) {
            relevantFiles.addAll(csmProject.getAllFiles());
        }
        return relevantFiles;
    }

    private boolean isDeclarationInLeafFile(CsmObject obj) {
        boolean out = false;
        if (CsmKindUtilities.isOffsetable((Object)obj)) {
            CsmFile file = ((CsmOffsetable)obj).getContainingFile();
            out = CsmIncludeHierarchyResolver.getDefault().getFiles(file).isEmpty();
        }
        return out;
    }

    protected Problem isResovledElement(CsmObject ref) {
        CsmFunction functionDeclaration;
        if (ref == null) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        CsmObject referencedObject = CsmRefactoringUtils.getReferencedElement(ref);
        if (referencedObject == null) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        if (!CsmBaseUtilities.isValid((CsmObject)referencedObject)) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)referencedObject) && (functionDeclaration = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject))) == null) {
            return new Problem(true, NbBundle.getMessage(CsmRefactoringPlugin.class, (String)"DSC_MethodElementWithoutDeclaration"));
        }
        return null;
    }
}

