/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzer;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.openide.util.NbBundle;

public class SyntaxTreeBuilder {
    static final String UNEXPECTED_TAG_KEY = "unexpected_tag";
    static final String UNRESOLVED_TAG_KEY = "unresolved_tag";
    static final String UNKNOWN_TAG_KEY = "unknown_tag";
    static final String UNKNOWN_ATTRIBUTE_KEY = "unknown_attribute";
    static final String FORBIDDEN_END_TAG = "forbidded_endtag";
    static final String UNMATCHED_TAG = "unmatched_tag";
    static final String MISSING_REQUIRED_END_TAG = "missing_required_end_tag";
    public static final String MISSING_REQUIRED_ATTRIBUTES = "missing_required_attribute";
    static final String TAG_CANNOT_BE_EMPTY = "tag_cannot_be_empty";
    static final String UNEXPECTED_SYMBOL_IN_OPEN_TAG = "unexpected_symbol_in_open_tag";
    private static final String ARTIFICIAL_NODE_NAME = "_NO_NAME_PROVIDED_";
    private static final Context context = new Context();

    public static AstNode makeTree(HtmlSource source, HtmlVersion version, List<SyntaxElement> elements) {
        DTD dtd = version.getDTD();
        assert (elements != null);
        assert (dtd != null);
        int lastEndOffset = source.getSourceCode().length();
        AstNode rootNode = AstNode.createRootNode(0, lastEndOffset, dtd);
        LinkedList<AstNode> stack = new LinkedList<AstNode>();
        stack.add(rootNode);
        for (SyntaxElement element : elements) {
            if (element.type() == 4) {
                assert (element instanceof SyntaxElement.Tag);
                SyntaxElement.Tag tagElement = (SyntaxElement.Tag)element;
                String tagName = tagElement.getName();
                AstNode lastNode = (AstNode)stack.getLast();
                DTD.Element currentNodeDtdElement = dtd.getElement(tagName);
                if (currentNodeDtdElement == null) {
                    AstNode unknownTagNode = new AstNode(tagName, AstNode.NodeType.UNKNOWN_TAG, tagElement.offset(), tagElement.offset() + tagElement.length(), tagElement.isEmpty());
                    SyntaxTreeBuilder.copyProblemsFromElementToNode(element, unknownTagNode);
                    if (!SyntaxTreeBuilder.isIgnoredTagName(tagName)) {
                        String errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNKNOWN_TAG", (Object[])new Object[]{tagName});
                        unknownTagNode.addDescriptionToNode(UNKNOWN_TAG_KEY, errorMessage, 1);
                    }
                    lastNode.addChild(unknownTagNode);
                    continue;
                }
                AstNode openTagNode = new AstNode(tagName, AstNode.NodeType.OPEN_TAG, tagElement.offset(), tagElement.offset() + tagElement.length(), currentNodeDtdElement, tagElement.isEmpty(), SyntaxTreeBuilder.stack(stack));
                SyntaxTreeBuilder.copyProblemsFromElementToNode(element, openTagNode);
                if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_ATTRIBUTES_CHECKS.name())) {
                    SyntaxTreeBuilder.checkTagAttributes(openTagNode, tagElement, currentNodeDtdElement);
                }
                SyntaxTreeBuilder.setTagAttributes(openTagNode, tagElement);
                if (lastNode != rootNode && !lastNode.reduce(currentNodeDtdElement)) {
                    if (!lastNode.isResolved()) {
                        if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name())) {
                            String expectedElements = SyntaxTreeBuilder.elementsToString(lastNode.getAllPossibleElements());
                            openTagNode.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNEXPECTED_TAG", (Object[])new Object[]{currentNodeDtdElement.getName(), expectedElements}), 2);
                        }
                    } else {
                        DTD.Element lastDtdElement = dtd.getElement(lastNode.name());
                        assert (lastDtdElement != null);
                        if (!lastDtdElement.hasOptionalEnd()) {
                            if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name())) {
                                List<DTD.Element> possibleElems = lastNode.getAllPossibleElements();
                                if (possibleElems.isEmpty()) {
                                    openTagNode.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNEXPECTED_TAG_NO_EXPECTED_CONTENT", (Object[])new Object[]{currentNodeDtdElement.getName()}), 2);
                                } else {
                                    String expectedElements = SyntaxTreeBuilder.elementsToString(possibleElems);
                                    openTagNode.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNEXPECTED_TAG", (Object[])new Object[]{currentNodeDtdElement.getName(), expectedElements}), 2);
                                }
                            }
                        } else {
                            AstNode node;
                            int i;
                            int reduce_index = -1;
                            for (i = stack.size() - 1; i > 0; --i) {
                                node = stack.get(i);
                                if (!node.reduce(currentNodeDtdElement)) continue;
                                reduce_index = i;
                                break;
                            }
                            if (reduce_index == -1) {
                                stack.remove(lastNode);
                                lastNode.setLogicalEndOffset(openTagNode.startOffset());
                                lastNode = stack.getLast();
                                lastNode.addChild(openTagNode);
                                if (lastNode != rootNode) {
                                    if (SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name())) continue;
                                    openTagNode.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNEXPECTED_TAG_NO_EXPECTED_CONTENT", (Object[])new Object[]{currentNodeDtdElement.getName()}), 2);
                                    continue;
                                }
                                stack.addLast(openTagNode);
                                continue;
                            }
                            for (i = stack.size() - 1; i > reduce_index && SyntaxTreeBuilder.hasOptionalEndTag(node = stack.get(i)); --i) {
                                node.setLogicalEndOffset(openTagNode.startOffset());
                                stack.remove(i);
                            }
                            lastNode = stack.getLast();
                        }
                    }
                }
                if (!tagElement.isEmpty() && !currentNodeDtdElement.isEmpty()) {
                    stack.addLast(openTagNode);
                }
                lastNode.addChild(openTagNode);
                continue;
            }
            if (element.type() == 5) {
                String tagName = ((SyntaxElement.Named)element).getName();
                DTD.Element dtdElement = dtd.getElement(tagName);
                if (dtdElement == null) {
                    AstNode unknownTagNode = new AstNode(tagName, AstNode.NodeType.UNKNOWN_TAG, element.offset(), element.offset() + element.length(), false);
                    SyntaxTreeBuilder.copyProblemsFromElementToNode(element, unknownTagNode);
                    if (!SyntaxTreeBuilder.isIgnoredTagName(tagName)) {
                        String errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNKNOWN_TAG", (Object[])new Object[]{tagName});
                        unknownTagNode.addDescriptionToNode(UNKNOWN_TAG_KEY, errorMessage, 1);
                    }
                    stack.getLast().addChild(unknownTagNode);
                    continue;
                }
                AstNode closeTagNode = new AstNode(tagName, AstNode.NodeType.ENDTAG, element.offset(), element.offset() + element.length(), dtdElement, false, SyntaxTreeBuilder.stack(stack));
                SyntaxTreeBuilder.copyProblemsFromElementToNode(element, closeTagNode);
                int matched_index = -1;
                for (int i = stack.size() - 1; i >= 0; --i) {
                    AstNode node = stack.get(i);
                    if (!tagName.equals(node.name())) continue;
                    if (AstNodeUtils.hasForbiddenEndTag(node)) {
                        closeTagNode.addDescriptionToNode(FORBIDDEN_END_TAG, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_FORBIDDEN_ENDTAG"), 2);
                        continue;
                    }
                    matched_index = i;
                    break;
                }
                assert (matched_index != 0);
                if (matched_index > 0) {
                    AstNode match = stack.get(matched_index);
                    if (matched_index != stack.size() - 1) {
                        int i;
                        for (i = stack.size() - 1; i > matched_index; --i) {
                            String errorMessage;
                            AstNode node = stack.get(i);
                            if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name()) && !node.isResolved()) {
                                errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTreeBuilder.elementsToString(node.getAllPossibleElements())});
                                node.addDescriptionToNode(UNRESOLVED_TAG_KEY, errorMessage, 2);
                            }
                            if (SyntaxTreeBuilder.hasOptionalEndTag(node)) continue;
                            errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_MISSING_REQUIRED_END_TAG");
                            node.addDescriptionToNode(MISSING_REQUIRED_END_TAG, errorMessage, 2);
                        }
                        for (i = stack.size() - 1; i > matched_index; --i) {
                            AstNode node = stack.get(i);
                            node.setLogicalEndOffset(closeTagNode.startOffset());
                            stack.remove(i);
                        }
                    }
                    if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name()) && !match.isResolved()) {
                        String errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTreeBuilder.elementsToString(match.getAllPossibleElements())});
                        match.addDescriptionToNode(UNRESOLVED_TAG_KEY, errorMessage, 2);
                    }
                    AstNode match_parent = stack.get(matched_index - 1);
                    match_parent.addChild(closeTagNode);
                    match.setMatchingNode(closeTagNode);
                    match.setLogicalEndOffset(closeTagNode.endOffset());
                    closeTagNode.setMatchingNode(match);
                    stack.removeLast();
                    continue;
                }
                if (!dtdElement.hasOptionalStart()) {
                    String errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNMATCHED_TAG");
                    closeTagNode.addDescriptionToNode(UNMATCHED_TAG, errorMessage, 2);
                }
                stack.getLast().addChild(closeTagNode);
                continue;
            }
            if (element.type() != 2 && element.type() != 0) continue;
            AstNode.NodeType nodeType = SyntaxTreeBuilder.intToNodeType(element.type());
            AstNode node = new AstNode(ARTIFICIAL_NODE_NAME, nodeType, element.offset(), element.offset() + element.length(), false);
            SyntaxTreeBuilder.copyProblemsFromElementToNode(element, node);
            stack.getLast().addChild(node);
        }
        for (int i = stack.size() - 1; i > 0; --i) {
            String errorMessage;
            AstNode node = (AstNode)stack.get(i);
            if (!SyntaxTreeBuilder.hasOptionalEndTag(node)) {
                errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNMATCHED_TAG");
                node.addDescriptionToNode(UNMATCHED_TAG, errorMessage, 2);
            }
            if (!SyntaxTreeBuilder.context.isPropertyEnabled(SyntaxAnalyzer.Behaviour.DISABLE_STRUCTURE_CHECKS.name()) && !node.isResolved()) {
                errorMessage = NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTreeBuilder.elementsToString(node.getAllPossibleElements())});
                node.addDescriptionToNode(UNRESOLVED_TAG_KEY, errorMessage, 2);
            }
            node.setLogicalEndOffset(lastEndOffset);
        }
        return rootNode;
    }

    private static void copyProblemsFromElementToNode(SyntaxElement element, AstNode node) {
        List<ProblemDescription> problems = element.getProblems();
        if (problems == null) {
            return;
        }
        for (ProblemDescription problem : problems) {
            node.addDescription(problem);
        }
    }

    private static List<String> stack(LinkedList<AstNode> stack) {
        ArrayList<String> s = new ArrayList<String>();
        for (AstNode node : stack) {
            s.add(node.name());
        }
        return s;
    }

    private static boolean hasOptionalEndTag(AstNode node) {
        DTD.Element e = node.getDTDElement();
        assert (e != null);
        return e.hasOptionalEnd();
    }

    private static boolean isIgnoredTagName(String tagName) {
        return tagName.contains(":");
    }

    private static boolean isIgnoredTagAttribute(String tagName) {
        return tagName.contains(":");
    }

    private static void checkTagAttributes(AstNode node, SyntaxElement.Tag element, DTD.Element dtdElement) {
        DTD.Attribute attr;
        List<SyntaxElement.TagAttribute> existingAttrs = element.getAttributes();
        ArrayList<String> existingAttrNames = new ArrayList<String>(existingAttrs.size());
        for (SyntaxElement.TagAttribute ta : existingAttrs) {
            String tagName = ta.getName().toLowerCase(Locale.ENGLISH);
            existingAttrNames.add(ta.getName().toLowerCase(Locale.ENGLISH));
            attr = dtdElement.getAttribute(tagName);
            if (attr != null || SyntaxTreeBuilder.isIgnoredTagAttribute(ta.getName())) continue;
            ProblemDescription desc = ProblemDescription.create(UNKNOWN_ATTRIBUTE_KEY, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_UNKNOWN_ATTRIBUTE", (Object[])new Object[]{ta.getName(), element.getName()}), 1, ta.getNameOffset(), ta.getNameOffset() + ta.getName().length());
            node.addDescription(desc);
        }
        ArrayList<String> missingAttrsNames = new ArrayList<String>();
        for (Object _attr : dtdElement.getAttributeList(null)) {
            attr = (DTD.Attribute)_attr;
            if (!attr.isRequired() || existingAttrNames.contains(attr.getName())) continue;
            missingAttrsNames.add(attr.getName());
        }
        StringBuilder missingAttributesListMsg = new StringBuilder();
        for (String missingAttrName : missingAttrsNames) {
            missingAttributesListMsg.append(missingAttrName);
            missingAttributesListMsg.append(", ");
        }
        if (missingAttributesListMsg.length() > 0) {
            missingAttributesListMsg.deleteCharAt(missingAttributesListMsg.length() - 2);
            node.addDescriptionToNode(MISSING_REQUIRED_ATTRIBUTES, NbBundle.getMessage(SyntaxTreeBuilder.class, (String)"MSG_MISSING_REQUIRED_ATTRIBUTES", (Object[])new Object[]{missingAttributesListMsg.toString()}), 1);
            node.setProperty(MISSING_REQUIRED_ATTRIBUTES, missingAttrsNames);
        }
    }

    protected static void setTagAttributes(AstNode node, SyntaxElement.Tag tag) {
        for (SyntaxElement.TagAttribute ta : tag.getAttributes()) {
            if (ta == null) continue;
            AstNode.Attribute nodeAttribute = new AstNode.Attribute(ta.getName(), ta.getValue(), ta.getNameOffset(), ta.getValueOffset());
            node.setAttribute(nodeAttribute);
        }
    }

    private static String elementsToString(Collection<DTD.Element> elements) {
        StringBuilder b = new StringBuilder();
        for (DTD.Element e : elements) {
            b.append('<');
            b.append(e.getName());
            b.append('>');
            b.append(", ");
        }
        if (b.length() > 0) {
            b.delete(b.length() - 2, b.length());
        }
        return b.toString();
    }

    private static AstNode.NodeType intToNodeType(int type) {
        switch (type) {
            case 0: {
                return AstNode.NodeType.COMMENT;
            }
            case 1: {
                return AstNode.NodeType.DECLARATION;
            }
            case 5: {
                return AstNode.NodeType.ENDTAG;
            }
            case 6: {
                return AstNode.NodeType.ENTITY_REFERENCE;
            }
            case 2: {
                return AstNode.NodeType.ERROR;
            }
            case 4: {
                return AstNode.NodeType.OPEN_TAG;
            }
            case 3: {
                return AstNode.NodeType.TEXT;
            }
        }
        return null;
    }

    private static final class Context {
        private Context() {
        }

        private boolean isPropertyEnabled(String prop) {
            return false;
        }
    }
}

