/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.encryption;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.encryption.CipherData;
import com.sun.org.apache.xml.internal.security.encryption.CipherReference;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedType;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Logger logger = Logger.getLogger(XMLCipher.class.getName());
    private CipherData _cipherData;
    private int _mode;

    public XMLCipherInput(CipherData cipherData) throws XMLEncryptionException {
        this._cipherData = cipherData;
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType encryptedType) throws XMLEncryptionException {
        this._cipherData = encryptedType == null ? null : encryptedType.getCipherData();
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this._mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String string2 = null;
        if (this._cipherData.getDataType() == 2) {
            Object object;
            logger.log(Level.FINE, "Found a reference type CipherData");
            CipherReference cipherReference = this._cipherData.getCipherReference();
            Attr attr = cipherReference.getURIAsAttr();
            XMLSignatureInput xMLSignatureInput = null;
            try {
                object = ResourceResolver.getInstance(attr, null);
                xMLSignatureInput = ((ResourceResolver)object).resolve(attr, null);
            }
            catch (ResourceResolverException resourceResolverException) {
                throw new XMLEncryptionException("empty", resourceResolverException);
            }
            if (xMLSignatureInput != null) {
                logger.log(Level.FINE, "Managed to resolve URI \"" + cipherReference.getURI() + "\"");
            } else {
                logger.log(Level.FINE, "Failed to resolve URI \"" + cipherReference.getURI() + "\"");
            }
            object = cipherReference.getTransforms();
            if (object != null) {
                logger.log(Level.FINE, "Have transforms in cipher reference");
                try {
                    Transforms transforms = object.getDSTransforms();
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                catch (TransformationException transformationException) {
                    throw new XMLEncryptionException("empty", transformationException);
                }
            }
            try {
                return xMLSignatureInput.getBytes();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("empty", iOException);
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new XMLEncryptionException("empty", canonicalizationException);
            }
        }
        if (this._cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        string2 = this._cipherData.getCipherValue().getValue();
        logger.log(Level.FINE, "Encrypted octets:\n" + string2);
        byte[] byArray = null;
        try {
            byArray = Base64.decode(string2);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLEncryptionException("empty", base64DecodingException);
        }
        return byArray;
    }
}

