/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class WebProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    WebProject project;

    public WebProjectJAXWSClientSupport(WebProject webProject) {
        super((Project)webProject);
        this.project = webProject;
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getWebInf()) != null) {
            FileObject fileObject2 = fileObject.getFileObject("wsdl");
            if (fileObject2 != null) {
                return fileObject2;
            }
            if (bl) {
                return fileObject.createFolder("wsdl");
            }
        }
        return null;
    }

    protected void addJaxWs20Library() throws Exception {
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroupArray.length > 0) {
            FileObject fileObject = sourceGroupArray[0].getRootFolder();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            ClassPath classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath2});
            FileObject fileObject2 = classPath3.findResource("javax/xml/ws/WebServiceFeature.class");
            if (fileObject2 == null) {
                Library library = LibraryManager.getDefault().getLibrary("metro");
                if (library != null) {
                    try {
                        ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)"classpath/compile");
                    }
                    catch (IOException iOException) {
                        throw new Exception("Unable to add Metro library", iOException);
                    }
                } else {
                    throw new Exception("Unable to add Metro Library");
                }
            }
            try {
                WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger(WebProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", iOException);
            }
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        FileObject fileObject = this.project.getWebModule().getConfDir();
        return fileObject == null ? super.getXmlArtifactsRoot() : fileObject;
    }

    protected String getProjectJavaEEVersion() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            if (Profile.JAVA_EE_6_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_5.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

