/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisView;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DisassemblerWindow
extends TopComponent {
    private DisView view;
    private final String name = Catalog.get("TITLE_DisassemblerWindow");
    private NativeDebugger debugger = null;
    static final String preferredID = "DisassemblerWindow";
    static DisassemblerWindow DEFAULT;

    public static synchronized DisassemblerWindow getDefault() {
        DisassemblerWindow tc;
        if (DEFAULT == null && (tc = (DisassemblerWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            new DisassemblerWindow();
        }
        return DEFAULT;
    }

    public DisassemblerWindow() {
        super.setName(this.name);
        this.setIcon(ImageUtilities.loadImage((String)Catalog.get("ICON_DisassemblerView")));
        DEFAULT = this;
        this.initView();
    }

    public void initView() {
        if (this.view == null) {
            this.setLayout(new BorderLayout());
            this.view = new DisView();
        }
        this.add(this.view.getComponent(), "Center");
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void componentHidden() {
        if (this.debugger != null) {
            this.debugger.registerDisassemblerWindow(null);
        }
        super.componentHidden();
    }

    public void componentShowing() {
        if (this.debugger == null) {
            return;
        }
        this.debugger.registerDisassemblerWindow(this);
        super.componentShowing();
        this.view.getController().requestDis(true);
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            this.debugger.registerDisassemblerWindow(null);
        }
        super.componentClosed();
    }

    public void componentActivated() {
        super.componentActivated();
        this.view.componentActivated();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return Catalog.get("TIP_DisWindow");
    }

    public DisView getView() {
        return this.view;
    }

    public void setDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }
}

