/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Utilities;

public abstract class FileMapper {
    public static FileMapper getDefault() {
        if (Utilities.isWindows()) {
            return new CygwinFileMapper();
        }
        return new NullFileMapper();
    }

    public static FileMapper getDefault(Type kind) {
        switch (kind) {
            case NULL: {
                return new NullFileMapper();
            }
            case CYGWIN: {
                return new CygwinFileMapper();
            }
            case MSYS: {
                return new MSysFileMapper();
            }
        }
        return new NullFileMapper();
    }

    public abstract String worldToEngine(String var1);

    public abstract String engineToWorld(String var1);

    private FileMapper() {
    }

    private static class MSysFileMapper
    extends FileMapper {
        private MSysFileMapper() {
        }

        public String engineToWorld(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertFromMSysPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }

        public String worldToEngine(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertToMSysPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }
    }

    private static class CygwinFileMapper_old
    extends FileMapper {
        private static final String prefix = "/cygdrive/";
        private static final int prefixLen = "/cygdrive/".length();

        private CygwinFileMapper_old() {
        }

        public String worldToEngine(String path) {
            String newPath = path;
            if (path.charAt(1) == ':') {
                char disk = path.charAt(0);
                String rest = path.substring(2);
                newPath = prefix + disk + CygwinFileMapper_old.separatorToUnix(rest);
            }
            System.out.println("CygwinFileMapper.worldToEngine():\n\tFrom: " + path + "\n" + "\t  To: " + newPath + "\n");
            return newPath;
        }

        public String engineToWorld(String path) {
            String newPath = path;
            if (path.startsWith(prefix)) {
                char disk = path.charAt(10);
                newPath = "" + disk + ":" + path.substring(prefixLen + 1);
                newPath = CygwinFileMapper_old.separatorToWindows(newPath);
            }
            System.out.println("CygwinFileMapper.engineToWorld():\n\tFrom: " + path + "\n" + "\t  To: " + newPath + "\n");
            return newPath;
        }

        private static String separatorToWindows(String s) {
            StringBuilder sb = new StringBuilder();
            block3: for (int sx = 0; sx < s.length(); ++sx) {
                char c = s.charAt(sx);
                switch (c) {
                    case '/': {
                        sb.append('\\');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        private static String separatorToUnix(String s) {
            StringBuilder sb = new StringBuilder();
            block3: for (int sx = 0; sx < s.length(); ++sx) {
                char c = s.charAt(sx);
                switch (c) {
                    case '\\': {
                        sb.append('/');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class CygwinFileMapper
    extends FileMapper {
        private CygwinFileMapper() {
        }

        public String engineToWorld(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertFromCygwinPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }

        public String worldToEngine(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertToCygwinPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }
    }

    private static class NullFileMapper
    extends FileMapper {
        private NullFileMapper() {
        }

        public String worldToEngine(String path) {
            return path;
        }

        public String engineToWorld(String path) {
            return path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NULL,
        CYGWIN,
        MSYS;

    }
}

