/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.Log;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsProvider {
    private static final boolean DISABLE_PARGS = Boolean.getBoolean("attach.pargs.disable");
    private static final Logger logger = Logger.getLogger(PsProvider.class.getName());
    private Vector<String> parsedHeader = null;
    protected static final String zero = "0";
    private String uid = null;
    private int[][] fields = new int[8][2];
    protected final ExecutionEnvironment exEnv;

    public static synchronized PsProvider getDefault(Host host) {
        PsProvider psProvider = host.getResource(PsProvider.class);
        if (psProvider == null) {
            try {
                ExecutionEnvironment exEnv = host.executionEnvironment();
                if (!ConnectionManager.getInstance().isConnectedTo(exEnv)) {
                    ConnectionManager.getInstance().connectTo(exEnv);
                }
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)exEnv);
                switch (hostInfo.getOSFamily()) {
                    case LINUX: {
                        psProvider = new LinuxPsProvider(host);
                        break;
                    }
                    case WINDOWS: {
                        psProvider = new WindowsPsProvider(host);
                        break;
                    }
                    case MACOSX: {
                        psProvider = new MacOSPsProvider(host);
                        break;
                    }
                    default: {
                        psProvider = new SolarisPsProvider(host);
                        break;
                    }
                }
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            host.putResource(PsProvider.class, psProvider);
        }
        return psProvider;
    }

    protected abstract int commandColumnIndex();

    protected abstract int pidColumnIndex();

    protected abstract String[] headerStr();

    protected abstract String psCommand(String var1);

    protected abstract String uidCommand();

    protected int firstPosition() {
        return 0;
    }

    private PsProvider(Host host) {
        this.exEnv = host.executionEnvironment();
    }

    private String getUid() {
        if (this.uid == null) {
            try {
                NativeProcess process;
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.exEnv);
                npb.setCommandLine(this.uidCommand());
                try {
                    process = npb.call();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to exec id command", e);
                    return this.exEnv.getUser();
                }
                String res = ProcessUtils.readProcessOutputLine((Process)process);
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    String msg = "id command failed with " + exitCode;
                    logger.log(Level.WARNING, msg);
                    return this.exEnv.getUser();
                }
                this.uid = !res.isEmpty() ? res : this.exEnv.getUser();
            }
            catch (Exception e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Failed to parse OutputStream of uid command");
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.uid;
    }

    private void printFields(String str) {
        System.out.printf("------------------------------------------------\n", new Object[0]);
        System.out.printf("%s\n", str);
        for (int sx = 0; sx < str.length(); ++sx) {
            boolean found = false;
            for (int cx = 0; cx < this.headerStr().length; ++cx) {
                if (this.fields[cx][0] == sx) {
                    System.out.printf("%d", cx);
                    found = true;
                    continue;
                }
                if (this.fields[cx][1] != sx) continue;
                System.out.printf("%d", cx);
                found = true;
            }
            if (found) continue;
            System.out.printf(" ", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
        System.out.printf("------------------------------------------------\n", new Object[0]);
    }

    private Vector<String> parseHeader(String str) {
        if (Log.Ps.debug) {
            System.out.printf("parseHeader: '%s'\n", str);
        }
        this.parsedHeader = new Vector(this.headerStr().length - 3);
        for (int cx = 0; cx < this.headerStr().length; ++cx) {
            String s = null;
            int i = str.indexOf(this.headerStr()[cx]);
            if (i >= 0) {
                if (cx == 0) {
                    this.fields[cx][0] = this.firstPosition();
                }
                this.fields[cx][1] = i + this.headerStr()[cx].length() - 1;
            }
            if (cx == 7) {
                s = str.substring(this.fields[cx][0]);
            } else {
                s = str.substring(this.fields[cx][0], this.fields[cx][1] + 1);
                this.fields[cx + 1][0] = i + this.headerStr()[cx].length();
            }
            if (Log.Ps.debug) {
                System.out.println("fields : " + this.fields[cx][0] + " " + this.fields[cx][1]);
            }
            if (cx == 3 || cx == 5 || cx == 6) continue;
            this.parsedHeader.add(s.trim());
        }
        if (Log.Ps.debug) {
            this.printFields(str);
        }
        for (int hx = 0; hx < this.parsedHeader.size(); ++hx) {
            String h = this.parsedHeader.get(hx);
            this.parsedHeader.set(hx, Catalog.get("PS_HDR_" + h));
        }
        return this.parsedHeader;
    }

    public PsData getData(boolean allProcesses) {
        PsData psData = new PsData();
        String luid = allProcesses ? null : this.getUid();
        try {
            NativeProcess process;
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.exEnv);
            npb.setCommandLine(this.psCommand(luid));
            npb.getEnvironment().put("LANG", "C");
            try {
                process = npb.call();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to exec ps command", e);
                return null;
            }
            int lineNo = 0;
            for (String line : ProcessUtils.readProcessOutput((Process)process)) {
                if (Log.Ps.debug) {
                    System.out.printf("PsOutput: '%s'\n", line);
                }
                if (line.indexOf("UID", 0) != -1) {
                    psData.header = this.parseHeader(line);
                    ++lineNo;
                    continue;
                }
                if (lineNo++ <= 0) continue;
                psData.addProcess(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String msg = "ps command failed with " + exitCode;
                logger.log(Level.WARNING, msg);
                return null;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, "Failed to parse OutputStream of ps command");
            ErrorManager.getDefault().notify((Throwable)e);
        }
        if (psData.processes.isEmpty()) {
            ErrorManager.getDefault().log(4096, "No lines from ");
        }
        return psData;
    }

    private static class WindowsPsProvider
    extends PsProvider {
        private static final String[] header_str_windows = new String[]{"PID", "PPID", "PGID", "WINPID", "TTY", "UID", "STIME", "COMMAND"};

        public WindowsPsProvider(Host host) {
            super(host);
        }

        public int commandColumnIndex() {
            return 4;
        }

        protected int firstPosition() {
            return 1;
        }

        public int pidColumnIndex() {
            return 0;
        }

        public String[] headerStr() {
            return header_str_windows;
        }

        protected String uidCommand() {
            return this.getUtilityPath("id") + " -u";
        }

        protected String psCommand(String uid) {
            if (Log.Ps.null_uid) {
                uid = null;
            }
            if (uid == null || uid.equals(PsProvider.zero)) {
                return this.getUtilityPath("ps") + " -W";
            }
            return this.getUtilityPath("ps") + " -u " + uid + " -W";
        }

        private String getUtilityPath(String util) {
            File file = new File(CompilerSetUtils.getCygwinBase() + "/bin", util + ".exe");
            if (!file.exists()) {
                file = new File(CompilerSetUtils.getCommandFolder(null), util + ".exe");
            }
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            return util;
        }
    }

    private static class MacOSPsProvider
    extends LinuxPsProvider {
        private static final String[] header_str_mac = new String[]{"  UID", "   PID", "  PPID", "   C", "     STIME", "TTY     ", "    TIME", "CMD"};

        public String[] headerStr() {
            return header_str_mac;
        }

        public MacOSPsProvider(Host host) {
            super(host);
        }

        protected String psCommand(String uid) {
            if (uid == null || uid.equals(PsProvider.zero)) {
                return "/bin/ps -ef";
            }
            return "/bin/ps -fu " + uid;
        }
    }

    private static class LinuxPsProvider
    extends PsProvider {
        private static final String[] header_str_linux = new String[]{"UID     ", "PID", "PPID", "C", "STIME", "TTY   ", "    TIME", "CMD"};

        public LinuxPsProvider(Host host) {
            super(host);
        }

        public int commandColumnIndex() {
            return 4;
        }

        public int pidColumnIndex() {
            return 1;
        }

        public String[] headerStr() {
            return header_str_linux;
        }

        protected String uidCommand() {
            return "/usr/bin/id -u";
        }

        protected String psCommand(String uid) {
            if (Log.Ps.null_uid) {
                uid = null;
            }
            if (uid == null || uid.equals(PsProvider.zero)) {
                return "/bin/ps -ef";
            }
            return "/bin/ps -fu " + uid + " --width 160";
        }
    }

    private static class SolarisPsProvider
    extends PsProvider {
        private static final String[] header_str_solaris = new String[]{"UID", "PID", "PPID", "C", "STIME", "TTY    ", " TIME", "CMD"};

        public SolarisPsProvider(Host host) {
            super(host);
        }

        public int commandColumnIndex() {
            return 4;
        }

        public int pidColumnIndex() {
            return 1;
        }

        public String[] headerStr() {
            return header_str_solaris;
        }

        protected String uidCommand() {
            return "/usr/xpg4/bin/id -u";
        }

        protected String psCommand(String uid) {
            if (Log.Ps.null_uid) {
                uid = null;
            }
            if (uid == null || uid.equals(PsProvider.zero)) {
                return "/usr/bin/ps -ef";
            }
            return "/usr/bin/ps -fu " + uid;
        }

        public PsData getData(boolean allProcesses) {
            PsData res = super.getData(allProcesses);
            if (res != null && !DISABLE_PARGS && !res.processes.isEmpty()) {
                NativeProcessBuilder pargsBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.exEnv);
                pargsBuilder.setExecutable("/usr/bin/pargs").redirectError();
                pargsBuilder.getEnvironment().put("LC_ALL", "C");
                String[] pargs_args = new String[res.processes.size() + 1];
                pargs_args[0] = "-Fl";
                int idx = 1;
                for (Vector proc : res.processes) {
                    pargs_args[idx++] = (String)proc.get(this.pidColumnIndex());
                }
                pargsBuilder.setArguments(pargs_args);
                try {
                    List pargsOutput = ProcessUtils.readProcessOutput((Process)pargsBuilder.call());
                    idx = 1;
                    for (String procArgs : pargsOutput) {
                        if (procArgs.isEmpty() || procArgs.startsWith("pargs: Warning")) continue;
                        if (!procArgs.startsWith("pargs:")) {
                            res.updateCommand(pargs_args[idx], procArgs);
                        }
                        ++idx;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PsData {
        private Vector<Vector<String>> processes = new Vector();
        private Vector<String> header = null;

        public Vector<String> header() {
            return this.header;
        }

        public int commandColumnIdx() {
            return PsProvider.this.commandColumnIndex();
        }

        public int pidColumnIdx() {
            return PsProvider.this.pidColumnIndex();
        }

        public Vector<Vector<String>> processes(Pattern re) {
            Vector<Vector<String>> res = new Vector<Vector<String>>();
            block0: for (Vector<String> proc : this.processes) {
                for (String field : proc) {
                    if (!re.matcher(field).find()) continue;
                    res.add(proc);
                    continue block0;
                }
            }
            return res;
        }

        private void addProcess(String line) {
            Vector<String> columns = new Vector<String>(PsProvider.this.headerStr().length - 3);
            for (int cx = 0; cx < PsProvider.this.headerStr().length; ++cx) {
                String s = null;
                s = cx == 7 ? line.substring(PsProvider.this.fields[cx][0]) : line.substring(PsProvider.this.fields[cx][0], PsProvider.this.fields[cx][1] + 1);
                if (cx == 3 || cx == 5 || cx == 6) continue;
                columns.add(s.trim());
            }
            this.processes.add(columns);
        }

        private void updateCommand(String pid, String command) {
            for (Vector<String> proc : this.processes) {
                if (!pid.equals(proc.get(this.pidColumnIdx()))) continue;
                proc.set(this.commandColumnIdx(), command);
            }
        }
    }
}

