/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.beans.PropertyEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionDirectoryEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionEnumEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetOwner;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Validity;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public class OptionPropertySupport
extends PropertySupport {
    private final Option option;
    private final OptionSetOwner optionSetOwner;
    private final String base;

    public OptionPropertySupport(OptionSetOwner optionSetOwner, Option option, String base) {
        super(option.getName(), option.getType() == 4 ? Boolean.class : Object.class, option.getDisplayName(), option.getShortDescription(), true, true);
        this.option = option;
        this.optionSetOwner = optionSetOwner;
        this.base = base;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return this.option.canWrite(this.optionSetOwner.getOptions());
    }

    public void setValue(Object o) {
        OptionValue ov = this.optionSetOwner.getOptions().byType(this.option);
        if (ov != null) {
            if (this.option.getType() == 4 && o instanceof Boolean) {
                Boolean b = (Boolean)o;
                ov.set(b == Boolean.TRUE ? "on" : "off");
            } else {
                ov.set((String)o);
            }
        } else {
            ErrorManager.getDefault().log(16, String.format("setValue(): null OptionValue for %s", this.option.getName()));
        }
    }

    public Object getValue() {
        OptionValue ov = this.optionSetOwner.getOptions().byType(this.option);
        if (ov != null) {
            if (this.option.getType() == 4) {
                if (ov.get().equalsIgnoreCase("on")) {
                    return Boolean.TRUE;
                }
                if (ov.get().equalsIgnoreCase("off")) {
                    return Boolean.FALSE;
                }
                return null;
            }
            return ov.get();
        }
        ErrorManager.getDefault().log(16, String.format("getValue(): null OptionValue for %s", this.option.getName()));
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        PropertyEditor propertyEditor = null;
        switch (this.option.getType()) {
            case 4: {
                propertyEditor = super.getPropertyEditor();
                break;
            }
            case 5: {
                propertyEditor = new OptionDirectoryEditor(this, this.base, 1);
                break;
            }
            case 6: {
                propertyEditor = new OptionDirectoryEditor(this, this.base, 0);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                propertyEditor = new OptionEnumEditor(this);
                break;
            }
        }
        return propertyEditor;
    }

    public boolean supportsDefaultValue() {
        return this.option.getDefaultValue() != null;
    }

    public boolean isDefaultValue() {
        if (!this.supportsDefaultValue()) {
            return true;
        }
        OptionValue ov = this.optionSetOwner.getOptions().byType(this.option);
        if (ov != null) {
            return IpeUtils.sameString(ov.get(), this.option.getDefaultValue());
        }
        return true;
    }

    public void restoreDefaultValue() {
        if (!this.supportsDefaultValue()) {
            return;
        }
        this.setValue(this.option.getDefaultValue());
    }

    public String getHtmlDisplayName() {
        if (this.isDefaultValue()) {
            return this.getDisplayName();
        }
        return "<b>" + this.getDisplayName() + "</b>";
    }

    String[] getValues() {
        return this.option.getValues();
    }

    Validity getValidity(String text) {
        return this.option.getValidity(text);
    }
}

