/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.folding.APTFoldingCommentFilter;
import org.netbeans.modules.cnd.folding.APTFoldingUtils;

class APTFoldingWalker
extends APTWalker {
    private static final int IFDEF_FOLD = 5;
    private static final int INCLUDES_FOLD = 4;
    private APTFoldingCommentFilter filter = null;
    private List<CppFoldRecord> includeFolds = new ArrayList<CppFoldRecord>();
    private List<CppFoldRecord> ifdefFolds = new ArrayList<CppFoldRecord>();
    private Stack<APT> ppStartDirectives = new Stack();
    private APT firstInclude = null;
    private APT lastInclude = null;

    public APTFoldingWalker(APTFile aPTFile) {
        super(aPTFile, null);
    }

    public TokenStream getFilteredTokenStream(APTLanguageFilter aPTLanguageFilter) {
        return aPTLanguageFilter.getFilteredStream(this.getTokenStream());
    }

    public TokenStream getTokenStream() {
        this.filter = new APTFoldingCommentFilter(super.getTokenStream());
        return this.filter;
    }

    public List<CppFoldRecord> getFolders() {
        List<CppFoldRecord> list = this.filter.getFolders();
        ArrayList<CppFoldRecord> arrayList = new ArrayList<CppFoldRecord>(list.size() + this.includeFolds.size() + this.ifdefFolds.size());
        arrayList.addAll(list);
        arrayList.addAll(this.includeFolds);
        arrayList.addAll(this.ifdefFolds);
        return arrayList;
    }

    protected void onInclude(APT aPT) {
        this.include(aPT);
    }

    protected void onIncludeNext(APT aPT) {
        this.include(aPT);
    }

    protected boolean onIf(APT aPT) {
        return this.onStartPreprocNode(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        return this.onStartPreprocNode(aPT);
    }

    protected boolean onIfndef(APT aPT) {
        return this.onStartPreprocNode(aPT);
    }

    protected void onDefine(APT aPT) {
        this.onOtherPreprocNode(aPT);
    }

    protected void onUndef(APT aPT) {
        this.onOtherPreprocNode(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        this.onOtherPreprocNode(aPT);
        return true;
    }

    protected boolean onElse(APT aPT, boolean bl) {
        this.onOtherPreprocNode(aPT);
        return true;
    }

    protected void onEndif(APT aPT, boolean bl) {
        this.createEndifFold(aPT);
    }

    protected void onErrorNode(APT aPT) {
        this.onOtherPreprocNode(aPT);
    }

    protected void onPragmaNode(APT aPT) {
        this.onOtherPreprocNode(aPT);
    }

    protected void onOtherNode(APT aPT) {
        this.onOtherPreprocNode(aPT);
    }

    protected void onStreamNode(APT aPT) {
        this.addIncludesIfNeeded();
    }

    protected void onEOF() {
        this.addIncludesIfNeeded();
    }

    private boolean onStartPreprocNode(APT aPT) {
        this.filter.onPreprocNode(aPT);
        this.addIncludesIfNeeded();
        this.ppStartDirectives.push(aPT);
        return true;
    }

    private void createEndifFold(APT aPT) {
        this.filter.onPreprocNode(aPT);
        this.addIncludesIfNeeded();
        if (!this.ppStartDirectives.empty()) {
            APT aPT2 = this.ppStartDirectives.pop();
            int n = aPT2.getEndOffset();
            int n2 = aPT.getEndOffset();
            if (APTFoldingUtils.isStandalone()) {
                this.ifdefFolds.add(new CppFoldRecord(5, aPT2.getToken().getLine(), n, aPT.getToken().getEndLine(), n2));
            } else {
                this.ifdefFolds.add(new CppFoldRecord(5, n, n2));
            }
        }
    }

    private void include(APT aPT) {
        this.filter.onPreprocNode(aPT);
        if (this.firstInclude == null) {
            this.firstInclude = aPT;
        }
        this.lastInclude = aPT;
    }

    private void addIncludesIfNeeded() {
        if (this.lastInclude != this.firstInclude) {
            int n;
            assert (this.lastInclude != null);
            assert (this.firstInclude != null);
            int n2 = this.firstInclude.getToken().getEndOffset();
            if (n2 < (n = this.lastInclude.getEndOffset())) {
                if (APTFoldingUtils.isStandalone()) {
                    this.includeFolds.add(new CppFoldRecord(4, this.firstInclude.getToken().getLine(), n2, this.lastInclude.getToken().getEndLine(), n));
                } else {
                    this.includeFolds.add(new CppFoldRecord(4, n2, n));
                }
            }
        }
        this.lastInclude = null;
        this.firstInclude = null;
    }

    private void onOtherPreprocNode(APT aPT) {
        this.filter.onPreprocNode(aPT);
        this.addIncludesIfNeeded();
    }

    protected boolean stopOnErrorDirective() {
        return false;
    }
}

