/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class RowForegroundDecorator
implements ChartDecorator {
    private static final Color SELECTED_FILTER = new Color(0, 0, 200, 25);
    private static final float[] FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
    private static final Color[] COLORS = new Color[]{new Color(250, 251, 252, 120), new Color(237, 240, 242, 120), new Color(229, 233, 236, 125), new Color(215, 221, 226, 130)};
    private final TimelineChart chart;
    private final boolean gradient;
    private final boolean selection;

    RowForegroundDecorator(TimelineChart chart, boolean gradient, boolean selection) {
        this.chart = chart;
        this.gradient = gradient;
        this.selection = selection;
    }

    public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        if (this.gradient || this.selection) {
            int rowsCount = this.chart.getRowsCount();
            for (int i = 0; i < rowsCount; ++i) {
                TimelineChart.Row row = this.chart.getRow(i);
                ChartContext rowContext = row.getContext();
                int y = Utils.checkedInt((double)rowContext.getViewportOffsetY());
                int h = Utils.checkedInt((double)(rowContext.getViewportHeight() - 1));
                if (this.gradient) {
                    g.setPaint(new LinearGradientPaint(0.0f, y, 0.0f, y + h, FRACTIONS, COLORS));
                    g.fillRect(0, y, this.chart.getWidth(), h);
                }
                if (!this.selection || !this.chart.isRowSelected(row)) continue;
                g.setColor(SELECTED_FILTER);
                g.fillRect(0, y, this.chart.getWidth(), h);
            }
        }
    }
}

