/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.swing.JDialog;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.EventsModel;
import org.netbeans.modules.web.beans.navigation.EventsPanel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InjectablesPanel;
import org.netbeans.modules.web.beans.navigation.ObserversModel;
import org.netbeans.modules.web.beans.navigation.ObserversPanel;
import org.netbeans.modules.web.beans.navigation.ResizablePopup;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.InspectEventsAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.InspectInjectablesAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.InspectObserversAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebBeansActionHelper {
    static final String FIRE = "fire";
    static final String EVENT_INTERFACE = "javax.enterprise.event.Event";
    static final String OBSERVES_ANNOTATION = "javax.enterprise.event.Observes";
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER);

    private WebBeansActionHelper() {
    }

    public static boolean isEnabled() {
        if (EditorRegistry.lastFocusedComponent() == null || !EditorRegistry.lastFocusedComponent().isShowing()) {
            return false;
        }
        if (OpenProjects.getDefault().getOpenProjects().length == 0) {
            return false;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)EditorRegistry.lastFocusedComponent().getDocument());
        if (fileObject == null) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB);
    }

    static boolean getVariableElementAtDot(final JTextComponent component, final Object[] variable, final boolean showStatusOnError) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = component.getCaret().getDot();
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element element = controller.getTrees().getElement(tp);
                    if (element == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    if (!(element instanceof VariableElement) && showStatusOnError) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_NotVariableElement"));
                        return;
                    }
                    if (element.getKind() == ElementKind.FIELD) {
                        ElementHandle handle = ElementHandle.create((Element)((VariableElement)element));
                        variable[0] = handle;
                        variable[1] = element.getSimpleName().toString();
                        variable[2] = ModelActionStrategy.InspectActionId.INJECTABLES;
                    } else {
                        WebBeansActionHelper.setVariablePath(variable, controller, element);
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
        return variable[1] != null;
    }

    static boolean getMethodAtDot(final JTextComponent component, final Object[] subject) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    Element enclosingElement;
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = component.getCaret().getDot();
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element element = controller.getTrees().getElement(tp);
                    if (element == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    if (element instanceof ExecutableElement) {
                        subject[0] = ElementHandle.create((Element)element);
                        subject[1] = element.getSimpleName();
                        subject[2] = ModelActionStrategy.InspectActionId.EVENTS;
                    } else if (element instanceof VariableElement && (enclosingElement = element.getEnclosingElement()) instanceof ExecutableElement) {
                        List<? extends AnnotationMirror> annotations = controller.getElements().getAllAnnotationMirrors(element);
                        for (AnnotationMirror annotationMirror : annotations) {
                            DeclaredType annotationType = annotationMirror.getAnnotationType();
                            Element annotationElement = annotationType.asElement();
                            Name annotationName = ((TypeElement)annotationElement).getQualifiedName();
                            if (!WebBeansActionHelper.OBSERVES_ANNOTATION.contentEquals(annotationName)) continue;
                            subject[0] = ElementHandle.create((Element)enclosingElement);
                            subject[1] = enclosingElement.getSimpleName();
                            subject[2] = ModelActionStrategy.InspectActionId.EVENTS;
                            return;
                        }
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(GoToInjectableAtCaretAction.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
        return subject[0] != null;
    }

    public static boolean getContextEventInjectionAtDot(final JTextComponent component, final Object[] variable) {
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)component.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ExpressionTree select;
                    Tree parentLeaf;
                    Parser.Result resuslt = resultIterator.getParserResult(component.getCaret().getDot());
                    CompilationController controller = CompilationController.get((Parser.Result)resuslt);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    Token[] token = new Token[1];
                    int[] span = WebBeansActionHelper.getIdentifierSpan(component.getDocument(), component.getCaret().getDot(), token);
                    if (span == null) {
                        return;
                    }
                    int exactOffset = controller.getSnapshot().getEmbeddedOffset(span[0] + 1);
                    TreePath path = controller.getTreeUtilities().pathFor(exactOffset);
                    TreePath parent = path.getParentPath();
                    if (parent != null && (parentLeaf = parent.getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION && (select = ((MethodInvocationTree)parentLeaf).getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
                        Scope scope = controller.getTrees().getScope(path);
                        TypeElement subjectClass = scope.getEnclosingClass();
                        Element method = controller.getTrees().getElement(new TreePath(path, select));
                        Element caller = controller.getTrees().getElement(new TreePath(path, ((MemberSelectTree)select).getExpression()));
                        String methodName = method.getSimpleName().toString();
                        if (WebBeansActionHelper.FIRE.equals(methodName) && method instanceof ExecutableElement && caller instanceof VariableElement) {
                            String variableName = caller.getSimpleName().toString();
                            TypeElement enclosingTypeElement = controller.getElementUtilities().enclosingTypeElement(method);
                            String fqnMethodClass = enclosingTypeElement.getQualifiedName().toString();
                            if (WebBeansActionHelper.EVENT_INTERFACE.equals(fqnMethodClass)) {
                                List<VariableElement> fields = ElementFilter.fieldsIn(controller.getElements().getAllMembers(subjectClass));
                                for (VariableElement var : fields) {
                                    String varName = var.getSimpleName().toString();
                                    if (!variableName.equals(varName)) continue;
                                    ElementHandle handle = ElementHandle.create((Element)var);
                                    variable[0] = handle;
                                    variable[1] = varName;
                                    variable[2] = ModelActionStrategy.InspectActionId.OBSERVERS;
                                    return;
                                }
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return variable[1] != null;
    }

    static void showInjectablesDialog(MetadataModel<WebBeansModel> metamodel, WebBeansModel model, Object[] subject, InjectablesModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.INJECTABLES;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(InspectInjectablesAtCaretAction.class, (String)"TITLE_Injectables", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new InjectablesPanel(subject, metamodel, model, uiModel));
        dialog.setVisible(true);
    }

    static void showEventsDialog(MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, EventsModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.EVENTS;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(InspectEventsAtCaretAction.class, (String)"TITLE_Events", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new EventsPanel(subject, metaModel, model, uiModel));
        dialog.setVisible(true);
    }

    static void showObserversDialog(List<ExecutableElement> methods, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, Object[] subject, ObserversModel uiModel, String name) {
        subject[2] = ModelActionStrategy.InspectActionId.OBSERVERS;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        JDialog dialog = ResizablePopup.getDialog();
        String title = NbBundle.getMessage(InspectObserversAtCaretAction.class, (String)"TITLE_Observers", (Object)name);
        dialog.setTitle(title);
        dialog.setContentPane(new ObserversPanel(subject, metaModel, model, uiModel));
        dialog.setVisible(true);
    }

    public static VariableElement findVariable(WebBeansModel model, Object[] variablePath) {
        if (variablePath[0] == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
            return null;
        }
        Element element = ((ElementHandle)variablePath[0]).resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
            return null;
        }
        VariableElement var = null;
        ExecutableElement method = null;
        if (element.getKind() == ElementKind.FIELD) {
            var = (VariableElement)element;
        } else {
            method = (ExecutableElement)element;
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (!variableElement.getSimpleName().contentEquals(variablePath[1].toString())) continue;
                var = variableElement;
            }
        }
        if (var == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_VariableNotFound", (Object)variablePath[1]));
        }
        return var;
    }

    static int[] getIdentifierSpan(Document doc, int offset, Token<JavaTokenId>[] token) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
        if (fileObject == null) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        if (JavaTokenId.JAVADOC_COMMENT == t.id()) {
            return null;
        }
        if (!USABLE_TOKEN_IDS.contains(t.id())) {
            ts.move(offset - 1);
            if (!ts.moveNext()) {
                return null;
            }
            t = ts.token();
            if (!USABLE_TOKEN_IDS.contains(t.id())) {
                return null;
            }
        }
        if (token != null) {
            token[0] = t;
        }
        return new int[]{ts.offset(), ts.offset() + t.length()};
    }

    private static void setVariablePath(Object[] variableAtCaret, CompilationController controller, Element element) {
        Element parent = element.getEnclosingElement();
        if (parent instanceof ExecutableElement) {
            ElementHandle handle = ElementHandle.create((Element)((ExecutableElement)parent));
            variableAtCaret[0] = handle;
            variableAtCaret[1] = element.getSimpleName().toString();
            variableAtCaret[2] = ModelActionStrategy.InspectActionId.INJECTABLES;
        }
    }
}

