/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.Util;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;

public class CDCPlatform
extends JavaPlatform {
    public static final String PROP_ANT_NAME = "antName";
    public static final String PLATFORM_CDC = "cdc";
    protected static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PLATFORM_STRING_PREFIX = "${platform.home}/";
    public static String PROP_EXEC_MAIN = "main";
    public static String PROP_EXEC_XLET = "xlet";
    public static String PROP_EXEC_APPLET = "applet";
    private Properties properties;
    private String displayName;
    private String type;
    private String classVersion;
    private ClassPath sources;
    private List<URL> javadoc;
    private List<URL> installFolders;
    private CDCDevice[] devices;
    private boolean fatJar;
    Reference<ClassPath> bootstrap = new WeakReference<Object>(null);
    Reference<ClassPath> standardLibs = new WeakReference<Object>(null);
    private Specification spec;

    public CDCPlatform(String dispName, String antName, String type, String classVersion, List<URL> installFolders, List<URL> sources, List<URL> javadoc, CDCDevice[] devices, boolean fatJar) {
        assert (classVersion != null);
        this.displayName = dispName;
        this.type = type;
        this.classVersion = classVersion;
        this.devices = devices;
        this.fatJar = fatJar;
        if (installFolders != null) {
            this.installFolders = installFolders;
        }
        this.sources = CDCPlatform.createClassPath(sources);
        this.javadoc = javadoc != null ? Collections.unmodifiableList(javadoc) : Collections.EMPTY_LIST;
        this.properties = new Properties();
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.firePropertyChange("displayName", null, null);
    }

    protected final void internalSetDisplayName(String name) {
        this.displayName = name;
    }

    public String getAntName() {
        return (String)this.properties.get(PLAT_PROP_ANT_NAME);
    }

    public void setAntName(String antName) {
        if (antName == null || antName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
        this.firePropertyChange(PROP_ANT_NAME, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBootstrapLibraries(List<URL> bs) {
        assert (bs != null);
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ArrayList<URL> newPath = new ArrayList<URL>();
            newPath.addAll(bs);
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
            List entries = cp.entries();
            ArrayList<FileObject> removed = new ArrayList<FileObject>();
            for (ClassPath.Entry entry : entries) {
                URL url = entry.getURL();
                if (newPath.remove(url)) continue;
                removed.add(entry.getRoot());
            }
            boolean changing = false;
            this.bootstrap = new WeakReference<ClassPath>(ClassPathSupport.createClassPath((URL[])bs.toArray(new URL[bs.size()])));
            for (CDCDevice device : this.devices) {
                CDCDevice.CDCProfile[] profiles;
                for (CDCDevice.CDCProfile profile : profiles = device.getProfiles()) {
                    String bootp = profile.getBootClassPath();
                    List<FileObject> fobs = this.resolveRelativePathToFileObjects(bootp);
                    for (FileObject fo : removed) {
                        fobs.remove(fo);
                    }
                    StringBuffer newBS = new StringBuffer();
                    for (URL url : bs) {
                        FileObject fo = URLMapper.findFileObject((URL)url);
                        String name = null;
                        if (fo.isRoot()) {
                            try {
                                name = fo.getFileSystem().getDisplayName();
                            }
                            catch (FileStateInvalidException ex) {}
                        } else {
                            name = fo.getPath();
                        }
                        if (newPath.contains(url)) {
                            newBS.append(name);
                            newBS.append(';');
                        }
                        if (!fobs.contains(fo)) continue;
                        newBS.append(name);
                        newBS.append(';');
                    }
                    changing = true;
                    profile.setBootClassPath(newBS.toString());
                    profile.setRunClassPath(newBS.toString());
                }
            }
            if (changing) {
                this.firePropertyChange("classpath", null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getBootstrapLibraries() {
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ClassPath cp;
            ClassPath classPath = cp = this.bootstrap == null ? null : this.bootstrap.get();
            if (cp != null) {
                return cp;
            }
            cp = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
            this.bootstrap = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    public ClassPath getBootstrapLibrariesForProfile(String activeDevice, String activeProfile) {
        if (activeDevice == null || activeProfile == null) {
            return this.getBootstrapLibraries();
        }
        CDCDevice[] devices = this.getDevices();
        CDCDevice.CDCProfile active = null;
        block0: for (int i = 0; devices != null && i < devices.length; ++i) {
            if (!devices[i].getName().equals(activeDevice)) continue;
            CDCDevice.CDCProfile[] profiles = devices[i].getProfiles();
            for (int j = 0; profiles != null && j < profiles.length; ++j) {
                if (!profiles[j].getName().equals(activeProfile)) continue;
                active = profiles[j];
                break block0;
            }
            break;
        }
        if (active != null) {
            List<FileObject> l = this.resolveRelativePathToFileObjects(active.getBootClassPath());
            return ClassPathSupport.createClassPath((FileObject[])l.toArray(new FileObject[l.size()]));
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public void setClassVersion(String classVersion) {
        this.classVersion = classVersion;
    }

    public CDCDevice[] getDevices() {
        return this.devices;
    }

    public void setDevices(CDCDevice[] devices) {
        this.devices = devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ClassPath cp;
            ClassPath classPath = cp = this.standardLibs == null ? null : this.standardLibs.get();
            if (cp != null) {
                return cp;
            }
            cp = ClassPathSupport.createClassPath(new ArrayList());
            this.standardLibs = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    public String getHomePath() {
        Iterator<FileObject> it = this.getInstallFolders().iterator();
        if (it.hasNext()) {
            FileObject fo = it.next();
            return FileUtil.toFile((FileObject)fo).getAbsolutePath();
        }
        return null;
    }

    public final Collection<FileObject> getInstallFolders() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (URL url : this.installFolders) {
            FileObject root = URLMapper.findFileObject((URL)url);
            if (root == null) continue;
            result.add(root);
        }
        return result;
    }

    public final FileObject findTool(String toolName) {
        System.out.println("findTool: " + toolName);
        return null;
    }

    public final FileObject findTool(String folder, String toolName) {
        return Util.findTool(folder, toolName, this.getInstallFolders());
    }

    public final ClassPath getSourceFolders() {
        return this.sources;
    }

    public final void setSourceFolders(ClassPath c) {
        assert (c != null);
        this.sources = c;
        this.firePropertyChange("sourceFolders", null, null);
    }

    public final List<URL> getJavadocFolders() {
        return this.javadoc;
    }

    public final void setJavadocFolders(List<URL> c) {
        assert (c != null);
        List<URL> safeCopy = Collections.unmodifiableList(new ArrayList<URL>(c));
        for (URL url : safeCopy) {
            if ("jar".equals(url.getProtocol()) || !FileUtil.isArchiveFile((URL)url)) continue;
            throw new IllegalArgumentException("JavadocFolder must be a folder.");
        }
        this.javadoc = safeCopy;
        this.firePropertyChange("javadocFolders", null, null);
    }

    public String getVendor() {
        String s = (String)this.getSystemProperties().get("java.vm.vendor");
        return s == null ? "" : s;
    }

    public Specification getSpecification() {
        if (this.spec == null) {
            this.spec = new Specification(PLATFORM_CDC, new SpecificationVersion(this.getClassVersion()));
        }
        return this.spec;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Collection getInstallFolderURLs() {
        return Collections.unmodifiableList(this.installFolders);
    }

    private static ClassPath createClassPath(List<URL> urls) {
        ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
        if (urls != null) {
            for (URL url : urls) {
                resources.add(ClassPathSupport.createResource((URL)url));
            }
        }
        return ClassPathSupport.createClassPath(resources);
    }

    private FileObject[] getAllLibraries() {
        ArrayList<FileObject> fobs = new ArrayList<FileObject>();
        for (CDCDevice device : this.devices) {
            for (CDCDevice.CDCProfile profile : device.getProfiles()) {
                List<FileObject> list = this.resolveRelativePathToFileObjects(profile.getBootClassPath());
                int lastIndex = -1;
                for (FileObject fo : list) {
                    if (!fobs.contains(fo)) {
                        fobs.add(lastIndex + 1, fo);
                    }
                    lastIndex = fobs.indexOf(fo);
                }
            }
        }
        return fobs.toArray(new FileObject[fobs.size()]);
    }

    private List<FileObject> resolveRelativePathToFileObjects(String path) {
        String[] paths;
        ArrayList<FileObject> res = new ArrayList<FileObject>();
        if (path == null) {
            return res;
        }
        for (String pth : paths = PropertyUtils.tokenizePath((String)path)) {
            FileObject fo = this.resolveRelativePathToFileObject(pth.trim());
            if (fo == null) continue;
            res.add(fo);
        }
        return res;
    }

    public FileObject resolveRelativePathToFileObject(String path) {
        File f;
        FileObject fo;
        if (path == null || path.length() <= 0) {
            return null;
        }
        if (path.startsWith(PLATFORM_STRING_PREFIX)) {
            fo = URLMapper.findFileObject((URL)this.installFolders.iterator().next());
            if (fo == null) {
                return null;
            }
            f = new File(FileUtil.toFile((FileObject)fo), path.substring(PLATFORM_STRING_PREFIX.length()));
        } else {
            f = new File(path);
            if (!f.exists()) {
                return null;
            }
        }
        f = FileUtil.normalizeFile((File)f);
        fo = FileUtil.toFileObject((File)f);
        if (fo == null || !FileUtil.isArchiveFile((FileObject)fo)) {
            return fo;
        }
        return FileUtil.getArchiveRoot((FileObject)fo);
    }

    public boolean isFatJar() {
        return this.fatJar;
    }
}

