/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.StringTokenizer;

public class StringConfiguration {
    private StringConfiguration master;
    private String def;
    private String value;
    private boolean modified;

    public StringConfiguration(StringConfiguration master, String def) {
        this.master = master;
        this.def = def;
        this.reset();
    }

    public void setMaster(StringConfiguration master) {
        this.master = master;
    }

    public void setValue(String b) {
        if (b == null) {
            b = "";
        }
        this.value = b;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(!b.equals(this.getDefault()));
        }
    }

    public String getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public String getValueDef(String def) {
        if (this.master != null && !this.getModified() && !this.master.getModified() && def != null) {
            return def;
        }
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        if (!this.getModified() && def != null) {
            return def;
        }
        return this.value;
    }

    public String getValue(String delim) {
        StringBuilder ret = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(this.getValue());
        while (tokenizer.hasMoreTokens()) {
            ret.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            ret.append(delim);
        }
        return ret.toString();
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public String getDefault() {
        return this.def;
    }

    public final void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public void setDefaultValue(String def) {
        this.def = def;
    }

    public void assign(StringConfiguration conf) {
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public StringConfiguration clone() {
        StringConfiguration clone = new StringConfiguration(this.master, this.def);
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        return clone;
    }

    public String toString() {
        return "{value=" + this.value + " modified=" + this.modified + '}';
    }
}

