/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectBinaryPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.DocumentAdapter;
import org.netbeans.modules.cnd.utils.ui.EditableComboBox;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SelectBinaryPanelVisual
extends JPanel {
    private final SelectBinaryPanel controller;
    private static final RequestProcessor RP = new RequestProcessor("Binary Artifact Discovery", 1);
    private final AtomicInteger checking = new AtomicInteger(0);
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable");
    private DefaultTableModel tableModel;
    private static final String BINARY_FILE_KEY = "binaryField";
    private final List<AtomicBoolean> cancelable = new ArrayList<AtomicBoolean>();
    private JButton binaryButton;
    private JComboBox binaryField;
    private JLabel binaryLabel;
    private JComboBox dependeciesComboBox;
    private JLabel dependenciesLabel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton sourcesButton;
    private JTextField sourcesField;
    private JLabel sourcesLabel;
    private JTable table;
    private JComboBox viewComboBox;
    private JLabel viewLabel;
    private static final int BUTTON_WIDTH = 20;

    public SelectBinaryPanelVisual(SelectBinaryPanel controller) {
        this.controller = controller;
        this.initComponents();
        this.dependeciesComboBox.removeAllItems();
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.Minimal));
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.IncludeDependencies));
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.CreateDependencies));
        this.dependeciesComboBox.setSelectedIndex(1);
        this.viewComboBox.removeAllItems();
        this.viewComboBox.addItem(new ProjectView(false));
        this.viewComboBox.addItem(new ProjectView(true));
        this.addListeners();
    }

    private void addListeners() {
        ((EditableComboBox)this.binaryField).addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = ((EditableComboBox)SelectBinaryPanelVisual.this.binaryField).getText().trim();
                SelectBinaryPanelVisual.this.controller.getWizardStorage().setBinaryPath(path);
                SelectBinaryPanelVisual.this.updateRoot();
            }
        });
        this.sourcesField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                String path = SelectBinaryPanelVisual.this.sourcesField.getText().trim();
                SelectBinaryPanelVisual.this.controller.getWizardStorage().setSourceFolderPath(path);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickedLine = SelectBinaryPanelVisual.this.table.rowAtPoint(e.getPoint());
                if (clickedLine != -1 && e.getModifiers() == 16 && e.getClickCount() == 1) {
                    SelectBinaryPanelVisual.this.onClickAction(e);
                }
            }
        });
        this.dependeciesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.err.println("selection " + e);
                SelectBinaryPanelVisual.this.validateController();
            }
        });
        this.updateRoot();
    }

    private void validateController() {
        this.controller.getWizardStorage().validate();
    }

    private void updateRoot() {
        this.sourcesField.setEnabled(false);
        this.sourcesButton.setEnabled(false);
        this.dependeciesComboBox.setEnabled(false);
        this.viewComboBox.setEnabled(false);
        this.table.setModel(new DefaultTableModel(0, 0));
        if (this.validBinary()) {
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
            this.checking.incrementAndGet();
            this.validateController();
            final IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            final HashMap<String, String> map = new HashMap<String, String>();
            map.put("DW:buildResult", this.controller.getWizardStorage().getBinaryPath());
            if (extension != null) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        extension.discoverArtifacts(map);
                        List dlls = (List)map.get("DW:dependencies");
                        String root = (String)map.get("DW:rootFolder");
                        if (root == null) {
                            root = "";
                        }
                        List searchPaths = (List)map.get("DW:searchPaths");
                        SelectBinaryPanelVisual.this.updateArtifacts(root, map, SelectBinaryPanelVisual.this.searchingTable(dlls));
                        Map checkDll = SelectBinaryPanelVisual.this.checkDll(dlls, root, searchPaths, SelectBinaryPanelVisual.this.controller.getWizardStorage().getBinaryPath());
                        SelectBinaryPanelVisual.this.updateDllArtifacts(root, checkDll);
                    }
                });
            }
        } else {
            String path = ((EditableComboBox)this.binaryField).getText().trim();
            if (!path.isEmpty() && this.controller.getWizardDescriptor() != null) {
                if (CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)path));
                    if (fo == null || !fo.isValid()) {
                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.FileNotFound"));
                    } else {
                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Unsupported.Binary"));
                    }
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.FileNotFound"));
                }
            }
        }
    }

    private void updateArtifacts(final String root, final Map<String, Object> map, final Map<String, String> dlls) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List errors;
                CompilerSet compiler = SelectBinaryPanelVisual.this.detectCompilerSet((String)map.get("DW:compiler"));
                if (compiler != null) {
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("toolchain", (Object)compiler);
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("hostUID", (Object)ExecutionEnvironmentFactory.getLocal().getHost());
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("readOnlyToolchain", (Object)Boolean.TRUE);
                } else {
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("readOnlyToolchain", (Object)Boolean.FALSE);
                }
                SelectBinaryPanelVisual.this.sourcesField.setText(root);
                int i = SelectBinaryPanelVisual.this.checking.decrementAndGet();
                if (i == 0) {
                    boolean validBinary = SelectBinaryPanelVisual.this.validBinary();
                    String validBinaryPath = SelectBinaryPanelVisual.this.getValidBinaryPath();
                    SelectBinaryPanelVisual.this.sourcesField.setEnabled(validBinary);
                    SelectBinaryPanelVisual.this.sourcesButton.setEnabled(validBinary);
                    SelectBinaryPanelVisual.this.dependeciesComboBox.setEnabled(validBinary);
                    SelectBinaryPanelVisual.this.viewComboBox.setEnabled(validBinary);
                    if (validBinary && validBinaryPath != null) {
                        String binaryRoot = CndPathUtilitities.getDirName((String)validBinaryPath);
                        if (binaryRoot != null && (binaryRoot.startsWith(root) || root.startsWith(binaryRoot))) {
                            binaryRoot = null;
                        }
                        SelectBinaryPanelVisual.this.updateTableModel(dlls, root, binaryRoot, true);
                    } else {
                        SelectBinaryPanelVisual.this.updateTableModel(Collections.emptyMap(), root, null, true);
                    }
                }
                if ((errors = (List)map.get("DW:errors")) != null && errors.size() > 0) {
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", errors.get(0));
                } else {
                    SelectBinaryPanelVisual.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
                }
                SelectBinaryPanelVisual.this.validateController();
            }
        });
    }

    private void updateDllArtifacts(final String root, final Map<String, String> checkDll) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = SelectBinaryPanelVisual.this.checking.get();
                if (i == 0) {
                    boolean validBinary = SelectBinaryPanelVisual.this.validBinary();
                    String validBinaryPath = SelectBinaryPanelVisual.this.getValidBinaryPath();
                    if (validBinary && validBinaryPath != null) {
                        String binaryRoot = CndPathUtilitities.getDirName((String)validBinaryPath);
                        if (binaryRoot != null && (binaryRoot.startsWith(root) || root.startsWith(binaryRoot))) {
                            binaryRoot = null;
                        }
                        SelectBinaryPanelVisual.this.updateTableModel(checkDll, root, binaryRoot, false);
                    } else {
                        SelectBinaryPanelVisual.this.updateTableModel(Collections.emptyMap(), root, null, false);
                    }
                }
                SelectBinaryPanelVisual.this.validateController();
            }
        });
    }

    private void updateTableModel(Map<String, String> dlls, String root, String binaryRoot, boolean searching) {
        this.tableModel = new MyDefaultTableModel(this, dlls, root, binaryRoot, searching);
        this.table.setModel(this.tableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(0).setMinWidth(15);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        this.table.getColumnModel().getColumn(0).setCellEditor(new CheckBoxTableCellEditor());
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setMinWidth(50);
        if (this.table.getWidth() > 200) {
            this.table.getColumnModel().getColumn(2).setPreferredWidth(this.table.getWidth() - 100);
        } else {
            this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        }
        this.table.getColumnModel().getColumn(2).setCellRenderer(new PathCellRenderer());
    }

    private void cancelSearch() {
        for (AtomicBoolean cancel : this.cancelable) {
            cancel.set(true);
        }
    }

    private Map<String, String> searchingTable(List<String> dlls) {
        TreeMap<String, String> dllPaths = new TreeMap<String, String>();
        if (dlls != null) {
            for (String dll : dlls) {
                dllPaths.put(dll, null);
            }
        }
        return dllPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> checkDll(List<String> dlls, String root, List<String> searchPaths, String binary) {
        this.cancelSearch();
        AtomicBoolean cancel = new AtomicBoolean(false);
        this.cancelable.add(cancel);
        TreeMap<String, String> dllPaths = new TreeMap<String, String>();
        if (this.validBinary() && dlls != null) {
            String ldLibPath = CommonUtilities.getLdLibraryPath();
            ldLibPath = CommonUtilities.addSearchPaths(ldLibPath, searchPaths, binary);
            boolean search = false;
            for (String dll : dlls) {
                if (cancel.get()) break;
                String p = this.findLocation(dll, ldLibPath);
                if (p != null) {
                    dllPaths.put(dll, p);
                    continue;
                }
                search = true;
                dllPaths.put(dll, null);
            }
            if (!cancel.get() && search && root.length() > 1) {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)SelectBinaryPanelVisual.getString("SearchForUnresolvedDLL"));
                progress.start();
                try {
                    this.gatherSubFolders(new File(root), new HashSet<String>(), dllPaths, cancel);
                }
                finally {
                    progress.finish();
                }
            }
        }
        return dllPaths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherSubFolders(File d, HashSet<String> set, Map<String, String> result, AtomicBoolean cancel) {
        if (cancel.get()) {
            return;
        }
        if (!d.exists() || !d.isDirectory() || !d.canRead()) return;
        String path = d.getAbsolutePath();
        if (set.contains(path = path.replace('\\', '/'))) return;
        set.add(path);
        File[] ff = d.listFiles();
        if (ff == null) return;
        for (int i = 0; i < ff.length; ++i) {
            String name;
            if (cancel.get()) {
                return;
            }
            try {
                String canPath = ff[i].getCanonicalPath();
                String absPath = ff[i].getAbsolutePath();
                if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                    continue;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (result.containsKey(name = ff[i].getName())) {
                result.put(name, ff[i].getAbsolutePath());
            }
            this.gatherSubFolders(ff[i], set, result, cancel);
        }
    }

    private String findLocation(String dll, String ldPath) {
        if (ldPath != null) {
            String pathSepararor = ":";
            if (ldPath.indexOf(59) > 0) {
                pathSepararor = ";";
            }
            for (String search : ldPath.split(pathSepararor)) {
                File file = new File(search, dll);
                if (!file.isFile() || !file.exists()) continue;
                String path = file.getAbsolutePath();
                return path.replace('\\', '/');
            }
        }
        return null;
    }

    private CompilerSet detectCompilerSet(String compiler) {
        boolean isSunStudio = true;
        if (compiler != null) {
            isSunStudio = compiler.indexOf("Sun") >= 0;
        }
        CompilerSetManager manager = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        if (isSunStudio) {
            CompilerSet def = manager.getDefaultCompilerSet();
            if (def != null && def.getCompilerFlavor().isSunStudioCompiler()) {
                return def;
            }
            def = null;
            for (CompilerSet set : manager.getCompilerSets()) {
                if (!set.getCompilerFlavor().isSunStudioCompiler()) continue;
                if ("OracleSolarisStudio".equals(set.getName())) {
                    def = set;
                }
                if (def != null) continue;
                def = set;
            }
            return def;
        }
        CompilerSet def = manager.getDefaultCompilerSet();
        if (def != null && !def.getCompilerFlavor().isSunStudioCompiler()) {
            return def;
        }
        def = null;
        for (CompilerSet set : manager.getCompilerSets()) {
            if (set.getCompilerFlavor().isSunStudioCompiler() || def != null) continue;
            def = set;
        }
        return def;
    }

    private void initComponents() {
        this.binaryLabel = new JLabel();
        this.binaryButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.sourcesLabel = new JLabel();
        this.sourcesField = new JTextField();
        this.sourcesButton = new JButton();
        this.dependenciesLabel = new JLabel();
        this.dependeciesComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.viewLabel = new JLabel();
        this.viewComboBox = new JComboBox();
        this.binaryField = new EditableComboBox();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.binaryLabel.setLabelFor(this.binaryField);
        Mnemonics.setLocalizedText((JLabel)this.binaryLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.binaryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.binaryLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.binaryButton, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.binaryButton.text"));
        this.binaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBinaryPanelVisual.this.binaryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.binaryButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.sourcesLabel.setLabelFor(this.sourcesField);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesField.setText(NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.sourcesField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sourcesButton, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesButton.text"));
        this.sourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBinaryPanelVisual.this.sourcesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.sourcesButton, gridBagConstraints);
        this.dependenciesLabel.setLabelFor(this.dependeciesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.dependenciesLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.dependenciesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.dependenciesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.dependeciesComboBox, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        this.table.setModel(new DefaultTableModel());
        this.jScrollPane1.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.viewLabel.setLabelFor(this.viewComboBox);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.viewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.viewLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.viewComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.binaryField, gridBagConstraints);
    }

    private void binaryButtonActionPerformed(ActionEvent evt) {
        String path = this.selectBinaryFile(((EditableComboBox)this.binaryField).getText());
        if (path == null) {
            return;
        }
        ((EditableComboBox)this.binaryField).setText(path);
    }

    private void sourcesButtonActionPerformed(ActionEvent evt) {
        String seed = this.sourcesField.getText();
        FileChooser fileChooser = new FileChooser(SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Source.Browse.Title"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Source.Browse.Select"), 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null) {
            String path = selectedFile.getPath();
            this.sourcesField.setText(path);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        ((EditableComboBox)this.binaryField).setStorage(BINARY_FILE_KEY, NbPreferences.forModule(SelectBinaryPanelVisual.class));
        String binary = (String)wizardDescriptor.getProperty("outputTextField");
        if (binary == null) {
            binary = "";
        }
        ((EditableComboBox)this.binaryField).read(binary);
    }

    void store(WizardDescriptor wizardDescriptor) {
        this.cancelSearch();
        wizardDescriptor.putProperty("outputTextField", (Object)((EditableComboBox)this.binaryField).getText().trim());
        wizardDescriptor.putProperty("displayName", (Object)new File(((EditableComboBox)this.binaryField).getText().trim()).getName());
        wizardDescriptor.putProperty("sourceFolderPath", (Object)this.sourcesField.getText().trim());
        wizardDescriptor.putProperty("dependencyKind", (Object)((ProjectKindItem)this.dependeciesComboBox.getSelectedItem()).kind);
        wizardDescriptor.putProperty("dependencies", this.getDlls());
        wizardDescriptor.putProperty("trueSourceRoot", (Object)((ProjectView)this.viewComboBox.getSelectedItem()).isSourceRoot);
        ((EditableComboBox)this.binaryField).setStorage(BINARY_FILE_KEY, NbPreferences.forModule(SelectBinaryPanelVisual.class));
        ((EditableComboBox)this.binaryField).store();
        wizardDescriptor.putProperty("makefileName", (Object)"");
    }

    private ArrayList<String> getDlls() {
        ArrayList<String> dlls = new ArrayList<String>();
        if (((ProjectKindItem)this.dependeciesComboBox.getSelectedItem()).kind == IteratorExtension.ProjectKind.Minimal) {
            return dlls;
        }
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            if (!((Boolean)this.table.getModel().getValueAt(i, 0)).booleanValue()) continue;
            dlls.add((String)this.table.getModel().getValueAt(i, 2));
        }
        return dlls;
    }

    boolean valid() {
        return this.checking.get() == 0 && this.validBinary() && this.validSourceRoot() && this.validDlls();
    }

    private String getValidBinaryPath() {
        String path = ((EditableComboBox)this.binaryField).getText().trim();
        if (path.isEmpty()) {
            return null;
        }
        if (CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
            return CndFileUtils.normalizeAbsolutePath((String)path);
        }
        return null;
    }

    private boolean validBinary() {
        String validBinaryPath = this.getValidBinaryPath();
        if (validBinaryPath != null) {
            FileObject fo = CndFileUtils.toFileObject((CharSequence)validBinaryPath);
            if (fo == null || !fo.isValid()) {
                return false;
            }
            return MIMENames.isBinary((String)fo.getMIMEType());
        }
        return false;
    }

    private boolean validSourceRoot() {
        String path = this.sourcesField.getText().trim();
        if (path.isEmpty()) {
            return false;
        }
        if (CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
            FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)path));
            if (fo == null || !fo.isValid()) {
                return false;
            }
            return fo.isFolder();
        }
        return false;
    }

    private boolean validDlls() {
        for (String dll : this.getDlls()) {
            if (new File(dll).exists()) continue;
            return false;
        }
        return true;
    }

    private void onClickAction(MouseEvent e) {
        TableColumnModel columnModel;
        int viewColumn;
        int col;
        int rowIndex = this.table.rowAtPoint(e.getPoint());
        if (rowIndex >= 0 && (col = this.table.convertColumnIndexToModel(viewColumn = (columnModel = this.table.getColumnModel()).getColumnIndexAtX(e.getX()))) == 2) {
            Rectangle rect = this.table.getCellRect(rowIndex, viewColumn, false);
            Point point = new Point(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
            if (rect.width - 20 <= point.x && point.x <= rect.width) {
                this.tableButtonActionPerformed(rowIndex);
            }
        }
    }

    private String selectBinaryFile(String path) {
        FileFilter[] filters = FileFilterFactory.getBinaryFilters();
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Title"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Select"), 0, filters, path, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return null;
        }
        return fileChooser.getSelectedFile().getPath();
    }

    private void tableButtonActionPerformed(int row) {
        String path = this.selectBinaryFile((String)this.table.getModel().getValueAt(row, 2));
        if (path == null) {
            return;
        }
        this.table.getModel().setValueAt(path, row, 2);
    }

    private static String getString(String key) {
        return NbBundle.getBundle(SelectBinaryPanelVisual.class).getString(key);
    }

    private static final class MyDefaultTableModel
    extends DefaultTableModel {
        private List<Boolean> uses = new ArrayList<Boolean>();
        private List<String> names = new ArrayList<String>();
        private List<String> paths = new ArrayList<String>();
        private final SelectBinaryPanelVisual parent;
        private final boolean searching;

        private MyDefaultTableModel(SelectBinaryPanelVisual parent, Map<String, String> dlls, String root, String binaryRoot, boolean searching) {
            super(new String[]{SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col0"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col1"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col2")}, 0);
            this.searching = searching;
            for (Map.Entry<String, String> entry : dlls.entrySet()) {
                String dll = entry.getKey();
                this.names.add(dll);
                String path = entry.getValue();
                if (path == null) {
                    this.uses.add(Boolean.FALSE);
                    if (searching) {
                        this.paths.add(SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col.searching"));
                        continue;
                    }
                    this.paths.add(SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col.notfound"));
                    continue;
                }
                if (this.isMyDll(path, root) || this.isMyDll(path, binaryRoot)) {
                    this.uses.add(Boolean.TRUE);
                } else {
                    this.uses.add(Boolean.FALSE);
                }
                this.paths.add(path);
            }
            this.parent = parent;
        }

        private boolean isMyDll(String path, String root) {
            if (root == null) {
                return false;
            }
            path = path.replace('\\', '/');
            root = root.replace('\\', '/');
            if (path.startsWith("/usr/lib/")) {
                return false;
            }
            if (path.startsWith("/lib/")) {
                return false;
            }
            if (path.startsWith("/usr/local/lib/")) {
                return false;
            }
            if (path.startsWith(root)) {
                return true;
            }
            String[] p1 = path.split("/");
            String[] p2 = root.split("/");
            for (int i = 0; i < Math.min(p1.length - 1, p2.length); ++i) {
                if (!p1[i].equals(p2[i])) {
                    return i > 3;
                }
                if (i <= 3) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.uses.get(row);
                }
                case 1: {
                    return this.names.get(row);
                }
                case 2: {
                    return this.paths.get(row);
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    this.uses.set(row, (Boolean)value);
                    this.parent.validateController();
                    return;
                }
                case 1: {
                    this.names.set(row, (String)value);
                    return;
                }
                case 2: {
                    this.paths.set(row, (String)value);
                    this.parent.validateController();
                    return;
                }
            }
            super.setValueAt(value, row, column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this.uses == null) {
                return 0;
            }
            return this.uses.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (this.searching) {
                return false;
            }
            return col != 1;
        }
    }

    private static final class CheckBoxTableCellEditor
    extends DefaultCellEditor {
        private CheckBoxTableCellEditor() {
            super(new JCheckBox());
            ((JCheckBox)this.getEditorComponent()).setHorizontalAlignment(0);
            ((JCheckBox)this.getEditorComponent()).setBorderPainted(true);
        }

        public final JComponent getEditorComponent() {
            return this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static final class PathCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private static final Border noFocusButtonBorder = new LineBorder(Color.GRAY, 1);
        private final JTextField field = new JTextField();
        private final JButton button = new JButton("...");
        private final Color textFieldColor;
        private final Color redTextFieldColor;

        public PathCellRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.field, "Center");
            this.field.setBorder(noFocusBorder);
            this.textFieldColor = this.field.getForeground();
            this.redTextFieldColor = new Color(this.field.getBackground().getRed(), this.textFieldColor.getGreen(), this.textFieldColor.getBlue());
            this.add((Component)this.button, "East");
            this.button.setPreferredSize(new Dimension(20, 5));
            this.button.setMaximumSize(new Dimension(20, 20));
            this.button.setBorder(noFocusButtonBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.field.setText(value.toString());
            if (table.getModel().isCellEditable(row, column)) {
                this.field.setEnabled(true);
                this.button.setEnabled(true);
            } else {
                this.field.setEnabled(false);
                this.button.setEnabled(false);
            }
            if (new File(value.toString()).exists()) {
                this.field.setForeground(this.textFieldColor);
            } else {
                this.field.setForeground(this.redTextFieldColor);
            }
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private static final class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final JLabel emptyLabel = new JLabel();

        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.emptyLabel.setBorder(noFocusBorder);
            this.emptyLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result;
            if (value == null) {
                result = this.emptyLabel;
            } else {
                this.setSelected((Boolean)value);
                this.setEnabled(table.getModel().isCellEditable(row, column));
                result = this;
            }
            result.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            result.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return result;
        }
    }

    private static final class ProjectView {
        private boolean isSourceRoot;

        ProjectView(boolean isSourceRoot) {
            this.isSourceRoot = isSourceRoot;
        }

        public String toString() {
            if (this.isSourceRoot) {
                return SelectBinaryPanelVisual.getString("ProjectViewSource");
            }
            return SelectBinaryPanelVisual.getString("ProjectViewLogical");
        }
    }

    private static final class ProjectKindItem {
        private final IteratorExtension.ProjectKind kind;

        ProjectKindItem(IteratorExtension.ProjectKind kind) {
            this.kind = kind;
        }

        public String toString() {
            return SelectBinaryPanelVisual.getString("ProjectItemKind_" + (Object)((Object)this.kind));
        }
    }
}

