/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewMakeProjectWizardIterator;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectModeDescriptorPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
NewMakeProjectWizardIterator.Name,
ChangeListener {
    private WizardDescriptor wizardDescriptor;
    private SelectModePanel component;
    private String name;
    private final WizardStorage wizardStorage;
    private boolean isValid = false;
    private final boolean fullRemote;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SelectModeDescriptorPanel(boolean fullRemote) {
        this.name = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeName");
        this.fullRemote = fullRemote;
        this.wizardStorage = new WizardStorage(fullRemote);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isFullRemote() {
        return this.fullRemote;
    }

    public SelectModePanel getComponent() {
        if (this.component == null) {
            this.component = new SelectModePanel(this);
            this.component.setName(this.name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewMakeWizardP0");
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void validate() {
        this.isValid = this.component.valid();
        this.fireChangeEvent();
    }

    private void setMode(boolean isSimple) {
        if (isSimple) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        } else {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    WizardDescriptor getWizardDescriptor() {
        return this.wizardDescriptor;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = this.component.getClientProperty("WizardPanel_contentData");
        String[] names = (String[])o;
        String[] res = Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode")) ? new String[]{names[0]} : new String[]{names[0], "..."};
        this.component.putClientProperty("WizardPanel_contentData", res);
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode"));
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        if (this.wizardDescriptor.getProperty("simpleMode") == null) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        }
        this.getComponent().read(this.wizardDescriptor);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent().store(settings);
    }

    public WizardStorage getWizardStorage() {
        return this.wizardStorage;
    }

    public static class WizardDescriptorAdapter
    extends WizardDescriptor {
        private WizardStorage storage;

        public WizardDescriptorAdapter(WizardStorage storage) {
            this.storage = storage;
        }

        public synchronized Object getProperty(String name) {
            if ("realFlags".equals(name)) {
                return this.storage.getRealFlags();
            }
            if ("buildProject".equals(name)) {
                if (this.storage.isBuildProject()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("setMain".equals(name)) {
                if (this.storage.isSetMain()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("simpleMode".equals(name)) {
                return Boolean.TRUE;
            }
            if ("makefileName".equals(name)) {
                return this.storage.getMake();
            }
            if ("configureName".equals(name)) {
                return this.storage.getConfigure();
            }
            if ("hostUID".equals(name)) {
                return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.storage.env);
            }
            if ("toolchain".equals(name)) {
                return this.storage.cs;
            }
            if ("toolchainDefault".equals(name)) {
                return this.storage.defaultCompilerSet;
            }
            if ("fullRemote".equals(name)) {
                return this.storage.fullRemote;
            }
            if ("nativeProjDir".equals(name)) {
                return this.storage.getSourcesFileObject().getPath();
            }
            if ("nativeProjFO".equals(name)) {
                return this.storage.getSourcesFileObject();
            }
            if ("projdir".equals(name)) {
                return new File(this.storage.getProjectPath());
            }
            return super.getProperty(name);
        }
    }

    public class WizardStorage {
        private String path = "";
        private FileObject fileObject;
        private String flags = "";
        private boolean setMain = true;
        private boolean buildProject = true;
        private CompilerSet cs;
        private boolean defaultCompilerSet;
        private ExecutionEnvironment env;
        private final boolean fullRemote;
        private FileObject makefileFO;

        public WizardStorage(boolean fullRemote) {
            this.fullRemote = fullRemote;
            this.env = ServerList.getDefaultRecord().getExecutionEnvironment();
        }

        public void setMode(boolean isSimple) {
            SelectModeDescriptorPanel.this.setMode(isSimple);
        }

        public boolean isFullRemote() {
            return this.fullRemote;
        }

        public String getProjectPath() {
            return this.path;
        }

        public FileObject getSourcesFileObject() {
            return this.fileObject;
        }

        public void setProjectPath(String path) {
            this.path = path.trim();
            SelectModeDescriptorPanel.this.validate();
        }

        public void setSourcesFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
            SelectModeDescriptorPanel.this.validate();
        }

        public String getConfigure() {
            if (this.path.length() == 0) {
                return null;
            }
            if (this.fileObject != null) {
                return ConfigureUtils.findConfigureScript(this.fileObject);
            }
            return ConfigureUtils.findConfigureScript(this.path);
        }

        public String getMake() {
            return this.makefileFO == null ? null : this.makefileFO.getPath();
        }

        public void setMake(FileObject makefileFO) {
            this.makefileFO = makefileFO;
        }

        public String getFlags() {
            return this.flags;
        }

        public String getRealFlags() {
            return ConfigureUtils.getConfigureArguments(this.env, this.cs, this.getConfigure(), this.flags);
        }

        public void setFlags(String flags) {
            this.flags = flags;
            SelectModeDescriptorPanel.this.validate();
        }

        public boolean isSetMain() {
            return this.setMain;
        }

        public void setSetMain(boolean setMain) {
            this.setMain = setMain;
            SelectModeDescriptorPanel.this.validate();
        }

        public boolean isBuildProject() {
            return this.buildProject;
        }

        public void setBuildProject(boolean buildProject) {
            this.buildProject = buildProject;
            SelectModeDescriptorPanel.this.validate();
        }

        void setCompilerSet(CompilerSet cs) {
            this.cs = cs;
        }

        void setExecutionEnvironment(ExecutionEnvironment ee) {
            this.env = ee;
        }

        void setDefaultCompilerSet(boolean defaultCompilerSet) {
            this.defaultCompilerSet = defaultCompilerSet;
        }
    }
}

